/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing.operation;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.operator.MosaicDescriptor;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridEnvelope2D;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.grid.ViewType;
import org.geotoolkit.coverage.processing.AbstractCoverageProcessor;
import org.geotoolkit.coverage.processing.CannotReprojectException;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.coverage.CoverageUtilities;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.io.LineFormat;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.referencing.operation.transform.DimensionFilter;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.WarpFactory;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

final class Resampler2D
extends GridCoverage2D {
    private static final long serialVersionUID = -8593569923766544474L;
    private static final PixelOrientation CORNER = PixelOrientation.UPPER_LEFT;
    private static final int EMPIRICAL_ADJUSTMENT_STEPS = 16;
    private static final double EPS = 1.0E-6;
    private static final Level LOGGING_LEVEL = Level.FINE;

    private Resampler2D(GridCoverage2D gridCoverage2D, PlanarImage planarImage, GridGeometry2D gridGeometry2D, GridSampleDimension[] gridSampleDimensionArray, Hints hints) {
        super((CharSequence)gridCoverage2D.getName(), (RenderedImage)planarImage, gridGeometry2D, gridSampleDimensionArray, (GridCoverage[])new GridCoverage2D[]{gridCoverage2D}, null, hints);
    }

    private static GridCoverage2D create(GridCoverage2D gridCoverage2D, PlanarImage planarImage, GridGeometry2D gridGeometry2D, ViewType viewType, Hints hints) {
        GridSampleDimension[] gridSampleDimensionArray;
        switch (viewType) {
            case PHOTOGRAPHIC: {
                gridSampleDimensionArray = null;
                break;
            }
            default: {
                gridSampleDimensionArray = gridCoverage2D.getSampleDimensions();
            }
        }
        GridCoverage2D gridCoverage2D2 = new Resampler2D(gridCoverage2D, planarImage, gridGeometry2D, gridSampleDimensionArray, hints);
        gridCoverage2D2 = gridCoverage2D2.view(viewType);
        return gridCoverage2D2;
    }

    public static GridCoverage2D reproject(GridCoverage2D gridCoverage2D, CoordinateReferenceSystem coordinateReferenceSystem, GridGeometry2D gridGeometry2D, Interpolation interpolation, double[] dArray, Hints hints) throws FactoryException, TransformException {
        InternationalString internationalString;
        Object object;
        Object object2;
        Object object3;
        InternationalString internationalString2;
        Object object4;
        Object object5;
        GeneralEnvelope generalEnvelope;
        Object object6;
        Object object7;
        Object object8;
        MathTransform mathTransform;
        LinearTransform linearTransform;
        MathTransform mathTransform2;
        CoordinateReferenceSystem coordinateReferenceSystem2;
        GridGeometry2D gridGeometry2D2;
        GridCoverage2D gridCoverage2D2;
        boolean bl;
        boolean bl2;
        CoordinateReferenceSystem coordinateReferenceSystem3 = gridCoverage2D.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            coordinateReferenceSystem = coordinateReferenceSystem3;
        }
        if (gridGeometry2D == null) {
            bl2 = true;
            bl = true;
        } else {
            boolean bl3 = bl = !gridGeometry2D.isDefined(4);
            if (!bl || gridGeometry2D.isDefined(8)) {
                bl2 = false;
            } else if (gridGeometry2D.isDefined(2)) {
                gridCoverage2D2 = gridGeometry2D.getEnvelope();
                gridGeometry2D2 = gridCoverage2D.getGridGeometry();
                switch (gridCoverage2D2.getDimension()) {
                    case 2: {
                        coordinateReferenceSystem2 = gridGeometry2D2.getGridToCRS2D(CORNER);
                        break;
                    }
                    default: {
                        coordinateReferenceSystem2 = gridGeometry2D2.getGridToCRS(CORNER);
                    }
                }
                gridGeometry2D = new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)coordinateReferenceSystem2, (Envelope)gridCoverage2D2, null);
                bl2 = false;
            } else {
                gridGeometry2D = null;
                bl2 = true;
            }
        }
        gridCoverage2D2 = Resampler2D.existingCoverage(gridCoverage2D, coordinateReferenceSystem, gridGeometry2D);
        if (gridCoverage2D2 != null) {
            return gridCoverage2D2;
        }
        gridGeometry2D2 = gridCoverage2D.getGridGeometry();
        coordinateReferenceSystem2 = Resampler2D.compatibleSourceCRS(gridCoverage2D.getCoordinateReferenceSystem2D(), coordinateReferenceSystem3, coordinateReferenceSystem);
        ViewType viewType = CoverageUtilities.preferredViewForOperation(gridCoverage2D, interpolation, false, (RenderingHints)hints);
        ViewType viewType2 = CoverageUtilities.preferredViewAfterOperation(gridCoverage2D);
        gridCoverage2D = gridCoverage2D.view(viewType);
        PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)gridCoverage2D.getRenderedImage());
        assert (gridCoverage2D.getCoordinateReferenceSystem() == coordinateReferenceSystem3) : gridCoverage2D;
        CoordinateOperationFactory coordinateOperationFactory = FactoryFinder.getCoordinateOperationFactory((Hints)hints);
        MathTransformFactory mathTransformFactory = coordinateOperationFactory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)coordinateOperationFactory).getMathTransformFactory() : FactoryFinder.getMathTransformFactory((Hints)hints);
        if (CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem3, (Object)coordinateReferenceSystem)) {
            if (!gridGeometry2D.isDefined(8)) {
                mathTransform2 = gridGeometry2D2.getGridToCRS(CORNER);
                linearTransform = MathTransforms.identity((int)mathTransform2.getTargetDimensions());
                mathTransform = mathTransform2.inverse();
                object8 = MathTransforms.identity((int)mathTransform2.getSourceDimensions());
                gridGeometry2D = new GridGeometry2D(gridGeometry2D.getExtent(), mathTransform2, coordinateReferenceSystem);
            } else {
                mathTransform2 = gridGeometry2D.getGridToCRS(CORNER);
                linearTransform = MathTransforms.identity((int)mathTransform2.getTargetDimensions());
                mathTransform = gridGeometry2D2.getGridToCRS(CORNER).inverse();
                object8 = mathTransformFactory.createConcatenatedTransform(mathTransform2, mathTransform);
                if (!gridGeometry2D.isDefined(4)) {
                    object7 = Resampler2D.toEnvelope(gridGeometry2D2.getExtent());
                    object7 = Envelopes.transform((MathTransform)object8.inverse(), (Envelope)object7);
                    gridGeometry2D = new GridGeometry2D(new GeneralGridEnvelope((Envelope)object7, PixelInCell.CELL_CORNER, false), mathTransform2, coordinateReferenceSystem);
                }
            }
        } else {
            if (coordinateReferenceSystem3 == null) {
                throw new CannotReprojectException(Errors.format((int)234));
            }
            object6 = coordinateOperationFactory.createOperation(coordinateReferenceSystem3, coordinateReferenceSystem);
            boolean bl4 = coordinateReferenceSystem3 != coordinateReferenceSystem2;
            linearTransform = coordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
            mathTransform = (bl4 ? gridGeometry2D2.getGridToCRS2D(CORNER) : gridGeometry2D2.getGridToCRS(CORNER)).inverse();
            object7 = gridCoverage2D.getEnvelope();
            generalEnvelope = Envelopes.transform((CoordinateOperation)object6, (Envelope)object7);
            generalEnvelope.setCoordinateReferenceSystem(coordinateReferenceSystem);
            if (gridGeometry2D == null) {
                object5 = bl4 ? new GeneralGridEnvelope(gridGeometry2D2.getExtent2D()) : gridGeometry2D2.getExtent();
                gridGeometry2D = new GridGeometry2D((GridEnvelope)object5, (Envelope)generalEnvelope);
                mathTransform2 = gridGeometry2D.getGridToCRS(CORNER);
            } else if (!gridGeometry2D.isDefined(8)) {
                gridGeometry2D = new GridGeometry2D(gridGeometry2D.getExtent(), (Envelope)generalEnvelope);
                mathTransform2 = gridGeometry2D.getGridToCRS(CORNER);
            } else {
                mathTransform2 = gridGeometry2D.getGridToCRS(CORNER);
                if (!gridGeometry2D.isDefined(4)) {
                    object5 = Envelopes.transform((MathTransform)mathTransform2.inverse(), (Envelope)generalEnvelope);
                    gridGeometry2D = new GridGeometry2D(new GeneralGridEnvelope((Envelope)object5, PixelInCell.CELL_CENTER, false), mathTransform2, coordinateReferenceSystem);
                }
            }
            object8 = mathTransform2.equals(mathTransform.inverse()) ? linearTransform : mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createConcatenatedTransform(mathTransform2, (MathTransform)linearTransform), mathTransform);
        }
        MathTransform2D mathTransform2D = Resampler2D.toMathTransform2D((MathTransform)object8, mathTransformFactory, gridGeometry2D);
        if (!(mathTransform2D instanceof MathTransform2D)) {
            throw new TransformException(Errors.format((int)168));
        }
        object7 = viewType.getRenderingHints((RenderedImage)planarImage);
        if (hints != null) {
            ((RenderingHints)object7).add((RenderingHints)hints);
        }
        generalEnvelope = (generalEnvelope = (ImageLayout)((RenderingHints)object7).get(JAI.KEY_IMAGE_LAYOUT)) != null ? (ImageLayout)generalEnvelope.clone() : new ImageLayout();
        object6 = gridGeometry2D2.getExtent2D();
        GridEnvelope2D gridEnvelope2D = gridGeometry2D.getExtent2D();
        if (Resampler2D.isBoundsUndefined((ImageLayout)generalEnvelope, false)) {
            generalEnvelope.setMinX(gridEnvelope2D.x);
            generalEnvelope.setMinY(gridEnvelope2D.y);
            generalEnvelope.setWidth(gridEnvelope2D.width);
            generalEnvelope.setHeight(gridEnvelope2D.height);
        }
        if (Resampler2D.isBoundsUndefined((ImageLayout)generalEnvelope, true)) {
            object5 = new Dimension(generalEnvelope.getWidth((RenderedImage)planarImage), generalEnvelope.getHeight((RenderedImage)planarImage));
            object5 = ImageUtilities.toTileSize((Dimension)object5);
            generalEnvelope.setTileGridXOffset(generalEnvelope.getMinX((RenderedImage)planarImage));
            generalEnvelope.setTileGridYOffset(generalEnvelope.getMinY((RenderedImage)planarImage));
            generalEnvelope.setTileWidth(((Dimension)object5).width);
            generalEnvelope.setTileHeight(((Dimension)object5).height);
        }
        if (dArray == null) {
            dArray = CoverageUtilities.getBackgroundValues(gridCoverage2D);
        }
        if (dArray != null && dArray.length != 0 && !bl) {
            object5 = ArraysExt.allEquals((double[])dArray, (double)0.0) ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(dArray);
            hints.put((Object)JAI.KEY_BORDER_EXTENDER, object5);
        }
        if (viewType == ViewType.PHOTOGRAPHIC) {
            generalEnvelope.unsetValid(768);
        }
        ((RenderingHints)object7).put(JAI.KEY_IMAGE_LAYOUT, generalEnvelope);
        ParameterBlock parameterBlock = new ParameterBlock().addSource(planarImage);
        if (object8.isIdentity() || object8 instanceof AffineTransform && XAffineTransform.isIdentity((AffineTransform)((AffineTransform)object8), (double)1.0E-6)) {
            gridCoverage2D = gridCoverage2D.view(ViewType.NATIVE);
            planarImage = PlanarImage.wrapRenderedImage((RenderedImage)gridCoverage2D.getRenderedImage());
            parameterBlock.removeSources();
            parameterBlock.addSource(planarImage);
            if (gridEnvelope2D.equals(object6)) {
                gridCoverage2D = gridCoverage2D.view(viewType2);
                planarImage = PlanarImage.wrapRenderedImage((RenderedImage)gridCoverage2D.getRenderedImage());
                return Resampler2D.create(gridCoverage2D, planarImage, gridGeometry2D, ViewType.SAME, hints);
            }
            if (((Rectangle)object6).contains(gridEnvelope2D)) {
                object5 = "Crop";
                parameterBlock.add(Float.valueOf(gridEnvelope2D.x)).add(Float.valueOf(gridEnvelope2D.y)).add(Float.valueOf(gridEnvelope2D.width)).add(Float.valueOf(gridEnvelope2D.height));
            } else {
                object5 = "Mosaic";
                parameterBlock.add(MosaicDescriptor.MOSAIC_TYPE_OVERLAY).add(null).add(null).add(null).add(dArray);
            }
        } else if ((bl || gridEnvelope2D.equals(object6)) && object8 instanceof AffineTransform) {
            if (bl2) {
                MathTransform mathTransform3 = gridGeometry2D2.getGridToCRS(CORNER);
                mathTransform3 = mathTransformFactory.createConcatenatedTransform(mathTransform3, linearTransform.inverse());
                gridGeometry2D = new GridGeometry2D(gridGeometry2D2.getExtent(), mathTransform3, coordinateReferenceSystem);
                return Resampler2D.create(gridCoverage2D, planarImage, gridGeometry2D, viewType2, hints);
            }
            object5 = "Affine";
            AffineTransform affineTransform = (AffineTransform)object8.inverse();
            parameterBlock.add(affineTransform).add(interpolation).add(dArray);
        } else {
            boolean bl5 = false;
            switch (planarImage.getSampleModel().getTransferType()) {
                case 4: 
                case 5: {
                    object4 = Envelopes.transform((Envelope)gridGeometry2D2.getEnvelope(), (CoordinateReferenceSystem)coordinateReferenceSystem);
                    internationalString2 = Envelopes.transform((Envelope)gridGeometry2D.getEnvelope(), (CoordinateReferenceSystem)coordinateReferenceSystem);
                    object4 = gridGeometry2D.reduce((Envelope)object4);
                    internationalString2 = gridGeometry2D.reduce((Envelope)internationalString2);
                    if (AbstractEnvelope.castOrCopy((Envelope)object4).contains((Envelope)internationalString2, true)) break;
                    if (interpolation != null && !(interpolation instanceof InterpolationNearest)) {
                        return Resampler2D.reproject(gridCoverage2D, coordinateReferenceSystem, gridGeometry2D, null, dArray, hints);
                    }
                    bl5 = true;
                }
            }
            object4 = mathTransform2D;
            internationalString2 = gridCoverage2D.getName();
            object5 = "Warp";
            if (bl5) {
                object3 = WarpFactory.DEFAULT.create((CharSequence)internationalString2, (MathTransform2D)object4, gridEnvelope2D);
            } else {
                object2 = generalEnvelope.getMinX((RenderedImage)planarImage) == gridEnvelope2D.x && generalEnvelope.getMinY((RenderedImage)planarImage) == gridEnvelope2D.y && generalEnvelope.getWidth((RenderedImage)planarImage) == gridEnvelope2D.width && generalEnvelope.getHeight((RenderedImage)planarImage) == gridEnvelope2D.height ? (Object)gridEnvelope2D : null;
                object3 = Resampler2D.createWarp((CharSequence)internationalString2, (Rectangle)object6, object2, object4, mathTransformFactory);
            }
            parameterBlock.add(object3).add(interpolation).add(dArray);
        }
        RenderedOp renderedOp = Resampler2D.getJAI(hints).createNS((String)object5, parameterBlock, (RenderingHints)object7);
        object4 = gridCoverage2D.getLocale();
        internationalString2 = gridGeometry2D.getExtent();
        object3 = internationalString2.getLow().getCoordinateValues();
        object2 = internationalString2.getHigh().getCoordinateValues();
        int n = 0;
        while (n < ((int[])object2).length) {
            int n2 = n++;
            object2[n2] = object2[n2] + 1;
        }
        object3[gridGeometry2D.gridDimensionX] = (Warp)renderedOp.getMinX();
        object3[gridGeometry2D.gridDimensionY] = (Warp)renderedOp.getMinY();
        object2[gridGeometry2D.gridDimensionX] = renderedOp.getMaxX();
        object2[gridGeometry2D.gridDimensionY] = renderedOp.getMaxY();
        GeneralGridEnvelope generalGridEnvelope = new GeneralGridEnvelope((int[])object3, (int[])object2, false);
        if (!internationalString2.equals(generalGridEnvelope)) {
            object = gridGeometry2D.getGridToCRS();
            gridGeometry2D = new GridGeometry2D(generalGridEnvelope, (MathTransform)object, coordinateReferenceSystem);
            if (!bl) {
                internationalString = gridCoverage2D.getName();
                Resampler2D.log(Loggings.getResources((Locale)object4).getLogRecord(Level.WARNING, 0, internationalString != null ? internationalString.toString((Locale)object4) : gridCoverage2D.getClass()));
            }
        }
        gridCoverage2D2 = Resampler2D.create(gridCoverage2D, (PlanarImage)renderedOp, gridGeometry2D, viewType2, hints);
        assert (InternalUtilities.debugEquals((Object)gridCoverage2D2.getCoordinateReferenceSystem(), (Object)coordinateReferenceSystem)) : gridGeometry2D;
        assert (gridCoverage2D2.getGridGeometry().getExtent2D().equals(renderedOp.getBounds())) : gridGeometry2D;
        if (AbstractCoverageProcessor.LOGGER.isLoggable(LOGGING_LEVEL)) {
            object = dArray == null ? "No background used" : (dArray.length != 1 ? new LineFormat((Locale)object4).format((Object)dArray) : (Double.isNaN(dArray[0]) ? "NaN" : Double.valueOf(dArray[0])));
            internationalString = gridCoverage2D.getName();
            Resampler2D.log(Loggings.getResources((Locale)object4).getLogRecord(LOGGING_LEVEL, 3, (Object)new Object[]{internationalString != null ? internationalString.toString((Locale)object4) : gridCoverage2D.getClass(), gridCoverage2D.getCoordinateReferenceSystem().getName().getCode(), planarImage.getWidth(), planarImage.getHeight(), gridCoverage2D2.getCoordinateReferenceSystem().getName().getCode(), renderedOp.getWidth(), renderedOp.getHeight(), renderedOp.getOperationName(), gridCoverage2D == gridCoverage2D.view(ViewType.GEOPHYSICS) ? 1 : 0, ImageUtilities.getInterpolationName(interpolation), object}));
        }
        return gridCoverage2D2;
    }

    private static GridCoverage2D existingCoverage(GridCoverage2D gridCoverage2D, CoordinateReferenceSystem coordinateReferenceSystem, GridGeometry2D gridGeometry2D) {
        while (!Resampler2D.equivalent(gridCoverage2D.getGridGeometry(), gridGeometry2D) || !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)gridCoverage2D.getCoordinateReferenceSystem()) && !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)gridCoverage2D.getCoordinateReferenceSystem2D())) {
            if (!(gridCoverage2D instanceof Resampler2D)) {
                return null;
            }
            List<GridCoverage> list = gridCoverage2D.getSources();
            assert (list.size() == 1) : list;
            gridCoverage2D = (GridCoverage2D)list.get(0);
        }
        return gridCoverage2D;
    }

    private static JAI getJAI(Hints hints) {
        Object object;
        if (hints != null && (object = hints.get((Object)Hints.JAI_INSTANCE)) instanceof JAI) {
            return (JAI)object;
        }
        return JAI.getDefaultInstance();
    }

    private static boolean isBoundsUndefined(ImageLayout imageLayout, boolean bl) {
        int n = bl ? 240 : 15;
        return (imageLayout.getValidMask() & n) == 0;
    }

    private static CoordinateReferenceSystem compatibleSourceCRS(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3) {
        int n = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        return coordinateReferenceSystem3.getCoordinateSystem().getDimension() == n && coordinateReferenceSystem2.getCoordinateSystem().getDimension() > n ? coordinateReferenceSystem : coordinateReferenceSystem2;
    }

    private static MathTransform2D toMathTransform2D(MathTransform mathTransform, MathTransformFactory mathTransformFactory, GridGeometry2D gridGeometry2D) throws FactoryException {
        DimensionFilter dimensionFilter = new DimensionFilter(mathTransformFactory);
        dimensionFilter.addSourceDimension(gridGeometry2D.axisDimensionX);
        dimensionFilter.addSourceDimension(gridGeometry2D.axisDimensionY);
        MathTransform mathTransform2 = dimensionFilter.separate(mathTransform);
        if (mathTransform2 instanceof MathTransform2D) {
            return (MathTransform2D)mathTransform2;
        }
        dimensionFilter.addTargetDimension(gridGeometry2D.axisDimensionX);
        dimensionFilter.addTargetDimension(gridGeometry2D.axisDimensionY);
        mathTransform2 = dimensionFilter.separate(mathTransform);
        if (mathTransform2 instanceof MathTransform2D) {
            return (MathTransform2D)mathTransform2;
        }
        throw new FactoryException(Errors.format((int)168));
    }

    private static boolean equivalent(GridGeometry2D gridGeometry2D, GridGeometry2D gridGeometry2D2) {
        if (gridGeometry2D2 == null || gridGeometry2D2.equals(gridGeometry2D)) {
            return true;
        }
        if (gridGeometry2D2.isDefined(4) && gridGeometry2D.isDefined(4) && !gridGeometry2D2.getExtent().equals(gridGeometry2D.getExtent())) {
            return false;
        }
        return !gridGeometry2D2.isDefined(8) || !gridGeometry2D.isDefined(8) || gridGeometry2D2.getGridToCRS().equals(gridGeometry2D.getGridToCRS());
    }

    private static Envelope toEnvelope(GridEnvelope gridEnvelope) {
        int n = gridEnvelope.getDimension();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = gridEnvelope.getLow(i);
            dArray2[i] = gridEnvelope.getHigh(i) + 1;
        }
        return new GeneralEnvelope(dArray, dArray2);
    }

    private static Warp createWarp(CharSequence charSequence, Rectangle rectangle, Rectangle rectangle2, MathTransform2D mathTransform2D, MathTransformFactory mathTransformFactory) throws FactoryException, TransformException {
        MathTransform2D mathTransform2D2 = mathTransform2D;
        Object var6_6 = null;
        boolean bl = false;
        if (var6_6 != null) {
            double d = 1.0 - (double)rectangle.width / (double)var6_6.width;
            double d2 = 1.0 - (double)rectangle.height / (double)var6_6.height;
            double d3 = rectangle.x - var6_6.x;
            double d4 = rectangle.y - var6_6.y;
            double d5 = (double)bl / 16.0;
            AffineTransform2D affineTransform2D = new AffineTransform2D(1.0 - d * d5, 0.0, 0.0, 1.0 - d2 * d5, d3 * d5, d4 * d5);
            mathTransform2D2 = (MathTransform2D)mathTransformFactory.createConcatenatedTransform((MathTransform)mathTransform2D, (MathTransform)affineTransform2D);
        }
        Warp warp = WarpFactory.DEFAULT.create(charSequence, mathTransform2D2, rectangle2);
        return warp;
    }

    private static void log(LogRecord logRecord) {
        logRecord.setSourceClassName("Resample");
        logRecord.setSourceMethodName("doOperation");
        Logger logger = AbstractCoverageProcessor.LOGGER;
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
    }
}

