/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing.operation;

import javax.media.jai.Interpolation;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.processing.CannotReprojectException;
import org.geotoolkit.coverage.processing.Operation2D;
import org.geotoolkit.coverage.processing.operation.Resampler2D;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.coverage.CoverageUtilities;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@Immutable
public class Resample
extends Operation2D {
    private static final long serialVersionUID = -2022393087647420577L;
    public static final ParameterDescriptor<Object> INTERPOLATION_TYPE = new DefaultParameterDescriptor(Citations.OGC, "InterpolationType", Object.class, null, (Object)"NearestNeighbor", null, null, null, false);
    public static final ParameterDescriptor<CoordinateReferenceSystem> COORDINATE_REFERENCE_SYSTEM = new DefaultParameterDescriptor(Citations.OGC, "CoordinateReferenceSystem", CoordinateReferenceSystem.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<GridGeometry> GRID_GEOMETRY = new DefaultParameterDescriptor(Citations.OGC, "GridGeometry", GridGeometry.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<double[]> BACKGROUND = new DefaultParameterDescriptor(Citations.GEOTOOLKIT, "Background", double[].class, null, null, null, null, null, false);

    public Resample() {
        super((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(Citations.OGC, "Resample", new GeneralParameterDescriptor[]{SOURCE_0, INTERPOLATION_TYPE, COORDINATE_REFERENCE_SYSTEM, GRID_GEOMETRY, BACKGROUND}));
    }

    @Override
    protected Coverage doOperation(ParameterValueGroup parameterValueGroup, Hints hints) {
        GridCoverage2D gridCoverage2D;
        GridCoverage2D gridCoverage2D2 = (GridCoverage2D)parameterValueGroup.parameter("Source").getValue();
        double[] dArray = (double[])parameterValueGroup.parameter("Background").getValue();
        Interpolation interpolation = ImageUtilities.toInterpolation(parameterValueGroup.parameter("InterpolationType").getValue());
        CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)parameterValueGroup.parameter("CoordinateReferenceSystem").getValue();
        if (coordinateReferenceSystem == null) {
            coordinateReferenceSystem = gridCoverage2D2.getCoordinateReferenceSystem();
        }
        GridGeometry2D gridGeometry2D = GridGeometry2D.castOrCopy((GridGeometry)parameterValueGroup.parameter("GridGeometry").getValue());
        try {
            gridCoverage2D = Resampler2D.reproject(gridCoverage2D2, coordinateReferenceSystem, gridGeometry2D, interpolation, dArray, hints);
        }
        catch (FactoryException factoryException) {
            throw new CannotReprojectException(Errors.format((int)37, (Object)gridCoverage2D2.getName()), factoryException);
        }
        catch (TransformException transformException) {
            throw new CannotReprojectException(Errors.format((int)37, (Object)gridCoverage2D2.getName()), transformException);
        }
        return gridCoverage2D;
    }

    public static GridGeometry computeGridGeometry(GridCoverage gridCoverage, Envelope envelope) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        CoordinateReferenceSystem coordinateReferenceSystem2 = gridCoverage.getCoordinateReferenceSystem();
        CoordinateReferenceSystem coordinateReferenceSystem3 = envelope.getDimension() == 2 && coordinateReferenceSystem2.getCoordinateSystem().getDimension() != 2 ? CoverageUtilities.getCRS2D((Coverage)gridCoverage) : coordinateReferenceSystem2;
        GridGeometry gridGeometry = gridCoverage.getGridGeometry();
        if (coordinateReferenceSystem == null || CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem3, (Object)coordinateReferenceSystem)) {
            Object object = coordinateReferenceSystem3 == coordinateReferenceSystem2 ? gridGeometry.getGridToCRS() : GridGeometry2D.castOrCopy(gridGeometry).getGridToCRS2D();
            gridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)object, envelope, null);
        } else {
            try {
                MathTransform mathTransform;
                Envelope envelope2;
                GeneralEnvelope generalEnvelope = CRS.transform((CoordinateOperation)CRS.getCoordinateOperationFactory((boolean)true).createOperation(coordinateReferenceSystem, coordinateReferenceSystem3), (Envelope)envelope);
                if (coordinateReferenceSystem3 == coordinateReferenceSystem2) {
                    envelope2 = gridCoverage.getEnvelope();
                    mathTransform = gridGeometry.getGridToCRS();
                } else {
                    envelope2 = CoverageUtilities.getEnvelope2D((Coverage)gridCoverage);
                    mathTransform = GridGeometry2D.castOrCopy(gridGeometry).getGridToCRS2D();
                }
                generalEnvelope.intersect(envelope2);
                gridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, mathTransform, (Envelope)generalEnvelope, null);
            }
            catch (FactoryException factoryException) {
                Resample.recoverableException("resample", (Exception)((Object)factoryException));
            }
            catch (TransformException transformException) {
                Resample.recoverableException("resample", (Exception)((Object)transformException));
            }
            GridEnvelope gridEnvelope = gridGeometry.getExtent();
            gridGeometry = new GridGeometry2D(gridEnvelope, envelope);
        }
        return gridGeometry;
    }

    private static void recoverableException(String string, Exception exception) {
        Logging.recoverableException(Resample.class, (String)string, (Throwable)exception);
    }
}

