/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.NullOpImage;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.ViewType;
import org.geotoolkit.coverage.processing.Operation2D;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.coverage.CoverageUtilities;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

@Immutable
public abstract class IndexColorOperation
extends Operation2D {
    protected IndexColorOperation(DefaultParameterDescriptorGroup defaultParameterDescriptorGroup) {
        super((ParameterDescriptorGroup)defaultParameterDescriptorGroup);
    }

    @Override
    protected ViewType getComputationView(ParameterValueGroup parameterValueGroup) {
        return ViewType.RENDERED;
    }

    private static boolean isGrayScale(ColorModel colorModel) {
        return colorModel instanceof ComponentColorModel && colorModel.getNumComponents() == 1 && colorModel.getColorSpace().getType() == 6;
    }

    @Override
    protected Coverage doOperation(ParameterValueGroup parameterValueGroup, Hints hints) throws IllegalArgumentException {
        Object object;
        GridSampleDimension gridSampleDimension;
        GridCoverage2D[] gridCoverage2DArray = new GridCoverage2D[1];
        ViewType viewType = this.extractSources(parameterValueGroup, gridCoverage2DArray);
        GridCoverage2D gridCoverage2D = gridCoverage2DArray[0];
        RenderedImage renderedImage = gridCoverage2D.getRenderedImage();
        GridSampleDimension[] gridSampleDimensionArray = gridCoverage2D.getSampleDimensions();
        int n = CoverageUtilities.getVisibleBand(renderedImage);
        ColorModel colorModel = renderedImage.getColorModel();
        boolean bl = false;
        for (int i = 0; i < gridSampleDimensionArray.length; ++i) {
            int n2;
            int[] nArray;
            IndexColorModel indexColorModel;
            gridSampleDimension = gridSampleDimensionArray[i];
            Object object2 = object = i == n ? renderedImage.getColorModel() : gridSampleDimension.getColorModel();
            if (object instanceof IndexColorModel) {
                indexColorModel = (IndexColorModel)object;
                nArray = new int[indexColorModel.getMapSize()];
                indexColorModel.getRGBs(nArray);
            } else if (IndexColorOperation.isGrayScale((ColorModel)object)) {
                indexColorModel = null;
                nArray = new int[1 << ((ColorModel)object).getPixelSize()];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = n2;
                }
            } else {
                throw new IllegalArgumentException(Errors.format((int)76, (Object)Classes.getClass((Object)object), IndexColorModel.class));
            }
            gridSampleDimension = this.transformColormap(nArray, i, gridSampleDimension, parameterValueGroup);
            if (!gridSampleDimensionArray[i].equals(gridSampleDimension)) {
                gridSampleDimensionArray[i] = gridSampleDimension;
                bl = true;
            }
            n2 = 0;
            for (int j = 0; j < nArray.length; ++j) {
                int n3;
                int n4 = n3 = indexColorModel != null ? indexColorModel.getRGB(j) : j;
                if (nArray[j] == n3) continue;
                n2 = 1;
                bl = true;
                break;
            }
            if (n2 == 0 || i != n) continue;
            colorModel = ColorUtilities.getIndexColorModel(nArray, gridSampleDimensionArray.length, n, -1);
        }
        if (!bl) {
            return gridCoverage2D.view(viewType);
        }
        ImageLayout imageLayout = new ImageLayout().setColorModel(colorModel);
        gridSampleDimension = new NullOpImage(renderedImage, imageLayout, null, 1);
        object = IndexColorOperation.getFactory(hints).create((CharSequence)gridCoverage2D.getName(), (RenderedImage)((Object)gridSampleDimension), gridCoverage2D.getCoordinateReferenceSystem(), gridCoverage2D.getGridGeometry().getGridToCRS(), gridSampleDimensionArray, new GridCoverage[]{gridCoverage2D}, null);
        return ((GridCoverage2D)object).view(viewType);
    }

    protected abstract GridSampleDimension transformColormap(int[] var1, int var2, GridSampleDimension var3, ParameterValueGroup var4);
}

