/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.awt.Color;
import java.io.Writer;
import java.util.Locale;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.Interpolation;
import javax.media.jai.KernelJAI;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.parameter.ParameterWriter;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.util.InternationalString;

final class CoverageParameterWriter
extends ParameterWriter {
    public CoverageParameterWriter(Writer writer) {
        super(writer);
    }

    protected String formatValue(Object object) {
        if (KernelJAI.GRADIENT_MASK_SOBEL_HORIZONTAL.equals(object)) {
            return "GRADIENT_MASK_SOBEL_HORIZONTAL";
        }
        if (KernelJAI.GRADIENT_MASK_SOBEL_VERTICAL.equals(object)) {
            return "GRADIENT_MASK_SOBEL_VERTICAL";
        }
        if (object instanceof AbstractCoverage) {
            InternationalString internationalString = ((AbstractCoverage)((Object)object)).getName();
            Locale locale = this.getLocale();
            return internationalString != null ? internationalString.toString(locale) : Vocabulary.getResources((Locale)locale).getString(311);
        }
        if (object instanceof Interpolation) {
            return ImageUtilities.getInterpolationName((Interpolation)object);
        }
        if (object instanceof EnumeratedParameter) {
            return ((EnumeratedParameter)object).getName();
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            return "RGB[" + color.getRed() + ',' + color.getGreen() + ',' + color.getBlue() + ']';
        }
        return super.formatValue(object);
    }
}

