/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.processing.AbstractCoverageProcessor;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.MeasurementRange;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class ColorMap
implements Serializable {
    private static final long serialVersionUID = 1688030908496323012L;
    public static final CharSequence ANY_QUANTITATIVE_CATEGORY = Vocabulary.formatInternational((int)7);
    private Map<String, Object> colorMap;
    private Map<String, NumberRange<?>> colorRanges;
    private boolean resetUnspecifiedColors;

    public ColorMap() {
    }

    public ColorMap(Color ... colorArray) {
        this.setColors(ANY_QUANTITATIVE_CATEGORY, colorArray);
    }

    public ColorMap(Map<? extends CharSequence, Color[]> map) {
        for (Map.Entry<? extends CharSequence, Color[]> entry : map.entrySet()) {
            this.setColors(entry.getKey(), entry.getValue());
        }
    }

    private static String unlocalized(CharSequence charSequence) {
        if (charSequence == ANY_QUANTITATIVE_CATEGORY) {
            return null;
        }
        if (charSequence instanceof InternationalString) {
            return ((InternationalString)charSequence).toString(null);
        }
        return ((Object)charSequence).toString();
    }

    private void setColorObject(CharSequence charSequence, Object object) {
        String string = ColorMap.unlocalized(charSequence);
        if (object != null) {
            if (this.colorMap == null) {
                this.colorMap = new HashMap<String, Object>();
            }
            this.colorMap.put(string, object);
        } else if (this.colorMap != null) {
            this.colorMap.remove(string);
            if (this.colorMap.isEmpty()) {
                this.colorMap = null;
            }
        }
    }

    public void setColor(CharSequence charSequence, Color color) {
        this.setColorObject(charSequence, color);
    }

    public void setColors(CharSequence charSequence, Color[] colorArray) {
        Object object;
        if (colorArray != null) {
            switch (colorArray.length) {
                default: {
                    object = colorArray.clone();
                    break;
                }
                case 1: {
                    object = colorArray[0];
                    break;
                }
                case 0: {
                    object = null;
                    break;
                }
            }
        } else {
            object = null;
        }
        this.setColorObject(charSequence, object);
    }

    public Color[] getColors(CharSequence charSequence) {
        if (this.colorMap == null) {
            return null;
        }
        String string = ColorMap.unlocalized(charSequence);
        Color[] colorArray = this.colorMap.get(string);
        if (colorArray == null) {
            if (string != null && charSequence instanceof InternationalString) {
                colorArray = this.getColors(((Object)charSequence).toString());
                if (colorArray == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (colorArray instanceof Color) {
            return new Color[]{(Color)colorArray};
        }
        return (Color[])((Color[])colorArray).clone();
    }

    public void setGeophysicsRange(CharSequence charSequence, MeasurementRange<?> measurementRange) {
        this.setRange(charSequence, (NumberRange<?>)measurementRange);
    }

    public void setRelativeRange(CharSequence charSequence, NumberRange<?> numberRange) {
        if (numberRange instanceof MeasurementRange) {
            throw new IllegalArgumentException(Errors.format((int)72, (Object)"range"));
        }
        this.setRange(charSequence, numberRange);
    }

    private void setRange(CharSequence charSequence, NumberRange<?> numberRange) {
        String string = ColorMap.unlocalized(charSequence);
        if (numberRange != null) {
            if (this.colorRanges == null) {
                this.colorRanges = new HashMap();
            }
            this.colorRanges.put(string, numberRange);
        } else if (this.colorRanges != null) {
            this.colorRanges.remove(string);
            if (this.colorRanges.isEmpty()) {
                this.colorRanges = null;
            }
        }
    }

    public MeasurementRange<?> getGeophysicsRange(CharSequence charSequence) {
        NumberRange<?> numberRange = this.getRange(charSequence);
        return numberRange instanceof MeasurementRange ? (MeasurementRange)numberRange : null;
    }

    public NumberRange<?> getRelativeRange(CharSequence charSequence) {
        NumberRange<?> numberRange = this.getRange(charSequence);
        return numberRange instanceof MeasurementRange ? null : numberRange;
    }

    private NumberRange<?> getRange(CharSequence charSequence) {
        if (this.colorRanges == null) {
            return null;
        }
        String string = ColorMap.unlocalized(charSequence);
        NumberRange<?> numberRange = this.colorRanges.get(string);
        if (numberRange == null && string != null && charSequence instanceof InternationalString) {
            numberRange = this.colorRanges.get(((Object)charSequence).toString());
        }
        return numberRange;
    }

    private NumberRange<?> getTargetRange(Category category, Unit<?> unit) {
        int n;
        int n2;
        double d;
        double d2;
        MathTransform1D mathTransform1D;
        MeasurementRange measurementRange = this.getRange((CharSequence)category.getName());
        if (measurementRange == null) {
            if (category.isQuantitative()) {
                measurementRange = this.getRange(ANY_QUANTITATIVE_CATEGORY);
            }
            if (measurementRange == null) {
                return null;
            }
        }
        boolean bl = measurementRange.isMinIncluded();
        boolean bl2 = measurementRange.isMaxIncluded();
        if (measurementRange instanceof MeasurementRange) {
            try {
                mathTransform1D = (MathTransform1D)measurementRange;
                measurementRange = mathTransform1D.convertTo(unit);
            }
            catch (ConversionException conversionException) {
                Logging.unexpectedException((Logger)AbstractCoverageProcessor.LOGGER, ColorMap.class, (String)"recolor", (Throwable)conversionException);
                return null;
            }
            d2 = measurementRange.getMinimum();
            d = measurementRange.getMaximum();
            mathTransform1D = category.getSampleToGeophysics();
            if (mathTransform1D != null) {
                try {
                    mathTransform1D = mathTransform1D.inverse();
                    d2 = mathTransform1D.transform(d2);
                    d = mathTransform1D.transform(d);
                }
                catch (TransformException transformException) {
                    Logging.unexpectedException((Logger)AbstractCoverageProcessor.LOGGER, ColorMap.class, (String)"recolor", (Throwable)transformException);
                    return null;
                }
            }
        } else {
            d2 = measurementRange.getMinimum();
            d = measurementRange.getMaximum();
            mathTransform1D = category.getRange();
            double d3 = mathTransform1D.getMinimum();
            double d4 = mathTransform1D.getMaximum() - d3;
            d2 = d2 / 100.0 * d4 + d3;
            d = d / 100.0 * d4 + d3;
            bl &= mathTransform1D.isMinIncluded();
            bl2 &= mathTransform1D.isMaxIncluded();
        }
        if (d2 > d) {
            n2 = ColorMap.round(d, bl2);
            n = ColorMap.round(d2, !bl);
        } else {
            n2 = ColorMap.round(d2, bl);
            n = ColorMap.round(d, !bl2);
        }
        return NumberRange.create((int)n2, (boolean)true, (int)n, (boolean)false);
    }

    private static int round(double d, boolean bl) {
        double d2 = bl ? Math.floor(d) : Math.ceil(d);
        int n = (int)d2;
        if (!bl && d == d2) {
            ++n;
        }
        return n;
    }

    public void setResetUnspecifiedColors(boolean bl) {
        this.resetUnspecifiedColors = bl;
    }

    public boolean getResetUnspecifiedColors() {
        return this.resetUnspecifiedColors;
    }

    public GridSampleDimension recolor(GridSampleDimension gridSampleDimension, int[] nArray) {
        GridSampleDimension gridSampleDimension2 = gridSampleDimension.geophysics(false);
        boolean bl = false;
        Category[] categoryArray = (Category[])gridSampleDimension2.getCategories().toArray();
        for (int i = 0; i < categoryArray.length; ++i) {
            Category category = categoryArray[i];
            Color[] colorArray = this.getColors((CharSequence)category.getName());
            if (colorArray == null) {
                if (category.isQuantitative()) {
                    colorArray = this.getColors(ANY_QUANTITATIVE_CATEGORY);
                }
                if (colorArray == null && this.resetUnspecifiedColors) {
                    colorArray = category.getColors();
                }
            }
            if (nArray != null) {
                NumberRange<?> numberRange = category.getRange();
                int n = ((Number)((Object)numberRange.getMinValue())).intValue();
                int n2 = ((Number)((Object)numberRange.getMaxValue())).intValue();
                if (!numberRange.isMinIncluded()) {
                    ++n;
                }
                if (numberRange.isMaxIncluded()) {
                    ++n2;
                }
                boolean bl2 = false;
                if (n < 0) {
                    n = 0;
                    bl2 = true;
                }
                if (n2 > nArray.length) {
                    n2 = nArray.length;
                    bl2 = true;
                }
                if (bl2) {
                    AbstractCoverageProcessor.LOGGER.warning(Errors.format((int)246, (Object)category, (Object)0, (Object)(nArray.length - 1)));
                }
                if (n2 <= n) continue;
                NumberRange<?> numberRange2 = this.getTargetRange(category, gridSampleDimension.getUnits());
                if (numberRange2 != null) {
                    if (colorArray == null) {
                        colorArray = category.getColors();
                    }
                    if (colorArray.length >= 2) {
                        assert (numberRange2.isMinIncluded() && !numberRange2.isMaxIncluded()) : numberRange2;
                        int n3 = Math.max(n, ((Number)((Object)numberRange2.getMinValue())).intValue());
                        int n4 = Math.min(n2, ((Number)((Object)numberRange2.getMaxValue())).intValue());
                        if (n3 != n || n4 != n2) {
                            Arrays.fill(nArray, n, n3, colorArray[0].getRGB());
                            Arrays.fill(nArray, n4, n2, colorArray[colorArray.length - 1].getRGB());
                            n = n3;
                            n2 = n4;
                        }
                    }
                } else if (colorArray == null) continue;
                ColorUtilities.expand(colorArray, nArray, n, n2);
            } else if (colorArray == null) continue;
            category = category.recolor(colorArray);
            if (categoryArray[i].equals(category)) continue;
            categoryArray[i] = category;
            bl = true;
        }
        if (!bl) {
            return gridSampleDimension;
        }
        GridSampleDimension gridSampleDimension3 = new GridSampleDimension((CharSequence)gridSampleDimension2.getDescription(), categoryArray, gridSampleDimension2.getUnits());
        if (gridSampleDimension != gridSampleDimension2) {
            gridSampleDimension3 = gridSampleDimension3.geophysics(true);
        }
        return gridSampleDimension3;
    }

    private CharSequence[] getCategoryNames() {
        Set<Object> set;
        if (this.colorMap != null) {
            if (this.colorRanges != null) {
                set = new HashSet<String>(this.colorMap.keySet());
                set.addAll(this.colorRanges.keySet());
            } else {
                set = this.colorMap.keySet();
            }
        } else {
            set = this.colorRanges != null ? this.colorRanges.keySet() : Collections.emptySet();
        }
        int n = set.size();
        Object[] objectArray = set.toArray(new CharSequence[n]);
        int n2 = n;
        while (--n2 >= 0) {
            if (objectArray[n2] != null) continue;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, --n - n2);
            objectArray[n] = ANY_QUANTITATIVE_CATEGORY;
        }
        Arrays.sort(objectArray, 0, n);
        return objectArray;
    }

    public int hashCode() {
        return 0xEECDA1C4 ^ (this.colorMap != null ? ((Object)this.colorMap).hashCode() : 37) + 31 * (this.colorRanges != null ? ((Object)this.colorRanges).hashCode() : 37);
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            ColorMap colorMap = (ColorMap)object;
            return Utilities.equals(this.colorMap, colorMap.colorMap) && Utilities.equals(this.colorRanges, colorMap.colorRanges);
        }
        return false;
    }

    public String toString() {
        CharSequence[] charSequenceArray = this.getCategoryNames();
        TableWriter tableWriter = new TableWriter(null, 1);
        for (int i = 0; i < charSequenceArray.length; ++i) {
            Color[] colorArray;
            CharSequence charSequence = charSequenceArray[i];
            tableWriter.write(((Object)charSequence).toString());
            if (this.colorRanges != null && (colorArray = this.getRange(charSequence)) != null) {
                tableWriter.write(32);
                tableWriter.write(colorArray.toString());
                if (!(colorArray instanceof MeasurementRange)) {
                    tableWriter.write(37);
                }
            }
            tableWriter.nextColumn();
            tableWriter.write(58);
            tableWriter.nextColumn();
            colorArray = this.getColors(charSequence);
            if (colorArray != null) {
                String string = colorArray.length == 1 ? Integer.toHexString(colorArray[0].getRGB()).toUpperCase() : Vocabulary.format((int)33, (Object)colorArray.length);
                tableWriter.write(string);
            }
            tableWriter.nextLine();
        }
        return tableWriter.toString();
    }
}

