/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.CoverageReferences;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.util.Utilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

@Immutable
final class CachedOperationParameters {
    private final Operation operation;
    private final String[] names;
    private final Object[] values;
    private final int hashCode;

    CachedOperationParameters(Operation operation, ParameterValueGroup parameterValueGroup) {
        TreeMap treeMap = new TreeMap();
        Parameters.copy((GeneralParameterValue)parameterValueGroup, treeMap);
        this.operation = operation;
        this.names = new String[treeMap.size()];
        this.values = new Object[this.names.length];
        int n = operation.hashCode();
        int n2 = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            String string = ((String)entry.getKey()).trim().toLowerCase(Locale.US);
            Object object = entry.getValue();
            if (object != null) {
                n = 31 * n + Utilities.deepHashCode(object);
                if (object instanceof Coverage) {
                    object = CoverageReferences.DEFAULT.reference((Coverage)object);
                }
            }
            n = 7 * n + string.hashCode();
            this.names[n2] = string;
            this.values[n2++] = object;
        }
        this.hashCode = n;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof CachedOperationParameters) {
            CachedOperationParameters cachedOperationParameters = (CachedOperationParameters)object;
            if (Utilities.equals((Object)this.operation, (Object)cachedOperationParameters.operation) && Arrays.equals(this.names, cachedOperationParameters.names)) {
                return Arrays.deepEquals(this.values, cachedOperationParameters.values);
            }
        }
        return false;
    }
}

