/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.geotoolkit.internal.image.ImageUtilities;

public enum ViewType {
    NATIVE(false, false, false),
    PACKED(false, false, false),
    RENDERED(false, false, false),
    GEOPHYSICS(true, false, false),
    PHOTOGRAPHIC(true, true, true),
    SAME(false, false, false);

    private final boolean interpolationAllowed;
    private final boolean transformOnColormapAllowed;
    private final boolean replaceIndexColorModelAllowed;

    private ViewType(boolean bl, boolean bl2, boolean bl3) {
        this.interpolationAllowed = bl;
        this.transformOnColormapAllowed = bl2;
        this.replaceIndexColorModelAllowed = bl3;
    }

    public boolean isInterpolationAllowed() {
        return this.interpolationAllowed;
    }

    public boolean isReplaceIndexColorModelAllowed() {
        return this.replaceIndexColorModelAllowed;
    }

    public boolean isTransformOnColormapAllowed() {
        return this.transformOnColormapAllowed;
    }

    public RenderingHints getRenderingHints(RenderedImage renderedImage) {
        RenderingHints renderingHints = ImageUtilities.getRenderingHints(renderedImage);
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        if (!this.isInterpolationAllowed()) {
            renderingHints.put(JAI.KEY_INTERPOLATION, Interpolation.getInstance((int)0));
        }
        renderingHints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)this.isReplaceIndexColorModelAllowed());
        renderingHints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, (Object)this.isTransformOnColormapAllowed());
        return renderingHints;
    }
}

