/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import javax.measure.unit.Unit;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.TypeMap;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.NumberRange;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.util.InternationalString;

@Immutable
final class RenderedSampleDimension
extends GridSampleDimension {
    private static final long serialVersionUID = 946331925096804779L;
    private final int band;
    private final int numBands;
    private final SampleDimensionType type;

    private RenderedSampleDimension(GridSampleDimension gridSampleDimension, SampleModel sampleModel, int n) {
        super(gridSampleDimension);
        this.band = n;
        this.numBands = sampleModel.getNumBands();
        this.type = TypeMap.getSampleDimensionType(sampleModel, n);
    }

    static boolean create(CharSequence charSequence, RenderedImage renderedImage, GridSampleDimension[] gridSampleDimensionArray, GridSampleDimension[] gridSampleDimensionArray2) {
        return RenderedSampleDimension.create(charSequence, renderedImage, null, renderedImage.getSampleModel(), gridSampleDimensionArray, gridSampleDimensionArray2);
    }

    @Deprecated
    static boolean create(CharSequence charSequence, RenderedImage renderedImage, Raster raster, SampleModel sampleModel, GridSampleDimension[] gridSampleDimensionArray, GridSampleDimension[] gridSampleDimensionArray2) {
        int n = sampleModel.getNumBands();
        if (gridSampleDimensionArray != null && gridSampleDimensionArray.length != n) {
            throw new IllegalArgumentException(Errors.format((int)177, (Object)n, (Object)gridSampleDimensionArray.length, (Object)"SampleDimension"));
        }
        if (gridSampleDimensionArray2.length != n) {
            throw new IllegalArgumentException(Errors.format((int)177, (Object)n, (Object)gridSampleDimensionArray2.length, (Object)"SampleDimension"));
        }
        int n2 = 0;
        int n3 = 0;
        GridSampleDimension[] gridSampleDimensionArray3 = null;
        for (int i = 0; i < n; ++i) {
            GridSampleDimension gridSampleDimension;
            GridSampleDimension gridSampleDimension2 = gridSampleDimension = gridSampleDimensionArray != null ? gridSampleDimensionArray[i] : null;
            if (gridSampleDimension == null) {
                if (gridSampleDimensionArray3 == null) {
                    gridSampleDimensionArray3 = new GridSampleDimension[n];
                    Object[] objectArray = null;
                    if (charSequence != null) {
                        objectArray = new CharSequence[n];
                        Arrays.fill(objectArray, charSequence);
                    }
                    RenderedSampleDimension.create((CharSequence[])objectArray, renderedImage != null ? RectIterFactory.create((RenderedImage)renderedImage, null) : RectIterFactory.create((Raster)raster, null), sampleModel, null, null, null, null, gridSampleDimensionArray3, null);
                }
                gridSampleDimension = gridSampleDimensionArray3[i];
            }
            gridSampleDimensionArray2[i] = gridSampleDimension = new RenderedSampleDimension(gridSampleDimension, sampleModel, i);
            if (gridSampleDimension.geophysics(true) == gridSampleDimension) {
                ++n2;
            }
            if (gridSampleDimension.geophysics(false) != gridSampleDimension) continue;
            ++n3;
        }
        if (n2 == n) {
            return true;
        }
        if (n3 == n) {
            return false;
        }
        throw new IllegalArgumentException(Errors.format((int)122));
    }

    static GridSampleDimension[] create(CharSequence[] charSequenceArray, RenderedImage renderedImage, double[] dArray, double[] dArray2, Unit<?>[] unitArray, Color[][] colorArray, RenderingHints renderingHints) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        GridSampleDimension[] gridSampleDimensionArray = new GridSampleDimension[sampleModel.getNumBands()];
        RenderedSampleDimension.create(charSequenceArray, dArray == null || dArray2 == null ? RectIterFactory.create((RenderedImage)renderedImage, null) : null, sampleModel, dArray, dArray2, unitArray, colorArray, gridSampleDimensionArray, renderingHints);
        return gridSampleDimensionArray;
    }

    static GridSampleDimension[] create(CharSequence[] charSequenceArray, Raster raster, double[] dArray, double[] dArray2, Unit<?>[] unitArray, Color[][] colorArray, RenderingHints renderingHints) {
        GridSampleDimension[] gridSampleDimensionArray = new GridSampleDimension[raster.getNumBands()];
        RenderedSampleDimension.create(charSequenceArray, dArray == null || dArray2 == null ? RectIterFactory.create((Raster)raster, null) : null, raster.getSampleModel(), dArray, dArray2, unitArray, colorArray, gridSampleDimensionArray, renderingHints);
        return gridSampleDimensionArray;
    }

    private static void create(CharSequence[] charSequenceArray, RectIter rectIter, SampleModel sampleModel, double[] dArray, double[] dArray2, Unit<?>[] unitArray, Color[][] colorArray, GridSampleDimension[] gridSampleDimensionArray, RenderingHints renderingHints) {
        int n;
        boolean bl;
        int n2 = gridSampleDimensionArray.length;
        if (dArray != null && dArray.length != n2) {
            throw new IllegalArgumentException(Errors.format((int)177, (Object)n2, (Object)dArray.length, (Object)"min[i]"));
        }
        if (dArray2 != null && dArray2.length != n2) {
            throw new IllegalArgumentException(Errors.format((int)177, (Object)n2, (Object)dArray2.length, (Object)"max[i]"));
        }
        if (colorArray != null && colorArray.length != n2) {
            throw new IllegalArgumentException(Errors.format((int)177, (Object)n2, (Object)colorArray.length, (Object)"colors[i]"));
        }
        SampleDimensionType sampleDimensionType = TypeMap.getSampleDimensionType(sampleModel, 0);
        boolean bl2 = TypeMap.isFloatingPoint(sampleDimensionType);
        SampleDimensionType sampleDimensionType2 = null;
        if (renderingHints != null) {
            sampleDimensionType2 = (SampleDimensionType)renderingHints.get(Hints.SAMPLE_DIMENSION_TYPE);
        }
        if (sampleDimensionType2 == null) {
            sampleDimensionType2 = bl2 ? SampleDimensionType.UNSIGNED_8BITS : sampleDimensionType;
        }
        boolean bl3 = TypeMap.isFloatingPoint(sampleDimensionType2);
        NumberRange<?> numberRange = TypeMap.getRange(sampleDimensionType2);
        Category[] categoryArray = new Category[1];
        if (bl3) {
            bl = false;
        } else if (bl2) {
            bl = true;
            if (!TypeMap.isSigned(sampleDimensionType2)) {
                categoryArray = new Category[2];
                categoryArray[1] = Category.NODATA;
                numberRange = TypeMap.getPositiveRange(sampleDimensionType2);
            }
        } else {
            boolean bl4 = bl = !numberRange.contains(TypeMap.getRange(sampleDimensionType));
        }
        if (bl && (dArray == null || dArray2 == null)) {
            boolean bl5 = dArray == null;
            if (bl5) {
                dArray = new double[n2];
                Arrays.fill(dArray, Double.POSITIVE_INFINITY);
            }
            if ((n = dArray2 == null ? 1 : 0) != 0) {
                dArray2 = new double[n2];
                Arrays.fill(dArray2, Double.NEGATIVE_INFINITY);
            }
            int n3 = 0;
            rectIter.startBands();
            if (!rectIter.finishedBands()) {
                do {
                    rectIter.startLines();
                    if (!rectIter.finishedLines()) {
                        do {
                            rectIter.startPixels();
                            if (rectIter.finishedPixels()) continue;
                            do {
                                double d = rectIter.getSampleDouble();
                                if (bl5 && d < dArray[n3]) {
                                    dArray[n3] = d;
                                }
                                if (n == 0 || !(d > dArray2[n3])) continue;
                                dArray2[n3] = d;
                            } while (!rectIter.nextPixelDone());
                        } while (!rectIter.nextLineDone());
                    }
                    if (bl5 && n != 0 && !(dArray[n3] < dArray2[n3])) {
                        dArray[n3] = 0.0;
                        dArray2[n3] = 1.0;
                    }
                    ++n3;
                } while (!rectIter.nextBandDone());
            }
        }
        InternationalString internationalString = null;
        for (n = 0; n < n2; ++n) {
            Color[] colorArray2;
            CharSequence charSequence;
            CharSequence charSequence2 = charSequence = charSequenceArray != null ? charSequenceArray[n] : null;
            if (charSequence == null) {
                if (internationalString == null) {
                    internationalString = Vocabulary.formatInternational((int)311);
                }
                charSequence = internationalString;
                if (n2 != 1) {
                    charSequence = Vocabulary.formatInternational((int)354, (Object[])new Object[]{charSequence, n + 1});
                }
            }
            NumberRange numberRange2 = TypeMap.getRange(sampleDimensionType);
            Color[] colorArray3 = colorArray2 = colorArray != null ? colorArray[n] : null;
            if (bl) {
                NumberRange numberRange3 = NumberRange.create((double)dArray[n], (double)dArray2[n]);
                numberRange2 = numberRange3.castTo(numberRange2.getElementType());
                categoryArray[0] = new Category(charSequence, colorArray2, numberRange, numberRange2);
            } else {
                categoryArray[0] = new Category(charSequence, colorArray2, numberRange, (MathTransform1D)LinearTransform1D.IDENTITY);
            }
            gridSampleDimensionArray[n] = new GridSampleDimension(charSequence, categoryArray, unitArray != null ? unitArray[n] : null).geophysics(true);
        }
    }

    @Override
    public SampleDimensionType getSampleDimensionType() {
        return this.type;
    }

    @Override
    public ColorInterpretation getColorInterpretation() {
        return TypeMap.getColorInterpretation(this.getColorModel(), this.band);
    }

    @Override
    public ColorModel getColorModel() {
        return this.getColorModel(this.band, this.numBands);
    }
}

