/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.grid.GridEnvelope2D;
import org.geotoolkit.metadata.iso.spatial.PixelTranslation;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.metadata.spatial.PixelOrientation;

@Immutable
public class ImageGeometry
implements GridGeometry,
Serializable {
    private static final long serialVersionUID = -6578330391565232607L;
    private final GridEnvelope2D extent;
    private final AffineTransform2D gridToCRS;

    public ImageGeometry(Rectangle rectangle, AffineTransform affineTransform) {
        this.extent = new GridEnvelope2D(rectangle);
        this.gridToCRS = affineTransform.getClass() == AffineTransform2D.class ? (AffineTransform2D)affineTransform : new AffineTransform2D(affineTransform);
    }

    public GridEnvelope2D getExtent() {
        return this.getGridRange();
    }

    @Deprecated
    public GridEnvelope2D getGridRange() {
        return this.extent.clone();
    }

    public AffineTransform2D getGridToCRS() {
        return this.gridToCRS;
    }

    public Rectangle2D getEnvelope(PixelOrientation pixelOrientation) {
        PixelTranslation pixelTranslation = PixelTranslation.getPixelTranslation((PixelOrientation)pixelOrientation);
        GridEnvelope2D gridEnvelope2D = this.extent;
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)gridEnvelope2D.x - (pixelTranslation.dx + 0.5), (double)gridEnvelope2D.y - (pixelTranslation.dy + 0.5), gridEnvelope2D.width, gridEnvelope2D.height);
        return XAffineTransform.transform((AffineTransform)this.gridToCRS, (Rectangle2D)double_, (Rectangle2D)double_);
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.extent + ", " + this.gridToCRS + ']';
    }

    public int hashCode() {
        return this.extent.hashCode() ^ this.gridToCRS.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            ImageGeometry imageGeometry = (ImageGeometry)object;
            return Utilities.equals((Object)this.extent, (Object)imageGeometry.extent) && Utilities.equals((Object)this.gridToCRS, (Object)imageGeometry.gridToCRS);
        }
        return false;
    }
}

