/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.grid.AbstractGridCoverage;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.grid.GeneralGridGeometry;
import org.geotoolkit.coverage.grid.GridEnvelope2D;
import org.geotoolkit.coverage.grid.InvalidGridGeometryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.ImmutableEnvelope;
import org.geotoolkit.metadata.iso.spatial.PixelTranslation;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.transform.DimensionFilter;
import org.geotoolkit.resources.Errors;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@Immutable
public class GridGeometry2D
extends GeneralGridGeometry {
    private static final long serialVersionUID = -3989363771504614419L;
    private static ReferencingFactoryContainer FACTORIES;
    private final CoordinateReferenceSystem crs2D;
    public final int gridDimensionX;
    public final int gridDimensionY;
    public final int axisDimensionX;
    public final int axisDimensionY;
    private final MathTransform2D gridToCRS2D;
    private final MathTransform2D gridFromCRS2D;
    private MathTransform2D cornerToCRS2D;

    private boolean isValid() {
        if (this.gridToCRS != null) {
            int n = this.gridToCRS.getSourceDimensions();
            int n2 = this.gridToCRS.getTargetDimensions();
            assert (this.gridToCRS.equals(this.gridToCRS2D) == (n == 2 && n2 == 2));
            assert (!this.gridToCRS2D.equals(this.cornerToCRS2D));
            assert (this.extent == null || n == this.extent.getDimension()) : this.extent;
            assert (this.envelope == null || n2 == this.envelope.getDimension()) : this.envelope;
            assert (this.gridDimensionY < n) : this.gridDimensionY;
            assert (this.axisDimensionY < n2) : this.axisDimensionY;
        }
        assert (this.gridDimensionX < this.gridDimensionY) : this.gridDimensionX;
        assert (this.axisDimensionX < this.axisDimensionY) : this.axisDimensionX;
        return this.crs2D == null || this.crs2D.getCoordinateSystem().getDimension() == 2;
    }

    GridGeometry2D(GridGeometry2D gridGeometry2D, CoordinateReferenceSystem coordinateReferenceSystem) {
        super(gridGeometry2D, coordinateReferenceSystem);
        this.gridDimensionX = gridGeometry2D.gridDimensionX;
        this.gridDimensionY = gridGeometry2D.gridDimensionY;
        this.axisDimensionX = gridGeometry2D.axisDimensionX;
        this.axisDimensionY = gridGeometry2D.axisDimensionY;
        this.gridFromCRS2D = gridGeometry2D.gridFromCRS2D;
        this.gridToCRS2D = gridGeometry2D.gridToCRS2D;
        this.cornerToCRS2D = gridGeometry2D.cornerToCRS2D;
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridGeometry gridGeometry) throws IllegalArgumentException {
        super(gridGeometry);
        if (gridGeometry instanceof GridGeometry2D) {
            GridGeometry2D gridGeometry2D = (GridGeometry2D)gridGeometry;
            this.gridToCRS2D = gridGeometry2D.gridToCRS2D;
            this.gridFromCRS2D = gridGeometry2D.gridFromCRS2D;
            this.gridDimensionX = gridGeometry2D.gridDimensionX;
            this.gridDimensionY = gridGeometry2D.gridDimensionY;
            this.axisDimensionX = gridGeometry2D.axisDimensionX;
            this.axisDimensionY = gridGeometry2D.axisDimensionY;
            this.crs2D = gridGeometry2D.crs2D;
            this.cornerToCRS2D = gridGeometry2D.cornerToCRS2D;
        } else {
            int[] nArray = new int[4];
            this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, this.extent, nArray, null);
            this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
            this.gridDimensionX = nArray[0];
            this.gridDimensionY = nArray[1];
            this.axisDimensionX = nArray[2];
            this.axisDimensionY = nArray[3];
            this.crs2D = this.createCRS2D();
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridEnvelope, MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridEnvelope, PixelInCell.CELL_CENTER, mathTransform, coordinateReferenceSystem, null);
    }

    public GridGeometry2D(GridEnvelope gridEnvelope, PixelInCell pixelInCell, MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem, Hints hints) throws MismatchedDimensionException, IllegalArgumentException {
        super(gridEnvelope, pixelInCell, mathTransform, coordinateReferenceSystem);
        int[] nArray = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, gridEnvelope, nArray, hints);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = nArray[0];
        this.gridDimensionY = nArray[1];
        this.axisDimensionX = nArray[2];
        this.axisDimensionY = nArray[3];
        this.crs2D = this.createCRS2D();
        if (PixelInCell.CELL_CORNER.equals((Object)pixelInCell)) {
            this.cornerToCRS2D = GridGeometry2D.getMathTransform2D(mathTransform, gridEnvelope, nArray, hints);
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridEnvelope, PixelOrientation pixelOrientation, MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem, Hints hints) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridEnvelope, pixelOrientation, mathTransform, new int[4], coordinateReferenceSystem, hints);
    }

    private GridGeometry2D(GridEnvelope gridEnvelope, PixelOrientation pixelOrientation, MathTransform mathTransform, int[] nArray, CoordinateReferenceSystem coordinateReferenceSystem, Hints hints) {
        this(gridEnvelope, pixelOrientation, mathTransform != null && mathTransform.getSourceDimensions() == 2 && mathTransform.getTargetDimensions() == 2 && PixelOrientation.UPPER_LEFT.equals((Object)pixelOrientation) ? PixelInCell.CELL_CORNER : PixelInCell.CELL_CENTER, mathTransform, GridGeometry2D.getMathTransform2D(mathTransform, gridEnvelope, nArray, hints), nArray, coordinateReferenceSystem);
    }

    private GridGeometry2D(GridEnvelope gridEnvelope, PixelOrientation pixelOrientation, PixelInCell pixelInCell, MathTransform mathTransform, MathTransform2D mathTransform2D, int[] nArray, CoordinateReferenceSystem coordinateReferenceSystem) {
        super(gridEnvelope, pixelInCell, PixelTranslation.translate((MathTransform)mathTransform, (PixelOrientation)pixelOrientation, (PixelOrientation)PixelTranslation.getPixelOrientation((PixelInCell)pixelInCell), (int)nArray[0], (int)nArray[1]), coordinateReferenceSystem);
        this.gridDimensionX = nArray[0];
        this.gridDimensionY = nArray[1];
        this.axisDimensionX = nArray[2];
        this.axisDimensionY = nArray[3];
        if (mathTransform == mathTransform2D) {
            this.gridToCRS2D = (MathTransform2D)this.gridToCRS;
        } else {
            int n = this.gridDimensionX < this.gridDimensionY ? 0 : 1;
            this.gridToCRS2D = (MathTransform2D)PixelTranslation.translate((MathTransform)mathTransform2D, (PixelOrientation)pixelOrientation, (PixelOrientation)PixelOrientation.CENTER, (int)n, (int)(n ^ 1));
        }
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(PixelInCell pixelInCell, MathTransform mathTransform, Envelope envelope, Hints hints) throws MismatchedDimensionException, IllegalArgumentException {
        super(pixelInCell, mathTransform, envelope);
        int[] nArray = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, this.extent, nArray, hints);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = nArray[0];
        this.gridDimensionY = nArray[1];
        this.axisDimensionX = nArray[2];
        this.axisDimensionY = nArray[3];
        this.crs2D = this.createCRS2D();
        if (PixelInCell.CELL_CORNER.equals((Object)pixelInCell)) {
            this.cornerToCRS2D = GridGeometry2D.getMathTransform2D(mathTransform, this.extent, nArray, hints);
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridEnvelope, Envelope envelope) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridEnvelope, envelope, null, false, true);
    }

    private GridGeometry2D(GridEnvelope gridEnvelope, Envelope envelope, boolean[] blArray, boolean bl, boolean bl2) throws IllegalArgumentException, MismatchedDimensionException {
        super(gridEnvelope, envelope, blArray, bl, bl2);
        int[] nArray = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, gridEnvelope, nArray, null);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = nArray[0];
        this.gridDimensionY = nArray[1];
        this.axisDimensionX = nArray[2];
        this.axisDimensionY = nArray[3];
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(Rectangle rectangle, Rectangle2D rectangle2D) {
        this(new GeneralGridEnvelope(rectangle, 2), GridGeometry2D.getMathTransform(rectangle, rectangle2D), (CoordinateReferenceSystem)null);
    }

    public static GridGeometry2D castOrCopy(GridGeometry gridGeometry) {
        if (gridGeometry == null || gridGeometry instanceof GridGeometry2D) {
            return (GridGeometry2D)gridGeometry;
        }
        return new GridGeometry2D(gridGeometry);
    }

    private static MathTransform getMathTransform(Rectangle rectangle, Rectangle2D rectangle2D) {
        double d = rectangle2D.getWidth() / rectangle.getWidth();
        double d2 = rectangle2D.getHeight() / rectangle.getHeight();
        double d3 = rectangle2D.getMinX() - (double)rectangle.x * d;
        double d4 = rectangle2D.getMaxY() + (double)rectangle.y * d2;
        AffineTransform affineTransform = new AffineTransform(d, 0.0, 0.0, -d2, d3, d4);
        affineTransform.translate(0.5, 0.5);
        return MathTransforms.linear((AffineTransform)affineTransform);
    }

    private static MathTransform2D getMathTransform2D(MathTransform mathTransform, GridEnvelope gridEnvelope, int[] nArray, Hints hints) throws IllegalArgumentException {
        if (mathTransform != null && gridEnvelope != null) {
            GridGeometry2D.ensureDimensionMatch("extent", gridEnvelope.getDimension(), mathTransform.getSourceDimensions());
        }
        if (mathTransform == null || mathTransform instanceof MathTransform2D) {
            nArray[3] = 1;
            nArray[1] = 1;
            return (MathTransform2D)mathTransform;
        }
        DimensionFilter dimensionFilter = DimensionFilter.getInstance((Hints)hints);
        boolean bl = true;
        if (gridEnvelope != null) {
            int n = gridEnvelope.getDimension();
            for (int i = 0; i < n; ++i) {
                if (gridEnvelope.getSpan(i) <= 1) continue;
                dimensionFilter.addSourceDimension(i);
                bl = false;
            }
        }
        if (bl) {
            dimensionFilter.addSourceDimensionRange(0, 2);
        }
        Throwable throwable = null;
        int[] nArray2 = dimensionFilter.getSourceDimensions();
        if (nArray2.length == 2) {
            nArray[0] = nArray2[0];
            nArray[1] = nArray2[1];
            try {
                MathTransform mathTransform2 = dimensionFilter.separate(mathTransform);
                if (mathTransform2.getTargetDimensions() != 2) {
                    dimensionFilter.clear();
                    dimensionFilter.addSourceDimensions(nArray2);
                    dimensionFilter.addTargetDimensions(nArray2);
                    mathTransform2 = dimensionFilter.separate(mathTransform);
                }
                nArray2 = dimensionFilter.getTargetDimensions();
                nArray[2] = nArray2[0];
                nArray[3] = nArray2[1];
                try {
                    return (MathTransform2D)mathTransform2;
                }
                catch (ClassCastException classCastException) {
                    throwable = classCastException;
                }
            }
            catch (FactoryException factoryException) {
                throwable = factoryException;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)168), throwable);
    }

    private static MathTransform2D inverse(MathTransform2D mathTransform2D) throws IllegalArgumentException {
        if (mathTransform2D == null) {
            return null;
        }
        try {
            return mathTransform2D.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException(Errors.format((int)16, mathTransform2D.getClass()), noninvertibleTransformException);
        }
    }

    private CoordinateReferenceSystem createCRS2D() throws InvalidGridGeometryException {
        if (!super.isDefined(1)) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = super.getCoordinateReferenceSystem();
        try {
            coordinateReferenceSystem = this.reduce(coordinateReferenceSystem);
        }
        catch (FactoryException factoryException) {
            throw new InvalidGridGeometryException(Errors.format((int)73, (Object)"crs", (Object)coordinateReferenceSystem.getName()), factoryException);
        }
        return coordinateReferenceSystem;
    }

    public Envelope2D reduce(Envelope envelope) {
        if (envelope == null) {
            return null;
        }
        return new Envelope2D(this.crs2D, envelope.getMinimum(this.axisDimensionX), envelope.getMinimum(this.axisDimensionY), envelope.getSpan(this.axisDimensionX), envelope.getSpan(this.axisDimensionY));
    }

    public CoordinateReferenceSystem reduce(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        if (coordinateReferenceSystem == null || coordinateReferenceSystem.getCoordinateSystem().getDimension() <= 2) {
            return coordinateReferenceSystem;
        }
        if (FACTORIES == null) {
            FACTORIES = ReferencingFactoryContainer.instance(null);
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = FACTORIES.separate(coordinateReferenceSystem, new int[]{this.axisDimensionX, this.axisDimensionY});
        assert (coordinateReferenceSystem2.getCoordinateSystem().getDimension() == 2) : coordinateReferenceSystem2;
        return coordinateReferenceSystem2;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() throws InvalidGridGeometryException {
        if (this.crs2D != null) {
            assert (this.isDefined(1));
            return this.crs2D;
        }
        assert (!this.isDefined(1));
        throw new InvalidGridGeometryException(234);
    }

    public Envelope2D getEnvelope2D() throws InvalidGridGeometryException {
        ImmutableEnvelope immutableEnvelope = this.envelope;
        if (immutableEnvelope != null && !immutableEnvelope.isAllNaN()) {
            assert (this.isDefined(2));
            return new Envelope2D(this.crs2D, immutableEnvelope.getMinimum(this.axisDimensionX), immutableEnvelope.getMinimum(this.axisDimensionY), immutableEnvelope.getSpan(this.axisDimensionX), immutableEnvelope.getSpan(this.axisDimensionY));
        }
        assert (!this.isDefined(2));
        throw new InvalidGridGeometryException(this.gridToCRS == null ? 236 : 235);
    }

    public GridEnvelope2D getExtent2D() throws InvalidGridGeometryException {
        GridEnvelope gridEnvelope = this.extent;
        if (gridEnvelope != null) {
            assert (this.isDefined(4));
            return new GridEnvelope2D(gridEnvelope.getLow(this.gridDimensionX), gridEnvelope.getLow(this.gridDimensionY), gridEnvelope.getSpan(this.gridDimensionX), gridEnvelope.getSpan(this.gridDimensionY));
        }
        assert (!this.isDefined(4));
        throw new InvalidGridGeometryException(235);
    }

    public MathTransform2D getGridToCRS2D() throws InvalidGridGeometryException {
        if (this.gridToCRS2D != null) {
            return this.gridToCRS2D;
        }
        throw new InvalidGridGeometryException(168);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform2D getGridToCRS2D(PixelOrientation pixelOrientation) {
        if (this.gridToCRS2D == null) {
            throw new InvalidGridGeometryException(168);
        }
        if (!PixelOrientation.UPPER_LEFT.equals((Object)pixelOrientation)) {
            return this.computeGridToCRS2D(pixelOrientation);
        }
        GridGeometry2D gridGeometry2D = this;
        synchronized (gridGeometry2D) {
            if (this.cornerToCRS2D == null) {
                this.cornerToCRS2D = this.gridToCRS.getSourceDimensions() == 2 && this.gridToCRS.getTargetDimensions() == 2 ? (MathTransform2D)super.getGridToCRS(PixelInCell.CELL_CORNER) : this.computeGridToCRS2D(pixelOrientation);
            }
        }
        return this.cornerToCRS2D;
    }

    private MathTransform2D computeGridToCRS2D(PixelOrientation pixelOrientation) {
        int n = this.gridDimensionX < this.gridDimensionY ? 0 : 1;
        return (MathTransform2D)PixelTranslation.translate((MathTransform)this.gridToCRS2D, (PixelOrientation)PixelOrientation.CENTER, (PixelOrientation)pixelOrientation, (int)n, (int)(n ^ 1));
    }

    public MathTransform getGridToCRS(PixelOrientation pixelOrientation) {
        if (this.gridToCRS == null) {
            throw new InvalidGridGeometryException(236);
        }
        return PixelTranslation.translate((MathTransform)this.gridToCRS, (PixelOrientation)PixelOrientation.CENTER, (PixelOrientation)pixelOrientation, (int)this.gridDimensionX, (int)this.gridDimensionY);
    }

    final Point2D inverseTransform(Point2D point2D) throws InvalidGridGeometryException {
        if (this.gridFromCRS2D != null) {
            try {
                return this.gridFromCRS2D.transform(point2D, null);
            }
            catch (TransformException transformException) {
                throw new CannotEvaluateException(Errors.format((int)28, (Object)AbstractGridCoverage.toString(point2D, Locale.getDefault()), (Object)((Object)transformException)));
            }
        }
        throw new InvalidGridGeometryException(168);
    }

    final Rectangle inverseTransform(Rectangle2D rectangle2D) {
        if (rectangle2D != null && this.gridFromCRS2D != null) {
            try {
                rectangle2D = Envelopes.transform((MathTransform2D)this.gridFromCRS2D, (Rectangle2D)rectangle2D, null);
                int n = (int)Math.floor(rectangle2D.getMinX() - 0.5);
                int n2 = (int)Math.floor(rectangle2D.getMinY() - 0.5);
                int n3 = (int)Math.ceil(rectangle2D.getMaxX() - 0.5);
                int n4 = (int)Math.ceil(rectangle2D.getMaxY() - 0.5);
                return new Rectangle(n, n2, n3 - n, n4 - n2);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            GridGeometry2D gridGeometry2D = (GridGeometry2D)object;
            return this.gridDimensionX == gridGeometry2D.gridDimensionX && this.gridDimensionY == gridGeometry2D.gridDimensionY && this.axisDimensionX == gridGeometry2D.axisDimensionX && this.axisDimensionY == gridGeometry2D.axisDimensionY;
        }
        return false;
    }
}

