/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import javax.media.jai.Interpolation;
import javax.media.jai.OperationNode;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.remote.SerializableRenderedImage;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.AbstractGridCoverage;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.grid.RenderedCoverage;
import org.geotoolkit.coverage.grid.RenderedSampleDimension;
import org.geotoolkit.coverage.grid.ViewType;
import org.geotoolkit.coverage.grid.ViewsManager;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.geometry.TransformedDirectPosition;
import org.geotoolkit.internal.coverage.CoverageUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.TransformException;

public class GridCoverage2D
extends AbstractGridCoverage
implements RenderedCoverage {
    private static final long serialVersionUID = 667472989475027853L;
    private static final PixelInCell PIXEL_IN_CELL = PixelInCell.CELL_CORNER;
    protected final transient PlanarImage image;
    private RenderedImage serializedImage;
    protected final GridGeometry2D gridGeometry;
    final GridSampleDimension[] sampleDimensions;
    private transient ViewsManager views;
    private transient Set<ViewType> viewTypes;
    private transient TransformedDirectPosition arbitraryToInternal;
    transient String tileEncoding;

    GridCoverage2D(CharSequence charSequence, GridCoverage2D gridCoverage2D) {
        super(charSequence, gridCoverage2D);
        this.image = gridCoverage2D.image;
        this.gridGeometry = gridCoverage2D.gridGeometry;
        this.sampleDimensions = gridCoverage2D.sampleDimensions;
        this.tileEncoding = gridCoverage2D.tileEncoding;
    }

    public GridCoverage2D(CharSequence charSequence, RenderedImage renderedImage, GridGeometry2D gridGeometry2D, GridSampleDimension[] gridSampleDimensionArray, GridCoverage[] gridCoverageArray, Map<?, ?> map, Hints hints) throws IllegalArgumentException {
        this(charSequence, PlanarImage.wrapRenderedImage((RenderedImage)renderedImage), gridGeometry2D, gridSampleDimensionArray, gridCoverageArray, map, hints);
    }

    private GridCoverage2D(CharSequence charSequence, PlanarImage planarImage, GridGeometry2D gridGeometry2D, GridSampleDimension[] gridSampleDimensionArray, GridCoverage[] gridCoverageArray, Map<?, ?> map, Hints hints) throws IllegalArgumentException {
        super(charSequence, gridGeometry2D.getCoordinateReferenceSystem(), gridCoverageArray, (PropertySource)planarImage, map);
        Object object;
        this.image = planarImage;
        this.sampleDimensions = new GridSampleDimension[planarImage.getNumBands()];
        RenderedSampleDimension.create(charSequence, (RenderedImage)planarImage, gridSampleDimensionArray, this.sampleDimensions);
        int n = this.crs.getCoordinateSystem().getDimension();
        if (!gridGeometry2D.isDefined(4)) {
            object = new GeneralGridEnvelope((RenderedImage)planarImage, n);
            gridGeometry2D = gridGeometry2D.isDefined(8) ? new GridGeometry2D((GridEnvelope)object, PIXEL_IN_CELL, gridGeometry2D.getGridToCRS(PIXEL_IN_CELL), this.crs, hints) : new GridGeometry2D((GridEnvelope)object, gridGeometry2D.getEnvelope());
        } else {
            gridGeometry2D.getGridToCRS();
        }
        this.gridGeometry = gridGeometry2D;
        assert (gridGeometry2D.isDefined(15));
        object = GridCoverage2D.checkConsistency((RenderedImage)planarImage, gridGeometry2D);
        if (object != null) {
            throw new IllegalArgumentException((String)object);
        }
        if (n <= Math.max(gridGeometry2D.axisDimensionX, gridGeometry2D.axisDimensionY) || !(gridGeometry2D.envelope.getSpan(gridGeometry2D.axisDimensionX) > 0.0) || !(gridGeometry2D.envelope.getSpan(gridGeometry2D.axisDimensionY) > 0.0)) {
            throw new IllegalArgumentException(Errors.format((int)60));
        }
        if (hints != null) {
            this.tileEncoding = (String)hints.get((Object)Hints.TILE_ENCODING);
        }
    }

    private static String checkConsistency(RenderedImage renderedImage, GridGeometry2D gridGeometry2D) {
        GridEnvelope gridEnvelope = gridGeometry2D.getExtent();
        int n = gridEnvelope.getDimension();
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            int n3;
            if (i == gridGeometry2D.gridDimensionX) {
                n3 = renderedImage.getMinX();
                n2 = renderedImage.getWidth();
                object = "\"X\"";
            } else if (i == gridGeometry2D.gridDimensionY) {
                n3 = renderedImage.getMinY();
                n2 = renderedImage.getHeight();
                object = "\"Y\"";
            } else {
                n3 = gridEnvelope.getLow(i);
                n2 = Math.min(Math.max(gridEnvelope.getSpan(i), 0), 1);
                object = i;
            }
            if (gridEnvelope.getLow(i) == n3 && gridEnvelope.getSpan(i) == n2) continue;
            return Errors.format((int)9, (Object)object, (Object)n3, (Object)(n3 + n2));
        }
        return null;
    }

    @Override
    public boolean isDataEditable() {
        return this.image instanceof WritableRenderedImage;
    }

    public GridGeometry2D getGridGeometry() {
        String string = GridCoverage2D.checkConsistency((RenderedImage)this.image, this.gridGeometry);
        if (string != null) {
            throw new IllegalStateException(string);
        }
        return this.gridGeometry;
    }

    @Override
    public Envelope getEnvelope() {
        return this.gridGeometry.getEnvelope();
    }

    public Envelope2D getEnvelope2D() {
        return this.gridGeometry.getEnvelope2D();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() {
        return this.gridGeometry.getCoordinateReferenceSystem2D();
    }

    public int getNumSampleDimensions() {
        return this.sampleDimensions.length;
    }

    public GridSampleDimension getSampleDimension(int n) {
        return this.sampleDimensions[n];
    }

    public GridSampleDimension[] getSampleDimensions() {
        return (GridSampleDimension[])this.sampleDimensions.clone();
    }

    public Interpolation getInterpolation() {
        return Interpolation.getInstance((int)0);
    }

    public Object evaluate(DirectPosition directPosition) throws CannotEvaluateException {
        int n = this.image.getSampleModel().getDataType();
        switch (n) {
            case 0: {
                return this.evaluate(directPosition, (byte[])null);
            }
            case 1: 
            case 2: 
            case 3: {
                return this.evaluate(directPosition, (int[])null);
            }
            case 4: {
                return this.evaluate(directPosition, (float[])null);
            }
            case 5: {
                return this.evaluate(directPosition, (double[])null);
            }
        }
        throw new CannotEvaluateException();
    }

    @Override
    public byte[] evaluate(DirectPosition directPosition, byte[] byArray) throws CannotEvaluateException {
        int[] nArray = this.evaluate(directPosition, (int[])null);
        if (byArray == null) {
            byArray = new byte[nArray.length];
        }
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    @Override
    public int[] evaluate(DirectPosition directPosition, int[] nArray) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(directPosition), nArray);
    }

    @Override
    public float[] evaluate(DirectPosition directPosition, float[] fArray) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(directPosition), fArray);
    }

    @Override
    public double[] evaluate(DirectPosition directPosition, double[] dArray) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(directPosition), dArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Point2D toPoint2D(DirectPosition directPosition) throws CannotEvaluateException, MismatchedDimensionException {
        int n;
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            GridCoverage2D gridCoverage2D = this;
            synchronized (gridCoverage2D) {
                if (this.arbitraryToInternal == null) {
                    CoordinateReferenceSystem coordinateReferenceSystem2 = this.getCoordinateReferenceSystem2D();
                    this.arbitraryToInternal = new TransformedDirectPosition(coordinateReferenceSystem, coordinateReferenceSystem2, null);
                }
                try {
                    this.arbitraryToInternal.transform(directPosition);
                }
                catch (TransformException transformException) {
                    throw new CannotEvaluateException(this.formatEvaluateError(directPosition, false), (Throwable)transformException);
                }
                return this.arbitraryToInternal.toPoint2D();
            }
        }
        int n2 = directPosition.getDimension();
        if (n2 != (n = this.crs.getCoordinateSystem().getDimension())) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)n2, (Object)n));
        }
        if (directPosition instanceof Point2D) {
            return (Point2D)directPosition;
        }
        assert (this.gridGeometry.axisDimensionX < this.gridGeometry.axisDimensionY);
        return new Point2D.Double(directPosition.getOrdinate(this.gridGeometry.axisDimensionX), directPosition.getOrdinate(this.gridGeometry.axisDimensionY));
    }

    public int[] evaluate(Point2D point2D, int[] nArray) throws CannotEvaluateException {
        Point2D point2D2 = this.gridGeometry.inverseTransform(point2D);
        double d = point2D2.getX();
        double d2 = point2D2.getY();
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            int n = (int)Math.round(d);
            int n2 = (int)Math.round(d2);
            if (this.image.getBounds().contains(n, n2)) {
                return this.image.getTile(this.image.XToTileX(n), this.image.YToTileY(n2)).getPixel(n, n2, nArray);
            }
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(point2D, true));
    }

    public float[] evaluate(Point2D point2D, float[] fArray) throws CannotEvaluateException {
        Point2D point2D2 = this.gridGeometry.inverseTransform(point2D);
        double d = point2D2.getX();
        double d2 = point2D2.getY();
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            int n = (int)Math.round(d);
            int n2 = (int)Math.round(d2);
            if (this.image.getBounds().contains(n, n2)) {
                return this.image.getTile(this.image.XToTileX(n), this.image.YToTileY(n2)).getPixel(n, n2, fArray);
            }
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(point2D, true));
    }

    public double[] evaluate(Point2D point2D, double[] dArray) throws CannotEvaluateException {
        Point2D point2D2 = this.gridGeometry.inverseTransform(point2D);
        double d = point2D2.getX();
        double d2 = point2D2.getY();
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            int n = (int)Math.round(d);
            int n2 = (int)Math.round(d2);
            if (this.image.getBounds().contains(n, n2)) {
                return this.image.getTile(this.image.XToTileX(n), this.image.YToTileY(n2)).getPixel(n, n2, dArray);
            }
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(point2D, true));
    }

    public synchronized String getDebugString(DirectPosition directPosition) {
        Point2D point2D = this.toPoint2D(directPosition);
        point2D = this.gridGeometry.inverseTransform(point2D);
        int n = (int)Math.round(point2D.getX());
        int n2 = (int)Math.round(point2D.getY());
        if (this.image.getBounds().contains(n, n2)) {
            int n3 = this.image.getNumBands();
            Raster raster = this.image.getTile(this.image.XToTileX(n), this.image.YToTileY(n2));
            int n4 = this.image.getSampleModel().getDataType();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(').append(n).append(',').append(n2).append(")=[");
            for (int i = 0; i < n3; ++i) {
                if (i != 0) {
                    stringBuilder.append(";\u00a0");
                }
                double d = raster.getSampleDouble(n, n2, i);
                switch (n4) {
                    case 5: {
                        stringBuilder.append(d);
                        break;
                    }
                    case 4: {
                        stringBuilder.append((float)d);
                        break;
                    }
                    default: {
                        stringBuilder.append((int)d);
                    }
                }
                String string = this.sampleDimensions[i].getLabel(d, null);
                if (string == null) continue;
                stringBuilder.append("\u00a0(").append(string).append(')');
            }
            return stringBuilder.append(']').toString();
        }
        return null;
    }

    public int[] getOptimalDataBlockSizes() {
        int[] nArray = new int[this.getDimension()];
        Arrays.fill(nArray, 1);
        nArray[this.gridGeometry.gridDimensionX] = this.image.getTileWidth();
        nArray[this.gridGeometry.gridDimensionY] = this.image.getTileHeight();
        return nArray;
    }

    @Override
    public RenderedImage getRenderedImage() {
        return this.image;
    }

    @Override
    public RenderableImage getRenderableImage(int n, int n2) {
        if (n == this.gridGeometry.axisDimensionX && n2 == this.gridGeometry.axisDimensionY) {
            return new Renderable();
        }
        return super.getRenderableImage(n, n2);
    }

    @Override
    public void show(String string, int n, int n2) {
        GridCoverage2D gridCoverage2D = this.view(ViewType.RENDERED);
        if (gridCoverage2D != this) {
            gridCoverage2D.show(string, n, n2);
            return;
        }
        if (string == null || (string = string.trim()).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.getName()));
            int n3 = CoverageUtilities.getVisibleBand(this);
            GridSampleDimension gridSampleDimension = this.getSampleDimension(n3);
            Unit unit = gridSampleDimension.getUnits();
            stringBuilder.append(" - ").append(String.valueOf(gridSampleDimension.getDescription()));
            if (unit != null) {
                stringBuilder.append(" (").append(unit).append(')');
            }
            string = stringBuilder.toString();
        }
        super.show(string, n, n2);
    }

    @Override
    public void show(String string) {
        this.show(string, this.gridGeometry.axisDimensionX, this.gridGeometry.axisDimensionY);
    }

    public void prefetch(Rectangle2D rectangle2D) {
        Point[] pointArray = this.image.getTileIndices(this.gridGeometry.inverseTransform(rectangle2D));
        if (pointArray != null) {
            this.image.prefetchTiles(pointArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage2D view(ViewType viewType) {
        if (viewType == ViewType.SAME) {
            return this;
        }
        GridCoverage2D gridCoverage2D = this;
        synchronized (gridCoverage2D) {
            if (this.views == null) {
                this.views = ViewsManager.create(this);
            }
        }
        gridCoverage2D = null;
        return this.views.get(this, viewType, (Hints)gridCoverage2D);
    }

    GridCoverage2D getNativeView() {
        return this;
    }

    GridCoverage2D specialize(GridCoverage2D gridCoverage2D) {
        return gridCoverage2D;
    }

    Class<? extends GridCoverage2D> getViewClass() {
        return GridCoverage2D.class;
    }

    final synchronized ViewsManager copyViewsTo(GridCoverage2D gridCoverage2D) {
        if (this.views == null) {
            this.views = ViewsManager.create(this);
        }
        if (gridCoverage2D.views == null) {
            gridCoverage2D.views = this.views;
        } else if (gridCoverage2D.views != this.views) {
            throw new IllegalStateException();
        }
        return this.views;
    }

    public synchronized Set<ViewType> getViewTypes() {
        if (this.viewTypes == null) {
            EnumSet<ViewType> enumSet = EnumSet.allOf(ViewType.class);
            enumSet.remove((Object)ViewType.SAME);
            Iterator iterator = enumSet.iterator();
            while (iterator.hasNext()) {
                if (this.view((ViewType)((Object)iterator.next())) == this) continue;
                iterator.remove();
            }
            this.viewTypes = XCollections.unmodifiableSet(enumSet);
        }
        return this.viewTypes;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            Field field = GridCoverage2D.class.getDeclaredField("image");
            field.setAccessible(true);
            field.set(this, PlanarImage.wrapRenderedImage((RenderedImage)this.serializedImage));
        }
        catch (Exception exception) {
            InvalidClassException invalidClassException = new InvalidClassException(this.getClass().getCanonicalName(), exception.getLocalizedMessage());
            invalidClassException.initCause(exception);
            throw invalidClassException;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.serializedImage == null) {
            Object object = this.image;
            while (object instanceof RenderedImageAdapter) {
                object = ((RenderedImageAdapter)object).getWrappedImage();
            }
            if (object instanceof SerializableRenderedImage) {
                this.serializedImage = (SerializableRenderedImage)object;
            } else {
                if (this.tileEncoding == null) {
                    this.tileEncoding = "gzip";
                }
                this.serializedImage = new SerializableRenderedImage((RenderedImage)object, false, null, this.tileEncoding, null, null);
                LogRecord logRecord = Loggings.format((Level)Level.FINE, (int)19, (Object)this.getName(), (Object)this.tileEncoding);
                logRecord.setSourceClassName(GridCoverage2D.class.getName());
                logRecord.setSourceMethodName("writeObject");
                logRecord.setLoggerName(LOGGER.getName());
                LOGGER.log(logRecord);
            }
        }
        objectOutputStream.defaultWriteObject();
    }

    @Override
    public synchronized boolean dispose(boolean bl) {
        if (this.views != null) {
            if (this.views.dispose(bl).contains(this)) {
                return false;
            }
            this.views = null;
        } else if (!this.disposeImage(bl)) {
            return false;
        }
        return super.dispose(bl);
    }

    final synchronized boolean disposeImage(boolean bl) {
        if (!bl && !XCollections.isNullOrEmpty((Collection)this.image.getSinks())) {
            return false;
        }
        this.image.dispose();
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        String string = System.getProperty("line.separator", "\n");
        stringBuilder.append("\u2514 Image=").append(Classes.getShortClassName((Object)this.image)).append('[');
        if (this.image instanceof OperationNode) {
            stringBuilder.append('\"').append(((OperationNode)this.image).getOperationName()).append('\"');
        }
        stringBuilder.append(']');
        if (this.views == null || !Thread.holdsLock(this.views)) {
            stringBuilder.append(" as views ").append(this.getViewTypes());
        }
        return stringBuilder.append(string).toString();
    }

    protected class Renderable
    extends AbstractCoverage.Renderable {
        private static final long serialVersionUID = 4544636336787905450L;

        public Renderable() {
            super(GridCoverage2D.this.gridGeometry.axisDimensionX, GridCoverage2D.this.gridGeometry.axisDimensionY);
        }

        @Override
        public RenderedImage createDefaultRendering() {
            if (this.xAxis == GridCoverage2D.this.gridGeometry.axisDimensionX && this.yAxis == GridCoverage2D.this.gridGeometry.axisDimensionY) {
                return GridCoverage2D.this.getRenderedImage();
            }
            return super.createDefaultRendering();
        }
    }
}

