/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Point;
import org.geotoolkit.coverage.grid.GeneralGridCoordinates;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.opengis.coverage.grid.GridCoordinates;

public class GridCoordinates2D
extends Point
implements GridCoordinates,
Cloneable {
    private static final long serialVersionUID = -4583333545268906740L;

    public GridCoordinates2D() {
    }

    public GridCoordinates2D(int n, int n2) {
        super(n, n2);
    }

    public GridCoordinates2D(Point point) {
        super(point);
    }

    public final int getDimension() {
        return 2;
    }

    public int[] getCoordinateValues() {
        return new int[]{this.x, this.y};
    }

    public int getCoordinateValue(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(n));
    }

    public void setCoordinateValue(int n, int n2) throws IndexOutOfBoundsException, UnsupportedOperationException {
        switch (n) {
            case 0: {
                this.x = n2;
                break;
            }
            case 1: {
                this.y = n2;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(n));
            }
        }
    }

    static String indexOutOfBounds(int n) {
        return Errors.format((int)96, (Object)n);
    }

    @Override
    public String toString() {
        return GeneralGridCoordinates.toString(this);
    }

    @Override
    public GridCoordinates2D clone() {
        return (GridCoordinates2D)super.clone();
    }
}

