/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.util.Arrays;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.grid.GeneralGridCoordinates;
import org.geotoolkit.metadata.iso.spatial.PixelTranslation;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;

@Immutable
public class GeneralGridEnvelope
implements GridEnvelope,
Serializable {
    private static final long serialVersionUID = -1695224412095031712L;
    private transient GridCoordinates low;
    private transient GridCoordinates high;
    private final int[] index;

    private static void checkCoherence(int[] nArray) throws IllegalArgumentException {
        int n = nArray.length >>> 1;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = nArray[n + i];
            if (n2 <= n3) continue;
            throw new IllegalArgumentException(Errors.format((int)9, (Object)i, (Object)n2, (Object)(n3 - 1)));
        }
    }

    private GeneralGridEnvelope(int n) {
        this.index = new int[n << 1];
    }

    public GeneralGridEnvelope(GridEnvelope gridEnvelope) {
        int n = gridEnvelope.getDimension();
        this.index = new int[n << 1];
        for (int i = 0; i < n; ++i) {
            this.index[i] = gridEnvelope.getLow(i);
            this.index[i + n] = gridEnvelope.getHigh(i) + 1;
        }
        GeneralGridEnvelope.checkCoherence(this.index);
    }

    public GeneralGridEnvelope(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException(Errors.format((int)112, (Object)nArray.length, (Object)nArray2.length));
        }
        this.index = Arrays.copyOf(nArray, nArray.length + nArray2.length);
        System.arraycopy(nArray2, 0, this.index, nArray.length, nArray2.length);
        if (bl) {
            int n = nArray.length;
            while (n < this.index.length) {
                int n2 = n++;
                this.index[n2] = this.index[n2] + 1;
            }
        }
        GeneralGridEnvelope.checkCoherence(this.index);
    }

    public GeneralGridEnvelope(Rectangle rectangle, int n) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
    }

    public GeneralGridEnvelope(Raster raster, int n) {
        this(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), n);
    }

    public GeneralGridEnvelope(RenderedImage renderedImage, int n) {
        this(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), n);
    }

    private GeneralGridEnvelope(int n, int n2, int n3, int n4, int n5) {
        if (n5 < 2) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"dimension", (Object)n5));
        }
        this.index = new int[n5 << 1];
        this.index[0] = n;
        this.index[1] = n2;
        this.index[n5 + 0] = n + n3;
        this.index[n5 + 1] = n2 + n4;
        Arrays.fill(this.index, n5 + 2, this.index.length, 1);
        GeneralGridEnvelope.checkCoherence(this.index);
    }

    public GeneralGridEnvelope(Envelope envelope, PixelInCell pixelInCell, boolean bl) throws IllegalArgumentException {
        int n;
        double d = PixelTranslation.getPixelTranslation((PixelInCell)pixelInCell) + 0.5;
        int n2 = envelope.getDimension();
        this.index = new int[n2 << 1];
        for (n = 0; n < n2; ++n) {
            this.index[n] = (int)Math.round(envelope.getMinimum(n) + d);
            this.index[n + n2] = (int)Math.round(envelope.getMaximum(n) + d);
        }
        if (bl) {
            n = this.index.length >>> 1;
            while (n < this.index.length) {
                int n3 = n++;
                this.index[n3] = this.index[n3] + 1;
            }
        }
    }

    public int getDimension() {
        return this.index.length >>> 1;
    }

    public GridCoordinates getLow() {
        if (this.low == null) {
            this.low = new GeneralGridCoordinates.Immutable(this.index, 0, this.index.length >>> 1);
        }
        return this.low;
    }

    public GridCoordinates getHigh() {
        if (this.high == null) {
            GeneralGridCoordinates.Immutable immutable = new GeneralGridCoordinates.Immutable(this.index, this.index.length >>> 1, this.index.length);
            immutable.decrement();
            this.high = immutable;
        }
        return this.high;
    }

    public int getLow(int n) {
        if (n < this.index.length >>> 1) {
            return this.index[n];
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public int getHigh(int n) {
        if (n >= 0) {
            return this.index[n + (this.index.length >>> 1)] - 1;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public int getSpan(int n) {
        return this.index[n + (this.index.length >>> 1)] - this.index[n];
    }

    public GeneralGridEnvelope getSubGridEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = this.index.length >>> 1;
        int n4 = n2 - n;
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"lower", (Object)n));
        }
        if (n4 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"upper", (Object)n2));
        }
        GeneralGridEnvelope generalGridEnvelope = new GeneralGridEnvelope(n4);
        System.arraycopy(this.index, n, generalGridEnvelope.index, 0, n4);
        System.arraycopy(this.index, n + n3, generalGridEnvelope.index, n4, n4);
        return generalGridEnvelope;
    }

    public Rectangle toRectangle() throws IllegalStateException {
        if (this.index.length == 4) {
            return new Rectangle(this.index[0], this.index[1], this.index[2] - this.index[0], this.index[3] - this.index[1]);
        }
        throw new IllegalStateException(Errors.format((int)150, (Object)this.getDimension()));
    }

    public int hashCode() {
        return Arrays.hashCode(this.index) ^ 0xFE815660;
    }

    public boolean equals(Object object) {
        if (object instanceof GeneralGridEnvelope) {
            GeneralGridEnvelope generalGridEnvelope = (GeneralGridEnvelope)object;
            return Arrays.equals(this.index, generalGridEnvelope.index);
        }
        return false;
    }

    public String toString() {
        return GeneralGridEnvelope.toString(this);
    }

    static String toString(GridEnvelope gridEnvelope) {
        int n = gridEnvelope.getDimension();
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)gridEnvelope));
        stringBuilder.append('[');
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(gridEnvelope.getLow(i)).append('\u2026').append(gridEnvelope.getHigh(i));
        }
        return stringBuilder.append(']').toString();
    }
}

