/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import javax.media.jai.PropertySource;
import net.jcip.annotations.NotThreadSafe;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.referencing.CRS;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@NotThreadSafe
public class TransformedCoverage
extends AbstractCoverage {
    private static final long serialVersionUID = 638094266593359879L;
    protected final Coverage coverage;
    protected final MathTransform toOriginalCRS;
    private transient DirectPosition position;

    protected TransformedCoverage(CharSequence charSequence, CoordinateReferenceSystem coordinateReferenceSystem, Coverage coverage) throws FactoryException {
        super(charSequence, coordinateReferenceSystem, coverage instanceof PropertySource ? (PropertySource)coverage : null, null);
        this.coverage = coverage;
        this.toOriginalCRS = CRS.findMathTransform((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem());
    }

    public static Coverage reproject(CharSequence charSequence, CoordinateReferenceSystem coordinateReferenceSystem, Coverage coverage) throws FactoryException {
        while (true) {
            if (CRS.equalsIgnoreMetadata((Object)coverage.getCoordinateReferenceSystem(), (Object)coordinateReferenceSystem)) {
                return coverage;
            }
            if (coverage.getClass() != TransformedCoverage.class) break;
            coverage = ((TransformedCoverage)coverage).coverage;
        }
        return new TransformedCoverage(charSequence, coordinateReferenceSystem, coverage);
    }

    public int getNumSampleDimensions() {
        return this.coverage.getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int n) throws IndexOutOfBoundsException {
        return this.coverage.getSampleDimension(n);
    }

    private CannotEvaluateException transformationFailed(TransformException transformException) {
        return new CannotEvaluateException("Transformation failed", (Throwable)transformException);
    }

    @Override
    public Envelope getEnvelope() {
        GeneralEnvelope generalEnvelope;
        try {
            generalEnvelope = CRS.transform((MathTransform)this.toOriginalCRS.inverse(), (Envelope)this.coverage.getEnvelope());
        }
        catch (TransformException transformException) {
            throw this.transformationFailed(transformException);
        }
        generalEnvelope.setCoordinateReferenceSystem(this.crs);
        return generalEnvelope;
    }

    public final Object evaluate(DirectPosition directPosition) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            this.position = this.toOriginalCRS.transform(directPosition, this.position);
            return this.coverage.evaluate(this.position);
        }
        catch (TransformException transformException) {
            throw this.transformationFailed(transformException);
        }
    }

    @Override
    public final boolean[] evaluate(DirectPosition directPosition, boolean[] blArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            this.position = this.toOriginalCRS.transform(directPosition, this.position);
            return this.coverage.evaluate(this.position, blArray);
        }
        catch (TransformException transformException) {
            throw this.transformationFailed(transformException);
        }
    }

    @Override
    public final byte[] evaluate(DirectPosition directPosition, byte[] byArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            this.position = this.toOriginalCRS.transform(directPosition, this.position);
            return this.coverage.evaluate(this.position, byArray);
        }
        catch (TransformException transformException) {
            throw this.transformationFailed(transformException);
        }
    }

    @Override
    public final int[] evaluate(DirectPosition directPosition, int[] nArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            this.position = this.toOriginalCRS.transform(directPosition, this.position);
            return this.coverage.evaluate(this.position, nArray);
        }
        catch (TransformException transformException) {
            throw this.transformationFailed(transformException);
        }
    }

    @Override
    public final float[] evaluate(DirectPosition directPosition, float[] fArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            this.position = this.toOriginalCRS.transform(directPosition, this.position);
            return this.coverage.evaluate(this.position, fArray);
        }
        catch (TransformException transformException) {
            throw this.transformationFailed(transformException);
        }
    }

    @Override
    public final double[] evaluate(DirectPosition directPosition, double[] dArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            this.position = this.toOriginalCRS.transform(directPosition, this.position);
            return this.coverage.evaluate(this.position, dArray);
        }
        catch (TransformException transformException) {
            throw this.transformationFailed(transformException);
        }
    }
}

