/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.geotoolkit.coverage.CategoryList;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.SignedRectIter;
import org.geotoolkit.image.TransfertRectIter;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.logging.Logging;

final class SampleTranscoder
extends PointOpImage {
    public static final String OPERATION_NAME = "org.geotoolkit.SampleTranscode";
    private final CategoryList[] categories;
    private final boolean forceSigned;

    private SampleTranscoder(RenderedImage renderedImage, CategoryList[] categoryListArray, RenderingHints renderingHints) {
        super(renderedImage, (ImageLayout)renderingHints.get(JAI.KEY_IMAGE_LAYOUT), (Map)renderingHints, false);
        this.categories = categoryListArray;
        if (categoryListArray.length != renderedImage.getSampleModel().getNumBands()) {
            throw new RasterFormatException(String.valueOf(categoryListArray.length));
        }
        boolean bl = false;
        if (renderedImage.getSampleModel().getDataType() == 1) {
            for (CategoryList categoryList : categoryListArray) {
                if (!categoryList.isRangeSigned()) continue;
                bl = true;
                break;
            }
        }
        this.forceSigned = bl;
        this.permitInPlaceOperation();
    }

    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        PlanarImage planarImage = planarImageArray[0];
        Rectangle rectangle2 = rectangle.intersection(planarImage.getBounds());
        assert (rectangle.equals(rectangle2)) : rectangle;
        WritableRectIter writableRectIter = this.forceSigned ? new SignedRectIter(RectIterFactory.create((RenderedImage)planarImage, (Rectangle)rectangle2), RectIterFactory.createWritable((WritableRaster)writableRaster, (Rectangle)rectangle2)) : TransfertRectIter.create((RenderedImage)planarImage, writableRaster, rectangle2);
        int n = 0;
        if (!writableRectIter.finishedBands()) {
            do {
                this.categories[n++].transform(writableRectIter);
            } while (!writableRectIter.nextBandDone());
        }
        assert (n == this.categories.length) : n;
    }

    public static void register(JAI jAI) {
        OperationRegistry operationRegistry = jAI.getOperationRegistry();
        try {
            operationRegistry.registerDescriptor((RegistryElementDescriptor)new Descriptor());
            operationRegistry.registerFactory("rendered", OPERATION_NAME, "org.geotoolkit", (Object)new CRIF());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogRecord logRecord = Loggings.format((Level)Level.SEVERE, (int)12, (Object)OPERATION_NAME);
            logRecord.setSourceClassName(GridSampleDimension.class.getName());
            logRecord.setSourceMethodName("<classinit>");
            logRecord.setThrown(illegalArgumentException);
            Logger logger = Logging.getLogger(GridSampleDimension.class);
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    private static final class CRIF
    extends CRIFImpl {
        private CRIF() {
        }

        public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
            SampleTranscoder sampleTranscoder;
            RenderedImage renderedImage = (RenderedImage)parameterBlock.getSource(0);
            GridSampleDimension[] gridSampleDimensionArray = (GridSampleDimension[])parameterBlock.getObjectParameter(0);
            CategoryList[] categoryListArray = new CategoryList[gridSampleDimensionArray.length];
            for (int i = 0; i < categoryListArray.length; ++i) {
                categoryListArray[i] = gridSampleDimensionArray[i].categories;
            }
            if (renderedImage instanceof SampleTranscoder && CRIF.isInverse(categoryListArray, (sampleTranscoder = (SampleTranscoder)((Object)renderedImage)).categories)) {
                return sampleTranscoder.getSourceImage(0);
            }
            return new SampleTranscoder(renderedImage, categoryListArray, renderingHints);
        }

        private static boolean isInverse(CategoryList[] categoryListArray, CategoryList[] categoryListArray2) {
            if (categoryListArray.length != categoryListArray2.length) {
                return false;
            }
            for (int i = 0; i < categoryListArray.length; ++i) {
                if (categoryListArray[i].equals(categoryListArray2[i].inverse)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Descriptor
    extends OperationDescriptorImpl {
        private static final long serialVersionUID = -4204913600785080791L;

        public Descriptor() {
            super((String[][])new String[][]{{"GlobalName", SampleTranscoder.OPERATION_NAME}, {"LocalName", SampleTranscoder.OPERATION_NAME}, {"Vendor", "Geotoolkit.org"}, {"Description", "Transformation from sample to geophysics values"}, {"DocURL", "http://www.geotoolkit.org/"}, {"Version", "1.0"}}, new String[]{"rendered"}, 1, new String[]{"sampleDimensions"}, new Class[]{GridSampleDimension[].class}, new Object[]{NO_PARAMETER_DEFAULT}, null);
        }

        protected boolean validateParameters(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
            if (!super.validateParameters(string, parameterBlock, stringBuffer)) {
                return false;
            }
            RenderedImage renderedImage = (RenderedImage)parameterBlock.getSource(0);
            GridSampleDimension[] gridSampleDimensionArray = (GridSampleDimension[])parameterBlock.getObjectParameter(0);
            int n = renderedImage.getSampleModel().getNumBands();
            if (n != gridSampleDimensionArray.length) {
                stringBuffer.append(Errors.format((int)177, (Object)n, (Object)gridSampleDimensionArray.length, (Object)"SampleDimension"));
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (gridSampleDimensionArray[i].categories != null) continue;
                stringBuffer.append(Errors.format((int)12, (Object)("sampleDimensions[" + i + "].categories"), null));
                return false;
            }
            return true;
        }
    }
}

