/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.measure.unit.Unit;
import javax.media.jai.JAI;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.CategoryList;
import org.geotoolkit.coverage.SampleTranscoder;
import org.geotoolkit.coverage.TypeMap;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.Numbers;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.PaletteInterpretation;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@Immutable
public class GridSampleDimension
implements SampleDimension,
Serializable {
    private static final long serialVersionUID = 6026936545776852758L;
    private GridSampleDimension inverse;
    final CategoryList categories;
    private final boolean isGeophysics;
    private final boolean hasQualitative;
    private final boolean hasQuantitative;
    private final MathTransform1D sampleToGeophysics;
    private final InternationalString description;

    public GridSampleDimension(CharSequence charSequence) {
        this(charSequence, (CategoryList)null);
    }

    public GridSampleDimension(CharSequence charSequence, CharSequence[] charSequenceArray) {
        this(charSequence, GridSampleDimension.list(charSequenceArray));
    }

    private static CategoryList list(CharSequence[] charSequenceArray) {
        int n = charSequenceArray.length;
        Color[] colorArray = new Color[n];
        double d = 255.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            int n2 = (int)Math.round(d * (double)i);
            colorArray[i] = new Color(n2, n2, n2);
        }
        return GridSampleDimension.list(charSequenceArray, colorArray);
    }

    public GridSampleDimension(CharSequence charSequence, CharSequence[] charSequenceArray, Color[] colorArray) {
        this(charSequence, GridSampleDimension.list(charSequenceArray, colorArray));
    }

    private static CategoryList list(CharSequence[] charSequenceArray, Color[] colorArray) {
        if (charSequenceArray.length != colorArray.length) {
            throw new IllegalArgumentException(Errors.format((int)110, (Object)"names", (Object)"colors"));
        }
        int n = charSequenceArray.length;
        Category[] categoryArray = new Category[n];
        for (int i = 0; i < n; ++i) {
            categoryArray[i] = new Category(charSequenceArray[i], colorArray[i], i);
        }
        return GridSampleDimension.list(categoryArray, null);
    }

    public GridSampleDimension(CharSequence charSequence, SampleDimensionType sampleDimensionType, ColorInterpretation colorInterpretation, Color[] colorArray, CharSequence[] charSequenceArray, double[] dArray, double d, double d2, double d3, double d4, Unit<?> unit) {
        this(charSequence, GridSampleDimension.list(charSequence, sampleDimensionType, colorInterpretation, colorArray, charSequenceArray, dArray, d, d2, d3, d4, unit));
    }

    private static CategoryList list(CharSequence charSequence, SampleDimensionType sampleDimensionType, ColorInterpretation colorInterpretation, Color[] colorArray, CharSequence[] charSequenceArray, double[] dArray, double d, double d2, double d3, double d4, Unit<?> unit) {
        NumberRange<?> numberRange;
        NumberRange numberRange2;
        Object object;
        Number number;
        int n;
        if (charSequence == null) {
            charSequence = Vocabulary.formatInternational((int)311);
        }
        if (Double.isInfinite(d) || Double.isInfinite(d2) || !(d < d2)) {
            throw new IllegalArgumentException(Errors.format((int)14, (Object)d, (Object)d2));
        }
        if (Double.isNaN(d3) || Double.isInfinite(d3) || d3 == 0.0) {
            throw new IllegalArgumentException(Errors.format((int)12, (Object)"scale", (Object)d3));
        }
        if (Double.isNaN(d4) || Double.isInfinite(d4)) {
            throw new IllegalArgumentException(Errors.format((int)12, (Object)"offset", (Object)d4));
        }
        if (sampleDimensionType == null) {
            sampleDimensionType = TypeMap.getSampleDimensionType(d, d2);
        }
        if (colorInterpretation == null) {
            colorInterpretation = ColorInterpretation.PALETTE_INDEX;
        }
        int n2 = charSequenceArray != null ? charSequenceArray.length : 0;
        int n3 = dArray != null ? dArray.length : 0;
        ArrayList<Category> arrayList = new ArrayList<Category>(n2 + n3 + 2);
        for (n = 0; n < n3; ++n) {
            CharSequence charSequence2 = null;
            double d5 = dArray[n];
            int n4 = (int)Math.floor(d5);
            if (n4 >= 0 && n4 < n2) {
                if ((double)n4 == d5) continue;
                charSequence2 = charSequenceArray[n4];
            }
            number = TypeMap.wrapSample(d5, sampleDimensionType, false);
            if (charSequence2 == null) {
                charSequence2 = number.toString();
            }
            object = new NumberRange(number.getClass(), number, number);
            numberRange2 = ColorUtilities.subarray(colorArray, n4, n4 + 1);
            arrayList.add(new Category(charSequence2, (Color[])numberRange2, (NumberRange<?>)object, (MathTransform1D)null));
        }
        if (n2 != 0) {
            n = 0;
            int n5 = charSequenceArray.length;
            for (int i = 1; i <= n5; ++i) {
                Object object2;
                if (i != n5 && (numberRange = ((Object)charSequenceArray[n]).toString().trim()).equalsIgnoreCase((String)(object2 = ((Object)charSequenceArray[i]).toString().trim()))) continue;
                numberRange = charSequenceArray[n];
                object2 = TypeMap.wrapSample(n, sampleDimensionType, false);
                if (object2.equals(number = TypeMap.wrapSample(i - 1, sampleDimensionType, false))) {
                    object2 = number;
                    object = number.getClass();
                } else {
                    object = Numbers.widestClass((Number)object2, (Number)number);
                    object2 = Numbers.cast((Number)object2, (Class)object);
                    number = Numbers.cast((Number)number, (Class)object);
                }
                numberRange2 = new NumberRange((Class)object, (Number)object2, number);
                Color[] colorArray2 = ColorUtilities.subarray(colorArray, n, i);
                arrayList.add(new Category((CharSequence)numberRange, colorArray2, (NumberRange<?>)numberRange2, (MathTransform1D)null));
                n = i;
            }
        }
        n = 0;
        if (d3 != 1.0 || d4 != 0.0 || n3 != 0 || arrayList.size() <= 1) {
            n = 1;
            int n6 = arrayList.size();
            while (--n6 >= 0) {
                double d6;
                double d7;
                Number number2;
                int n7;
                Category category = (Category)arrayList.get(n6);
                if (category.isQuantitative() || (n7 = ((Comparable)((Object)(number2 = (Number)((Object)(numberRange = category.getRange()).getMinValue())))).compareTo(number = (Number)((Object)numberRange.getMaxValue()))) == 0 || GridSampleDimension.rangeContains(d7 = number2.doubleValue(), d6 = number.doubleValue(), dArray)) continue;
                InternationalString internationalString = category.getName();
                Color[] colorArray3 = category.getColors();
                category = new Category((CharSequence)internationalString, colorArray3, numberRange, d3, d4);
                arrayList.set(n6, category);
                n = 0;
            }
        }
        if (n != 0) {
            boolean bl = true;
            boolean bl2 = true;
            int n8 = arrayList.size();
            while (--n8 >= 0) {
                NumberRange<?> numberRange3 = ((Category)arrayList.get(n8)).getRange();
                double d8 = numberRange3.getMinimum();
                double d9 = numberRange3.getMaximum();
                if (d9 - d < d2 - d8) {
                    if (!(d9 >= d)) continue;
                    d = d9;
                    bl = !numberRange3.isMaxIncluded();
                    continue;
                }
                if (!(d8 <= d2)) continue;
                d2 = d8;
                bl2 = !numberRange3.isMinIncluded();
            }
            boolean bl3 = !bl || !bl2;
            if (d2 - d > (double)bl3) {
                Number number3 = TypeMap.wrapSample(d, sampleDimensionType, false);
                Number number4 = TypeMap.wrapSample(d2, sampleDimensionType, false);
                Class clazz = Numbers.widestClass((Number)number3, (Number)number4);
                number3 = Numbers.cast((Number)number3, (Class)clazz);
                number4 = Numbers.cast((Number)number4, (Class)clazz);
                NumberRange numberRange4 = new NumberRange(clazz, number3, bl, number4, bl2);
                Color[] colorArray4 = ColorUtilities.subarray(colorArray, (int)Math.ceil(d), (int)Math.floor(d2));
                arrayList.add(new Category(charSequence, colorArray4, numberRange4, d3, d4));
                n = 0;
            }
        }
        Category[] categoryArray = arrayList.toArray(new Category[arrayList.size()]);
        if (ColorInterpretation.PALETTE_INDEX.equals((Object)colorInterpretation) || ColorInterpretation.GRAY_INDEX.equals((Object)colorInterpretation)) {
            return GridSampleDimension.list(categoryArray, unit);
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public GridSampleDimension(CharSequence charSequence, Category[] categoryArray, Unit<?> unit) throws IllegalArgumentException {
        this(charSequence, GridSampleDimension.list(categoryArray, unit));
    }

    private static CategoryList list(Category[] categoryArray, Unit<?> unit) {
        if (categoryArray == null || categoryArray.length == 0) {
            if (unit == null) {
                return null;
            }
            if (categoryArray == null) {
                categoryArray = new Category[]{};
            }
        }
        CategoryList categoryList = new CategoryList(categoryArray, unit);
        if (CategoryList.isGeophysics(categoryArray, false)) {
            return categoryList;
        }
        if (CategoryList.isGeophysics(categoryArray, true)) {
            return categoryList.inverse;
        }
        throw new IllegalArgumentException(Errors.format((int)122));
    }

    private GridSampleDimension(CharSequence charSequence, CategoryList categoryList) {
        this.description = charSequence != null ? SimpleInternationalString.wrap((CharSequence)charSequence) : (categoryList != null ? new CategoryList.Name(categoryList) : Vocabulary.formatInternational((int)311));
        MathTransform1D mathTransform1D = null;
        boolean bl = true;
        boolean bl2 = false;
        if (categoryList != null) {
            int n = categoryList.size();
            while (--n >= 0) {
                MathTransform1D mathTransform1D2 = categoryList.get(n).getSampleToGeophysics();
                if (mathTransform1D2 == null) {
                    bl2 = true;
                    continue;
                }
                if (mathTransform1D != null) {
                    bl &= mathTransform1D.equals(mathTransform1D2);
                }
                mathTransform1D = mathTransform1D2;
            }
            this.isGeophysics = categoryList.isGeophysics(true);
        } else {
            this.isGeophysics = false;
        }
        this.categories = categoryList;
        this.hasQualitative = bl2;
        this.hasQuantitative = mathTransform1D != null;
        this.sampleToGeophysics = bl ? mathTransform1D : null;
    }

    protected GridSampleDimension(GridSampleDimension gridSampleDimension) {
        if (gridSampleDimension != null) {
            this.inverse = gridSampleDimension.inverse;
            this.categories = gridSampleDimension.categories;
            this.isGeophysics = gridSampleDimension.isGeophysics;
            this.hasQualitative = gridSampleDimension.hasQualitative;
            this.hasQuantitative = gridSampleDimension.hasQuantitative;
            this.sampleToGeophysics = gridSampleDimension.sampleToGeophysics;
            this.description = gridSampleDimension.description;
        } else {
            this.categories = null;
            this.isGeophysics = false;
            this.hasQualitative = false;
            this.hasQuantitative = false;
            this.sampleToGeophysics = null;
            this.description = Vocabulary.formatInternational((int)311);
        }
    }

    public static GridSampleDimension castOrCopy(SampleDimension sampleDimension) {
        Color[] colorArray;
        if (sampleDimension instanceof GridSampleDimension) {
            return (GridSampleDimension)sampleDimension;
        }
        int[][] nArray = sampleDimension.getPalette();
        if (nArray != null) {
            int n = nArray.length;
            colorArray = new Color[n];
            for (int i = 0; i < n; ++i) {
                int[] nArray2 = nArray[i];
                colorArray[i] = new Color(nArray2[0], nArray2[1], nArray2[2]);
            }
        } else {
            colorArray = null;
        }
        return new GridSampleDimension((CharSequence)sampleDimension.getDescription(), sampleDimension.getSampleDimensionType(), sampleDimension.getColorInterpretation(), colorArray, (CharSequence[])sampleDimension.getCategoryNames(), sampleDimension.getNoDataValues(), sampleDimension.getMinimumValue(), sampleDimension.getMaximumValue(), sampleDimension.getScale(), sampleDimension.getOffset(), sampleDimension.getUnits());
    }

    public SampleDimensionType getSampleDimensionType() {
        NumberRange<?> numberRange = this.getRange();
        if (numberRange == null) {
            return SampleDimensionType.REAL_32BITS;
        }
        return TypeMap.getSampleDimensionType(numberRange);
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public InternationalString[] getCategoryNames() throws IllegalStateException {
        if (this.categories == null) {
            return null;
        }
        if (this.categories.isEmpty()) {
            return new InternationalString[0];
        }
        Object[] objectArray = null;
        int n = this.categories.size();
        while (--n >= 0) {
            Category category = this.categories.get(n);
            int n2 = (int)category.minimum;
            int n3 = (int)category.maximum;
            if ((double)n2 != category.minimum || n2 < 0 || (double)n3 != category.maximum || n3 < 0) {
                throw new IllegalStateException(Errors.format((int)133));
            }
            if (objectArray == null) {
                objectArray = new InternationalString[n3 + 1];
            }
            Arrays.fill(objectArray, n2, n3 + 1, category.getName());
        }
        return objectArray;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public Category getCategory(double d) {
        return this.categories != null ? this.categories.getCategory(d) : null;
    }

    public Category getBackground() {
        return this.categories != null ? this.categories.nodata : Category.NODATA;
    }

    public double[] getNoDataValues() throws IllegalStateException {
        if (!this.hasQuantitative) {
            return null;
        }
        int n = 0;
        double[] dArray = null;
        int n2 = this.categories.size();
        for (int i = 0; i < n2; ++i) {
            Category category = this.categories.get(i);
            if (category.isQuantitative()) continue;
            double d = category.minimum;
            double d2 = category.maximum;
            if (Double.isNaN(d) && Double.isNaN(d2)) continue;
            if (dArray == null) {
                dArray = new double[n2 - i];
            }
            if (n >= dArray.length) {
                dArray = Arrays.copyOf(dArray, n * 2);
            }
            dArray[n++] = d;
            if (d2 == d) continue;
            int n3 = (int)d;
            int n4 = (int)d2;
            if ((double)n3 != d || (double)n4 != d2 || !Numbers.isInteger((Class)category.getRange().getElementType())) {
                throw new IllegalStateException(Errors.format((int)133));
            }
            int n5 = n + (n4 - n3);
            if (n5 > dArray.length) {
                dArray = Arrays.copyOf(dArray, n5 * 2);
            }
            while (++n3 <= n4) {
                dArray[n++] = n3;
            }
        }
        if (dArray != null) {
            dArray = ArraysExt.resize(dArray, (int)n);
        }
        return dArray;
    }

    public double getMinimumValue() {
        double d;
        if (!XCollections.isNullOrEmpty((Collection)this.categories) && !Double.isNaN(d = this.categories.get((int)0).minimum)) {
            return d;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getMaximumValue() {
        if (this.categories != null) {
            int n = this.categories.size();
            while (--n >= 0) {
                double d = this.categories.get((int)n).maximum;
                if (Double.isNaN(d)) continue;
                return d;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public NumberRange<?> getRange() {
        return this.categories != null ? this.categories.getRange() : null;
    }

    public boolean isRangeSigned() {
        return this.categories != null && this.categories.isRangeSigned();
    }

    private static boolean rangeContains(double d, double d2, double[] dArray) {
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i];
                if (!(d3 >= d) || !(d3 < d2)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLabel(double d, Locale locale) {
        if (this.categories != null) {
            if (this.isGeophysics) {
                return this.categories.format(d, locale);
            }
            try {
                return this.categories.inverse.format(this.categories.transform(d), locale);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return null;
    }

    public Unit<?> getUnits() {
        return this.categories != null ? this.categories.geophysics(true).getUnits() : null;
    }

    public double getOffset() throws IllegalStateException {
        return this.getCoefficient(0);
    }

    public double getScale() {
        return this.getCoefficient(1);
    }

    private double getCoefficient(int n) throws IllegalStateException {
        if (!this.hasQuantitative) {
            return n;
        }
        TransformException transformException = null;
        if (this.sampleToGeophysics != null) {
            try {
                double d;
                switch (n) {
                    case 0: {
                        d = this.sampleToGeophysics.transform(0.0);
                        break;
                    }
                    case 1: {
                        d = this.sampleToGeophysics.derivative(Double.NaN);
                        break;
                    }
                    default: {
                        throw new AssertionError(n);
                    }
                }
                if (!Double.isNaN(d)) {
                    return d;
                }
            }
            catch (TransformException transformException2) {
                transformException = transformException2;
            }
        }
        throw new IllegalStateException(Errors.format((int)134), transformException);
    }

    public MathTransform1D getSampleToGeophysics() {
        if (this.isGeophysics) {
            return LinearTransform1D.IDENTITY;
        }
        if (!this.hasQualitative && this.sampleToGeophysics != null) {
            return this.sampleToGeophysics;
        }
        return this.categories;
    }

    public GridSampleDimension geophysics(boolean bl) {
        if (bl == this.isGeophysics) {
            return this;
        }
        if (this.inverse == null) {
            if (this.categories != null) {
                this.inverse = new GridSampleDimension((CharSequence)this.description, this.categories.inverse);
                this.inverse.inverse = this;
            } else {
                this.inverse = this;
            }
        }
        return this.inverse;
    }

    @Deprecated
    public int[][] getPalette() {
        ColorModel colorModel = this.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int[][] nArrayArray = new int[indexColorModel.getMapSize()][];
            for (int i = 0; i < nArrayArray.length; ++i) {
                nArrayArray[i] = new int[]{indexColorModel.getRed(i), indexColorModel.getGreen(i), indexColorModel.getBlue(i)};
            }
            return nArrayArray;
        }
        return null;
    }

    @Deprecated
    public PaletteInterpretation getPaletteInterpretation() {
        return PaletteInterpretation.RGB;
    }

    @Deprecated
    public ColorInterpretation getColorInterpretation() {
        return TypeMap.getColorInterpretation(this.getColorModel(0, 1), 0);
    }

    public ColorModel getColorModel() {
        return this.getColorModel(0, 1);
    }

    public ColorModel getColorModel(int n, int n2) {
        if (this.categories != null) {
            if (this.isGeophysics && this.hasQualitative) {
                return this.categories.getColorModel(n, n2, 4);
            }
            return this.categories.getColorModel(n, n2);
        }
        return null;
    }

    public ColorModel getColorModel(int n, int n2, int n3) {
        if (this.categories != null) {
            return this.categories.getColorModel(n, n2, n3);
        }
        return null;
    }

    public GridSampleDimension rescale(double d, double d2) {
        MathTransform1D mathTransform1D = Category.createLinearTransform(d, d2);
        Category[] categoryArray = (Category[])this.getCategories().toArray();
        boolean bl = false;
        for (int i = 0; i < categoryArray.length; ++i) {
            Category category = categoryArray[i];
            if (category.isQuantitative()) {
                category = category.rescale(mathTransform1D);
            }
            if (categoryArray[i].equals(category = category.geophysics(this.isGeophysics))) continue;
            categoryArray[i] = category;
            bl = true;
        }
        return bl ? new GridSampleDimension((CharSequence)this.description, categoryArray, this.getUnits()) : this;
    }

    public int hashCode() {
        return this.categories != null ? this.categories.hashCode() : 920215318;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridSampleDimension) {
            GridSampleDimension gridSampleDimension = (GridSampleDimension)object;
            return Utilities.equals((Object)this.categories, (Object)gridSampleDimension.categories);
        }
        return false;
    }

    public String toString() {
        if (this.categories != null) {
            return this.categories.toString(this, this.description);
        }
        return Classes.getShortClassName((Object)this) + "[\"" + this.description + "\"]";
    }

    static {
        SampleTranscoder.register(JAI.getDefaultInstance());
    }
}

