/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.CategoryList;
import org.geotoolkit.util.Utilities;

@Immutable
final class GeophysicsCategoryList
extends CategoryList {
    private static final long serialVersionUID = 98602310176453958L;
    private static final int MAX_DIGITS = 6;
    private static final double EPS = 1.0E-6;
    private final Unit<?> unit;
    private final int ndigits;
    private transient Locale locale;
    private transient NumberFormat format;

    GeophysicsCategoryList(Category[] categoryArray, Unit<?> unit, CategoryList categoryList) {
        super(categoryArray, unit, true, categoryList);
        this.unit = unit;
        this.ndigits = GeophysicsCategoryList.getFractionDigitCount(categoryArray);
        assert (this.isGeophysics(true));
    }

    private static int getFractionDigitCount(Category[] categoryArray) {
        int n = 0;
        for (Category category : categoryArray) {
            int n2;
            Category category2 = category.geophysics(true);
            Category category3 = category.geophysics(false);
            double d = Math.log10((category2.maximum - category2.minimum) / (category3.maximum - category3.minimum));
            if (Double.isNaN(d) || (n2 = -((int)Math.floor(d + 1.0E-6))) <= n) continue;
            n = Math.min(n2, 6);
        }
        return n;
    }

    @Override
    public CategoryList geophysics(boolean bl) {
        CategoryList categoryList;
        CategoryList categoryList2 = categoryList = bl ? this : this.inverse;
        assert (categoryList.isGeophysics(bl));
        return categoryList;
    }

    @Override
    public Unit<?> getUnits() {
        return this.unit;
    }

    @Override
    synchronized StringBuffer format(double d, boolean bl, Locale locale, StringBuffer stringBuffer) {
        if (this.format == null || !Utilities.equals((Object)this.locale, (Object)locale)) {
            this.locale = locale;
            this.format = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance();
            this.format.setMinimumFractionDigits(this.ndigits);
            this.format.setMaximumFractionDigits(this.ndigits);
        }
        stringBuffer = this.format.format(d, stringBuffer, new FieldPosition(0));
        if (bl && this.unit != null) {
            int n = stringBuffer.length();
            stringBuffer.append('\u00a0').append(this.unit);
            if (stringBuffer.length() == n + 1) {
                stringBuffer.setLength(n);
            }
        }
        return stringBuffer;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof GeophysicsCategoryList) {
            GeophysicsCategoryList geophysicsCategoryList = (GeophysicsCategoryList)object;
            return this.ndigits == geophysicsCategoryList.ndigits && Utilities.equals(this.unit, geophysicsCategoryList.unit) && super.equals(geophysicsCategoryList);
        }
        return this.ndigits == 0 && this.unit == null && super.equals(object);
    }
}

