/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.Color;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NumberRange;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@Immutable
final class GeophysicsCategory
extends Category {
    private static final long serialVersionUID = -7164422654831370784L;

    GeophysicsCategory(Category category, boolean bl) throws TransformException {
        super(category, bl);
    }

    @Override
    public InternationalString getName() {
        assert (!(this.inverse instanceof GeophysicsCategory));
        return this.inverse.getName();
    }

    @Override
    public Color[] getColors() {
        assert (!(this.inverse instanceof GeophysicsCategory));
        return this.inverse.getColors();
    }

    @Override
    public NumberRange<?> getRange() throws IllegalStateException {
        NumberRange numberRange = this.range;
        if (numberRange == null) {
            try {
                MathTransform1D mathTransform1D = this.inverse.transform;
                NumberRange<?> numberRange2 = this.inverse.range;
                boolean bl = numberRange2.isMinIncluded();
                boolean bl2 = numberRange2.isMaxIncluded();
                double d = mathTransform1D.transform(numberRange2.getMinimum());
                double d2 = mathTransform1D.transform(numberRange2.getMaximum());
                double d3 = mathTransform1D.transform(numberRange2.getMinimum(!bl));
                double d4 = mathTransform1D.transform(numberRange2.getMaximum(!bl2));
                double d5 = bl ? d3 : d;
                double d6 = bl2 ? d4 : d2;
                if (d5 > d6) {
                    double d7 = d;
                    double d8 = d3;
                    boolean bl3 = bl;
                    d = d2;
                    d3 = d4;
                    bl = bl2;
                    d2 = d7;
                    d4 = d8;
                    bl2 = bl3;
                }
                assert (Double.doubleToLongBits(this.minimum) == Double.doubleToLongBits(bl ? d : d3));
                assert (Double.doubleToLongBits(this.maximum) == Double.doubleToLongBits(bl2 ? d2 : d4));
                this.range = numberRange = new Range(d, bl, d2, bl2, d3, d4);
            }
            catch (TransformException transformException) {
                throw new IllegalStateException(Errors.format((int)16, this.inverse.transform.getClass()), transformException);
            }
        }
        return numberRange;
    }

    @Override
    public MathTransform1D getSampleToGeophysics() {
        return this.isQuantitative() ? LinearTransform1D.IDENTITY : null;
    }

    @Override
    public boolean isQuantitative() {
        assert (!(this.inverse instanceof GeophysicsCategory)) : this.inverse;
        return this.inverse.isQuantitative();
    }

    @Override
    public Category recolor(Color[] colorArray) {
        assert (!(this.inverse instanceof GeophysicsCategory)) : this.inverse;
        return this.inverse.recolor((Color[])colorArray).inverse;
    }

    @Override
    public Category rescale(MathTransform1D mathTransform1D) {
        if (mathTransform1D.isIdentity()) {
            return this;
        }
        mathTransform1D = MathTransforms.concatenate((MathTransform1D)this.inverse.getSampleToGeophysics(), (MathTransform1D)mathTransform1D);
        return this.inverse.rescale((MathTransform1D)mathTransform1D).inverse;
    }

    @Override
    public Category geophysics(boolean bl) {
        assert (!(this.inverse instanceof GeophysicsCategory)) : this.inverse;
        return this.inverse.geophysics(bl);
    }

    private static final class Range
    extends NumberRange<Double> {
        private static final long serialVersionUID = -1416908614729956928L;
        private final double minimum2;
        private final double maximum2;

        public Range(double d, boolean bl, double d2, boolean bl2, double d3, double d4) {
            super(Double.class, (Number)d, bl, (Number)d2, bl2);
            this.minimum2 = d3;
            this.maximum2 = d4;
        }

        public double getMinimum(boolean bl) {
            return bl == this.isMinIncluded() ? this.getMinimum() : this.minimum2;
        }

        public double getMaximum(boolean bl) {
            return bl == this.isMaxIncluded() ? this.getMaximum() : this.maximum2;
        }
    }
}

