/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.media.jai.InterpolationNearest;
import net.jcip.annotations.ThreadSafe;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.BackingStoreException;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.coverage.OrdinateOutsideCoverageException;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.Interpolator2D;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.image.io.IIOListeners;
import org.geotoolkit.image.io.IIOReadProgressAdapter;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultTemporalCRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.collection.FrequencySortedSet;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@ThreadSafe
public class CoverageStack
extends AbstractCoverage {
    private static final long serialVersionUID = -7100201963376146053L;
    private final Element[] elements;
    private final SampleDimension[] sampleDimensions;
    private final int numSampleDimensions;
    private final GeneralEnvelope envelope;
    private transient GeneralDirectPosition reducedPosition;
    public final int zDimension;
    private final CoordinateReferenceSystem zCRS;
    private boolean interpolationEnabled = true;
    private final double lagTolerance = 0.0;
    private final IIOListeners listeners = new IIOListeners();
    private transient Listeners readListener;
    private transient Coverage lower;
    private transient Coverage upper;
    private transient double lowerZ = Double.POSITIVE_INFINITY;
    private transient double upperZ = Double.NEGATIVE_INFINITY;
    private transient NumberRange<?> lowerRange;
    private transient NumberRange<?> upperRange;
    private transient byte[] byteBuffer;
    private transient int[] intBuffer;
    private transient float[] floatBuffer;
    private transient double[] doubleBuffer;
    private static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            try {
                return Double.compare(CoverageStack.zFromObject(object), CoverageStack.zFromObject(object2));
            }
            catch (IOException iOException) {
                throw new org.geotoolkit.util.collection.BackingStoreException((Throwable)iOException);
            }
        }
    };

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lowerZ = Double.POSITIVE_INFINITY;
        this.upperZ = Double.NEGATIVE_INFINITY;
    }

    public CoverageStack(CharSequence charSequence, Collection<? extends Coverage> collection) throws IOException {
        this(charSequence, (CoordinateReferenceSystem)null, CoverageStack.toElements(collection));
    }

    private static Element[] toElements(Collection<? extends Coverage> collection) {
        Element[] elementArray = new Element[collection.size()];
        int n = 0;
        for (Coverage coverage : collection) {
            elementArray[n++] = new Adapter(coverage, null);
        }
        return elementArray;
    }

    public CoverageStack(CharSequence charSequence, CoordinateReferenceSystem coordinateReferenceSystem, Collection<? extends Element> collection) throws IOException {
        this(charSequence, coordinateReferenceSystem, collection.toArray(new Element[collection.size()]));
    }

    private CoverageStack(CharSequence charSequence, CoordinateReferenceSystem coordinateReferenceSystem, Element[] elementArray) throws IOException {
        this(charSequence, CoverageStack.getEnvelope(coordinateReferenceSystem, elementArray), elementArray);
    }

    private CoverageStack(CharSequence charSequence, GeneralEnvelope generalEnvelope, Element[] elementArray) throws IOException {
        super(charSequence, generalEnvelope.getCoordinateReferenceSystem(), null, null);
        assert (ArraysExt.isSorted((Object[])elementArray, COMPARATOR, (boolean)false));
        this.elements = elementArray;
        this.envelope = generalEnvelope;
        this.zDimension = generalEnvelope.getDimension() - 1;
        boolean bl = false;
        Object[] objectArray = null;
        for (Element element : elementArray) {
            Object[] objectArray2 = element.getSampleDimensions();
            if (objectArray2 == null) continue;
            if (objectArray == null) {
                objectArray = objectArray2;
                continue;
            }
            if (objectArray.length != objectArray2.length) {
                throw new IllegalArgumentException("Inconsistent number of sample dimensions.");
            }
            if (Arrays.equals(objectArray, objectArray2)) continue;
            bl = true;
        }
        this.numSampleDimensions = objectArray != null ? objectArray.length : 0;
        this.sampleDimensions = bl ? null : objectArray;
        this.zCRS = CRS.getSubCRS((CoordinateReferenceSystem)this.crs, (int)this.zDimension, (int)(this.zDimension + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoverageStack(CharSequence charSequence, CoverageStack coverageStack) {
        super(charSequence, coverageStack);
        CoverageStack coverageStack2 = coverageStack;
        synchronized (coverageStack2) {
            this.elements = coverageStack.elements;
            this.sampleDimensions = coverageStack.sampleDimensions;
            this.numSampleDimensions = coverageStack.numSampleDimensions;
            this.envelope = coverageStack.envelope;
            this.zDimension = coverageStack.zDimension;
            this.zCRS = coverageStack.zCRS;
            this.interpolationEnabled = coverageStack.interpolationEnabled;
        }
    }

    private static GeneralEnvelope getEnvelope(CoordinateReferenceSystem coordinateReferenceSystem, Element[] elementArray) throws IOException {
        Object object;
        GeneralEnvelope generalEnvelope;
        try {
            Arrays.sort(elementArray, COMPARATOR);
        }
        catch (BackingStoreException backingStoreException) {
            throw (IOException)backingStoreException.unwrapOrRethrow(IOException.class);
        }
        Envelope[] envelopeArray = null;
        int n = 0;
        int n2 = 77;
        if (coordinateReferenceSystem == null) {
            Object object2;
            int n3;
            n2 = 111;
            generalEnvelope = null;
            for (n3 = 0; n3 < elementArray.length; ++n3) {
                int n4;
                object = elementArray[n3].getEnvelope();
                if (object == null) continue;
                if (envelopeArray == null) {
                    envelopeArray = new Envelope[elementArray.length];
                }
                envelopeArray[n3] = object;
                object2 = object.getCoordinateReferenceSystem();
                if (object2 != null) {
                    if (generalEnvelope == null) {
                        generalEnvelope = new FrequencySortedSet(true);
                    }
                    generalEnvelope.add(object2);
                }
                if ((n4 = object.getDimension()) <= n) continue;
                n = n4 - 1;
            }
            if (generalEnvelope != null) {
                n3 = generalEnvelope.size();
                switch (n3) {
                    default: {
                        object = generalEnvelope.frequencies();
                        object2 = Loggings.format((Level)Level.WARNING, (int)28, (Object)n3, (Object)elementArray.length, (Object)((int)object[0]), (Object)((int)object[n3 - 1]));
                        ((LogRecord)object2).setSourceClassName(CoverageStack.class.getName());
                        ((LogRecord)object2).setSourceMethodName("<init>");
                        Logger logger = Logging.getLogger(CoverageStack.class);
                        ((LogRecord)object2).setLoggerName(logger.getName());
                        logger.log((LogRecord)object2);
                    }
                    case 1: {
                        coordinateReferenceSystem = (CoordinateReferenceSystem)generalEnvelope.first();
                    }
                    case 0: 
                }
            }
        }
        if (coordinateReferenceSystem != null) {
            n = coordinateReferenceSystem.getCoordinateSystem().getDimension() - 1;
        }
        if (n <= 0) {
            throw new IllegalArgumentException(Errors.format((int)238, (Object)(coordinateReferenceSystem == null ? "null" : coordinateReferenceSystem.getName().getCode())));
        }
        generalEnvelope = coordinateReferenceSystem != null ? new GeneralEnvelope(coordinateReferenceSystem) : new GeneralEnvelope(n + 1);
        generalEnvelope.setToNull();
        CoordinateReferenceSystem coordinateReferenceSystem2 = CRS.getSubCRS((CoordinateReferenceSystem)coordinateReferenceSystem, (int)0, (int)n);
        object = null;
        for (int i = 0; i < elementArray.length; ++i) {
            Envelope envelope;
            Element element = elementArray[i];
            Envelope envelope2 = envelope = envelopeArray != null ? envelopeArray[i] : element.getEnvelope();
            if (envelope == null) continue;
            CoordinateReferenceSystem coordinateReferenceSystem3 = envelope.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem3 != null && !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem3, (Object)coordinateReferenceSystem) && !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem3, (Object)coordinateReferenceSystem2)) {
                if (object == null || !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem3, (Object)object.getSourceCRS())) {
                    CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory((boolean)true);
                    try {
                        try {
                            object = coordinateOperationFactory.createOperation(coordinateReferenceSystem3, coordinateReferenceSystem);
                        }
                        catch (OperationNotFoundException operationNotFoundException) {
                            assert (!CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem2, (Object)coordinateReferenceSystem)) : coordinateReferenceSystem2;
                            object = coordinateOperationFactory.createOperation(coordinateReferenceSystem3, coordinateReferenceSystem2);
                        }
                    }
                    catch (FactoryException factoryException) {
                        throw new MismatchedReferenceSystemException(Errors.format((int)n2, (Object)((Object)factoryException)));
                    }
                }
                try {
                    envelope = CRS.transform((CoordinateOperation)object, (Envelope)envelope);
                }
                catch (TransformException transformException) {
                    throw new MismatchedReferenceSystemException(Errors.format((int)n2, (Object)((Object)transformException)));
                }
            }
            int n5 = envelope.getDimension();
            for (int j = 0; j <= n; ++j) {
                double d;
                double d2;
                double d3 = generalEnvelope.getMinimum(j);
                double d4 = generalEnvelope.getMaximum(j);
                if (j < n5) {
                    d2 = envelope.getMinimum(j);
                    d = envelope.getMaximum(j);
                } else if (j == n) {
                    NumberRange<?> numberRange = element.getZRange();
                    d2 = numberRange.getMinimum();
                    d = numberRange.getMaximum();
                } else {
                    d2 = Double.NEGATIVE_INFINITY;
                    d = Double.POSITIVE_INFINITY;
                }
                boolean bl = false;
                if (Double.isNaN(d3) || d2 < d3) {
                    d3 = d2;
                    bl = true;
                }
                if (Double.isNaN(d4) || d > d4) {
                    d4 = d;
                    bl = true;
                }
                if (!bl) continue;
                generalEnvelope.setRange(j, d3, d4);
            }
        }
        return generalEnvelope;
    }

    private static double zFromObject(Object object) throws IOException, ClassCastException {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return CoverageStack.getZ((Element)object);
    }

    private static double getZ(Element element) throws IOException {
        return CoverageStack.getZ(element.getZRange());
    }

    private static double getZ(NumberRange<?> numberRange) {
        if (numberRange != null) {
            Number number = (Number)((Object)numberRange.getMinValue());
            Number number2 = (Number)((Object)numberRange.getMaxValue());
            if (number != null) {
                if (number2 != null) {
                    return 0.5 * (number.doubleValue() + number2.doubleValue());
                }
                return number.doubleValue();
            }
            if (number2 != null) {
                return number2.doubleValue();
            }
        }
        return Double.NaN;
    }

    private static boolean contains(NumberRange<?> numberRange, double d) {
        return d >= numberRange.getMinimum() && d <= numberRange.getMaximum();
    }

    @Override
    public Envelope getEnvelope() {
        return this.envelope.clone();
    }

    public int getNumSampleDimensions() {
        if (this.numSampleDimensions != 0) {
            return this.numSampleDimensions;
        }
        throw new IllegalStateException("Sample dimensions are undetermined.");
    }

    public SampleDimension getSampleDimension(int n) {
        if (this.sampleDimensions != null) {
            return this.sampleDimensions[n];
        }
        throw new IllegalStateException("Sample dimensions are undetermined.");
    }

    public void snap(DirectPosition directPosition) throws IOException {
        Element element;
        GridGeometry gridGeometry;
        int n;
        double d = directPosition.getOrdinate(this.zDimension);
        try {
            n = Arrays.binarySearch(this.elements, d, COMPARATOR);
        }
        catch (BackingStoreException backingStoreException) {
            throw (IOException)backingStoreException.unwrapOrRethrow(IOException.class);
        }
        if (n < 0) {
            if ((n ^= 0xFFFFFFFF) == this.elements.length) {
                if (n == 0) {
                    return;
                }
                d = CoverageStack.getZ(this.elements[--n]);
            } else if (n == 0) {
                d = CoverageStack.getZ(this.elements[n]);
            } else {
                double d2 = CoverageStack.getZ(this.elements[n - 1]);
                double d3 = CoverageStack.getZ(this.elements[n]);
                assert (!(d <= d2) && !(d >= d3)) : d;
                if (Double.isNaN(d3) || d - d2 < d3 - d) {
                    --n;
                    d = d2;
                } else {
                    d = d3;
                }
            }
            directPosition.setOrdinate(this.zDimension, d);
        }
        if ((gridGeometry = (element = this.elements[n]).getGridGeometry()) != null) {
            GridEnvelope gridEnvelope = gridGeometry.getExtent();
            MathTransform mathTransform = gridGeometry.getGridToCRS();
            int n2 = mathTransform.getSourceDimensions();
            GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n2);
            int n3 = n2;
            while (--n3 >= 0) {
                generalDirectPosition.setOrdinate(n3, directPosition.getOrdinate(n3));
            }
            try {
                generalDirectPosition = mathTransform.inverse().transform((DirectPosition)generalDirectPosition, (DirectPosition)generalDirectPosition);
                n3 = n2;
                while (--n3 >= 0) {
                    generalDirectPosition.setOrdinate(n3, (double)Math.max(gridEnvelope.getLow(n3), Math.min(gridEnvelope.getHigh(n3), (int)Math.rint(generalDirectPosition.getOrdinate(n3)))));
                }
                generalDirectPosition = mathTransform.transform((DirectPosition)generalDirectPosition, (DirectPosition)generalDirectPosition);
                n3 = Math.min(n2, this.zDimension);
                while (--n3 >= 0) {
                    directPosition.setOrdinate(n3, generalDirectPosition.getOrdinate(n3));
                }
            }
            catch (TransformException transformException) {
                throw new CannotEvaluateException(CoverageStack.cannotEvaluate(directPosition), (Throwable)transformException);
            }
        }
    }

    private static String cannotEvaluate(DirectPosition directPosition) {
        return Errors.format((int)28, (Object)directPosition);
    }

    private Coverage load(Element element) throws IOException {
        GridCoverage2D gridCoverage2D;
        assert (Thread.holdsLock((Object)this));
        Coverage coverage = element.getCoverage(this.listeners);
        if (coverage instanceof GridCoverage2D) {
            gridCoverage2D = (GridCoverage2D)coverage;
            if (this.interpolationEnabled && gridCoverage2D.getInterpolation() instanceof InterpolationNearest) {
                coverage = Interpolator2D.create(gridCoverage2D);
            }
        }
        assert (InternalUtilities.debugEquals((Object)(gridCoverage2D = coverage.getCoordinateReferenceSystem()), (Object)CRS.getSubCRS((CoordinateReferenceSystem)this.crs, (int)0, (int)gridCoverage2D.getCoordinateSystem().getDimension()))) : gridCoverage2D;
        assert (coverage.getNumSampleDimensions() == this.numSampleDimensions) : coverage;
        return coverage;
    }

    private void load(int n) throws IOException {
        Element element = this.elements[n];
        NumberRange<?> numberRange = element.getZRange();
        this.logLoading(180, new String[]{element.getName()});
        this.lower = this.upper = this.load(element);
        this.lowerZ = this.upperZ = CoverageStack.getZ(numberRange);
        this.upperRange = numberRange;
        this.lowerRange = this.upperRange;
    }

    private void load(Element element, Element element2) throws IOException {
        this.logLoading(179, new String[]{element.getName(), element2.getName()});
        NumberRange<?> numberRange = element.getZRange();
        NumberRange<?> numberRange2 = element2.getZRange();
        Coverage coverage = this.load(element);
        Coverage coverage2 = this.load(element2);
        this.lower = coverage;
        this.upper = coverage2;
        this.lowerZ = CoverageStack.getZ(numberRange);
        this.upperZ = CoverageStack.getZ(numberRange2);
        this.lowerRange = numberRange;
        this.upperRange = numberRange2;
    }

    private boolean seek(double d) throws CannotEvaluateException {
        Double d2;
        block18: {
            int n;
            assert (Thread.holdsLock((Object)this));
            if (d >= this.lowerZ && d <= this.upperZ || Double.isNaN(d) && Double.isNaN(this.lowerZ) && Double.isNaN(this.upperZ)) {
                return true;
            }
            d2 = d;
            try {
                n = Arrays.binarySearch(this.elements, d2, COMPARATOR);
            }
            catch (BackingStoreException backingStoreException) {
                throw new CannotEvaluateException("Can't fetch coverage properties.", (Throwable)backingStoreException.unwrapOrRethrow(IOException.class));
            }
            try {
                double d3;
                if (n >= 0) {
                    this.load(n);
                    return true;
                }
                if ((n ^= 0xFFFFFFFF) == this.elements.length) {
                    if (--n >= 0 && this.elements[n].getZRange().contains((Number)d2)) {
                        this.load(n);
                        return true;
                    }
                    break block18;
                }
                if (n == 0) {
                    if (this.elements[n].getZRange().contains((Number)d2)) {
                        this.load(n);
                        return true;
                    }
                    break block18;
                }
                Element element = this.elements[n - 1];
                Element element2 = this.elements[n];
                NumberRange<?> numberRange = element.getZRange();
                NumberRange<?> numberRange2 = element2.getZRange();
                double d4 = numberRange.getMaximum();
                if (d4 + 0.0 >= (d3 = numberRange2.getMinimum())) {
                    if (this.interpolationEnabled) {
                        this.load(element, element2);
                    } else {
                        if (Math.abs(CoverageStack.getZ(numberRange2) - d) > Math.abs(d - CoverageStack.getZ(numberRange))) {
                            --n;
                        }
                        this.load(n);
                    }
                    return true;
                }
                if (numberRange.contains((Number)d2)) {
                    this.load(n - 1);
                    return true;
                }
                if (numberRange2.contains((Number)d2)) {
                    this.load(n);
                    return true;
                }
                return false;
            }
            catch (IOException iOException) {
                String string = iOException.getLocalizedMessage();
                if (string == null) {
                    string = Classes.getShortClassName((Object)iOException);
                }
                throw new CannotEvaluateException(string, (Throwable)iOException);
            }
        }
        Comparable<Double> comparable = this.zCRS instanceof TemporalCRS ? DefaultTemporalCRS.castOrCopy((TemporalCRS)((TemporalCRS)this.zCRS)).toDate(d) : d2;
        throw new OrdinateOutsideCoverageException(Errors.format((int)249, (Object)this.getName(), (Object)comparable), this.zDimension, this.getEnvelope());
    }

    private DirectPosition reduce(DirectPosition directPosition, Coverage coverage) {
        assert (Thread.holdsLock((Object)this));
        CoordinateReferenceSystem coordinateReferenceSystem = coverage.getCoordinateReferenceSystem();
        int n = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n == this.zDimension) {
            if (this.reducedPosition == null) {
                this.reducedPosition = new GeneralDirectPosition(this.zDimension);
            }
            for (int i = 0; i < n; ++i) {
                this.reducedPosition.ordinates[i] = directPosition.getOrdinate(i);
            }
            directPosition = this.reducedPosition;
        } else assert (InternalUtilities.debugEquals((Object)this.crs, (Object)coordinateReferenceSystem)) : coordinateReferenceSystem;
        return directPosition;
    }

    public Object evaluate(DirectPosition directPosition) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.evaluate(directPosition, (double[])null);
    }

    @Override
    public synchronized boolean[] evaluate(DirectPosition directPosition, boolean[] blArray) throws PointOutsideCoverageException, CannotEvaluateException {
        double d = directPosition.getOrdinate(this.zDimension);
        if (!this.seek(d)) {
            if (blArray == null) {
                blArray = new boolean[this.numSampleDimensions];
            } else {
                Arrays.fill(blArray, 0, this.numSampleDimensions, false);
            }
            return blArray;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(directPosition, this.lower), blArray);
        }
        assert (!(d < this.lowerZ) && !(d > this.upperZ)) : d;
        Coverage coverage = d >= 0.5 * (this.lowerZ + this.upperZ) ? this.upper : this.lower;
        return coverage.evaluate(this.reduce(directPosition, coverage), blArray);
    }

    @Override
    public synchronized byte[] evaluate(DirectPosition directPosition, byte[] byArray) throws PointOutsideCoverageException, CannotEvaluateException {
        double d = directPosition.getOrdinate(this.zDimension);
        if (!this.seek(d)) {
            if (byArray == null) {
                byArray = new byte[this.numSampleDimensions];
            } else {
                Arrays.fill(byArray, 0, this.numSampleDimensions, (byte)0);
            }
            return byArray;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(directPosition, this.lower), byArray);
        }
        this.byteBuffer = this.upper.evaluate(this.reduce(directPosition, this.upper), this.byteBuffer);
        byArray = this.lower.evaluate(this.reduce(directPosition, this.lower), byArray);
        assert (!(d < this.lowerZ) && !(d > this.upperZ)) : d;
        double d2 = (d - this.lowerZ) / (this.upperZ - this.lowerZ);
        for (int i = 0; i < this.byteBuffer.length; ++i) {
            byArray[i] = (byte)Math.round((double)byArray[i] + d2 * (double)(this.byteBuffer[i] - byArray[i]));
        }
        return byArray;
    }

    @Override
    public synchronized int[] evaluate(DirectPosition directPosition, int[] nArray) throws PointOutsideCoverageException, CannotEvaluateException {
        double d = directPosition.getOrdinate(this.zDimension);
        if (!this.seek(d)) {
            if (nArray == null) {
                nArray = new int[this.numSampleDimensions];
            } else {
                Arrays.fill(nArray, 0, this.numSampleDimensions, 0);
            }
            return nArray;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(directPosition, this.lower), nArray);
        }
        this.intBuffer = this.upper.evaluate(this.reduce(directPosition, this.upper), this.intBuffer);
        nArray = this.lower.evaluate(this.reduce(directPosition, this.lower), nArray);
        assert (!(d < this.lowerZ) && !(d > this.upperZ)) : d;
        double d2 = (d - this.lowerZ) / (this.upperZ - this.lowerZ);
        for (int i = 0; i < this.intBuffer.length; ++i) {
            nArray[i] = (int)Math.round((double)nArray[i] + d2 * (double)(this.intBuffer[i] - nArray[i]));
        }
        return nArray;
    }

    @Override
    public synchronized float[] evaluate(DirectPosition directPosition, float[] fArray) throws PointOutsideCoverageException, CannotEvaluateException {
        double d = directPosition.getOrdinate(this.zDimension);
        if (!this.seek(d)) {
            if (fArray == null) {
                fArray = new float[this.numSampleDimensions];
            }
            Arrays.fill(fArray, 0, this.numSampleDimensions, Float.NaN);
            return fArray;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(directPosition, this.lower), fArray);
        }
        this.floatBuffer = this.upper.evaluate(this.reduce(directPosition, this.upper), this.floatBuffer);
        fArray = this.lower.evaluate(this.reduce(directPosition, this.lower), fArray);
        assert (!(d < this.lowerZ) && !(d > this.upperZ)) : d;
        double d2 = (d - this.lowerZ) / (this.upperZ - this.lowerZ);
        for (int i = 0; i < this.floatBuffer.length; ++i) {
            float f = fArray[i];
            float f2 = this.floatBuffer[i];
            float f3 = (float)((double)f + d2 * (double)(f2 - f));
            if (Float.isNaN(f3)) {
                if (!Float.isNaN(f)) {
                    assert (Float.isNaN(f2)) : f2;
                    if (CoverageStack.contains(this.lowerRange, d)) {
                        f3 = f;
                    }
                } else if (!Float.isNaN(f2)) {
                    assert (Float.isNaN(f)) : f;
                    if (CoverageStack.contains(this.upperRange, d)) {
                        f3 = f2;
                    }
                }
            }
            fArray[i] = f3;
        }
        return fArray;
    }

    @Override
    public synchronized double[] evaluate(DirectPosition directPosition, double[] dArray) throws PointOutsideCoverageException, CannotEvaluateException {
        double d = directPosition.getOrdinate(this.zDimension);
        if (!this.seek(d)) {
            if (dArray == null) {
                dArray = new double[this.numSampleDimensions];
            }
            Arrays.fill(dArray, 0, this.numSampleDimensions, Double.NaN);
            return dArray;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(directPosition, this.lower), dArray);
        }
        this.doubleBuffer = this.upper.evaluate(this.reduce(directPosition, this.upper), this.doubleBuffer);
        dArray = this.lower.evaluate(this.reduce(directPosition, this.lower), dArray);
        assert (!(d < this.lowerZ) && !(d > this.upperZ)) : d;
        double d2 = (d - this.lowerZ) / (this.upperZ - this.lowerZ);
        for (int i = 0; i < this.doubleBuffer.length; ++i) {
            double d3 = dArray[i];
            double d4 = this.doubleBuffer[i];
            double d5 = d3 + d2 * (d4 - d3);
            if (Double.isNaN(d5)) {
                if (!Double.isNaN(d3)) {
                    assert (Double.isNaN(d4)) : d4;
                    if (CoverageStack.contains(this.lowerRange, d)) {
                        d5 = d3;
                    }
                } else if (!Double.isNaN(d4)) {
                    assert (Double.isNaN(d3)) : d3;
                    if (CoverageStack.contains(this.upperRange, d)) {
                        d5 = d4;
                    }
                }
            }
            dArray[i] = d5;
        }
        return dArray;
    }

    public synchronized List<Coverage> coveragesAt(double d) {
        if (!this.seek(d)) {
            return Collections.emptyList();
        }
        if (this.lower == this.upper) {
            return Collections.singletonList(this.lower);
        }
        return Arrays.asList(this.lower, this.upper);
    }

    public synchronized boolean isInterpolationEnabled() {
        return this.interpolationEnabled;
    }

    public synchronized void setInterpolationEnabled(boolean bl) {
        this.lower = null;
        this.upper = null;
        this.lowerZ = Double.POSITIVE_INFINITY;
        this.upperZ = Double.NEGATIVE_INFINITY;
        this.interpolationEnabled = bl;
    }

    public void addIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        this.listeners.addIIOReadWarningListener(iIOReadWarningListener);
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        this.listeners.removeIIOReadWarningListener(iIOReadWarningListener);
    }

    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.listeners.addIIOReadProgressListener(iIOReadProgressListener);
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.listeners.removeIIOReadProgressListener(iIOReadProgressListener);
    }

    protected void logLoading(LogRecord logRecord) {
        Logger logger = Logging.getLogger(CoverageStack.class);
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
    }

    private void logLoading(int n, Object[] objectArray) {
        Locale locale = null;
        LogRecord logRecord = Vocabulary.getResources(locale).getLogRecord(Level.INFO, n);
        logRecord.setSourceClassName(CoverageStack.class.getName());
        logRecord.setSourceMethodName("evaluate");
        logRecord.setParameters(objectArray);
        if (this.readListener == null) {
            this.readListener = new Listeners();
            this.addIIOReadProgressListener(this.readListener);
        }
        this.readListener.record = logRecord;
    }

    private final class Listeners
    extends IIOReadProgressAdapter {
        public LogRecord record;

        private Listeners() {
        }

        @Override
        public void imageStarted(ImageReader imageReader, int n) {
            if (this.record != null) {
                CoverageStack.this.logLoading(this.record);
                imageReader.removeIIOReadProgressListener(this);
                this.record = null;
            }
        }
    }

    public static class Adapter
    implements Element {
        protected Coverage coverage;
        protected NumberRange<?> range;

        public Adapter(Coverage coverage, NumberRange<?> numberRange) {
            this.coverage = coverage;
            this.range = numberRange;
            if (this.getClass() == Adapter.class && coverage == null) {
                throw new IllegalArgumentException(Errors.format((int)172, (Object)"coverage"));
            }
        }

        @Override
        public String getName() throws IOException {
            Coverage coverage = this.getCoverage(null);
            if (coverage instanceof AbstractCoverage) {
                coverage = ((AbstractCoverage)coverage).getName();
            }
            return coverage.toString();
        }

        @Override
        public NumberRange<?> getZRange() throws IOException {
            if (this.range == null) {
                Envelope envelope = this.getEnvelope();
                int n = envelope.getDimension() - 1;
                this.range = NumberRange.create((double)envelope.getMinimum(n), (double)envelope.getMaximum(n));
            }
            return this.range;
        }

        @Override
        public Envelope getEnvelope() throws IOException {
            return this.getCoverage(null).getEnvelope();
        }

        @Override
        public GridGeometry getGridGeometry() throws IOException {
            Coverage coverage = this.getCoverage(null);
            return coverage instanceof GridCoverage ? ((GridCoverage)coverage).getGridGeometry() : null;
        }

        @Override
        public SampleDimension[] getSampleDimensions() throws IOException {
            Coverage coverage = this.getCoverage(null);
            SampleDimension[] sampleDimensionArray = new SampleDimension[coverage.getNumSampleDimensions()];
            for (int i = 0; i < sampleDimensionArray.length; ++i) {
                sampleDimensionArray[i] = coverage.getSampleDimension(i);
            }
            return sampleDimensionArray;
        }

        @Override
        public Coverage getCoverage(IIOListeners iIOListeners) throws IOException {
            return this.coverage;
        }
    }

    public static interface Element {
        public String getName() throws IOException;

        public NumberRange<?> getZRange() throws IOException;

        public Envelope getEnvelope() throws IOException;

        public GridGeometry getGridGeometry() throws IOException;

        public SampleDimension[] getSampleDimensions() throws IOException;

        public Coverage getCoverage(IIOListeners var1) throws IOException;
    }
}

