/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.image.ColorModel;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.measure.unit.Unit;
import javax.media.jai.iterator.WritableRectIter;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.ColorModelFactory;
import org.geotoolkit.coverage.GeophysicsCategoryList;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.io.wkt.UnformattableObjectException;
import org.geotoolkit.referencing.operation.matrix.Matrix1;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.AbstractInternationalString;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@Immutable
class CategoryList
extends AbstractList<Category>
implements MathTransform1D,
Comparator<Category>,
Serializable {
    private static final long serialVersionUID = 2647846361059903365L;
    final CategoryList inverse;
    private volatile transient NumberRange<?> range;
    private final double[] minimums;
    private final Category[] categories;
    private final Category main;
    final Category nodata;
    private final Category overflowFallback;
    private transient Category last;
    private final boolean hasGaps;

    public CategoryList(Category[] categoryArray, Unit<?> unit) throws IllegalArgumentException {
        this(categoryArray, unit, false, null);
        assert (this.isGeophysics(false));
    }

    CategoryList(Category[] categoryArray, Unit<?> unit, boolean bl, CategoryList categoryList) throws IllegalArgumentException {
        Category category;
        int n;
        boolean bl2;
        boolean bl3 = bl2 = categoryList != null;
        assert (bl2 == this instanceof GeophysicsCategoryList) : bl2;
        if (categoryArray.length != 0) {
            categoryArray = (Category[])categoryArray.clone();
        }
        this.categories = categoryArray;
        for (n = 0; n < categoryArray.length; ++n) {
            categoryArray[n] = categoryArray[n].geophysics(bl2);
        }
        Arrays.sort(categoryArray, this);
        assert (this.isGeophysics(bl2));
        n = 0;
        this.minimums = new double[categoryArray.length];
        for (int i = 0; i < categoryArray.length; ++i) {
            double d = this.minimums[i] = categoryArray[i].minimum;
            if (i == 0) continue;
            assert (!(d < this.minimums[i - 1])) : d;
            Category category2 = categoryArray[i - 1];
            if (CategoryList.compare(d, category2.maximum) <= 0) {
                NumberRange<?> numberRange = categoryArray[i - 1].getRange();
                NumberRange<?> numberRange2 = categoryArray[i - 0].getRange();
                Comparable[] comparableArray = new Comparable[]{numberRange.getMinValue(), numberRange.getMaxValue(), numberRange2.getMinValue(), numberRange2.getMaxValue()};
                for (int j = 0; j < comparableArray.length; ++j) {
                    float f;
                    if (!(comparableArray[j] instanceof Number) || !Float.isNaN(f = ((Number)((Object)comparableArray[j])).floatValue())) continue;
                    String string = Integer.toHexString(Float.floatToRawIntBits(f));
                    comparableArray[j] = "NaN(" + string + ')';
                }
                throw new IllegalArgumentException(Errors.format((int)191, (Object)comparableArray));
            }
            if (Double.isNaN(d) || d == category2.getRange().getMaximum(false)) continue;
            n = 1;
        }
        this.hasGaps = n;
        assert (CategoryList.isSorted(categoryArray));
        Category category3 = Category.NODATA;
        long l = Double.doubleToRawLongBits(Double.NaN);
        int n2 = categoryArray.length;
        while (--n2 >= 0) {
            Category category4 = categoryArray[n2];
            double d = category4.geophysics((boolean)true).minimum;
            if (!Double.isNaN(d)) continue;
            category3 = category4;
            if (Double.doubleToRawLongBits(d) != l) continue;
            break;
        }
        this.nodata = category3;
        double d = 0.0;
        Category category5 = null;
        int n3 = categoryArray.length;
        while (--n3 >= 0) {
            Category category6 = categoryArray[n3];
            if (!category6.isQuantitative()) continue;
            category = category6.geophysics(false);
            double d2 = category.maximum - category.minimum;
            if (!(d2 >= d)) continue;
            d = d2;
            category5 = category6;
        }
        this.main = category5;
        this.last = category5 != null || categoryArray.length == 0 ? category5 : categoryArray[0];
        Category category7 = null;
        if (bl) {
            int n4 = categoryArray.length;
            while (--n4 >= 0) {
                category = categoryArray[n4];
                if (Double.isNaN(category.maximum)) continue;
                category7 = category;
                break;
            }
        }
        this.overflowFallback = category7;
        if (categoryList == null) {
            categoryList = new GeophysicsCategoryList(categoryArray, unit, this);
        }
        this.inverse = categoryList;
        assert (this instanceof GeophysicsCategoryList != categoryList instanceof GeophysicsCategoryList);
    }

    @Override
    public final int compare(Category category, Category category2) {
        return CategoryList.compare(category.minimum, category2.minimum);
    }

    private static int compare(double d, double d2) {
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            long l;
            long l2 = Double.doubleToRawLongBits(d);
            if (l2 < (l = Double.doubleToRawLongBits(d2))) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
        }
        return Double.compare(d, d2);
    }

    static boolean isSorted(Category[] categoryArray) {
        for (int i = 1; i < categoryArray.length; ++i) {
            Category category;
            if (!$assertionsDisabled) {
                Category category2;
                category = categoryArray[i - 0];
                if (category2.minimum > category.maximum) {
                    throw new AssertionError(category);
                }
            }
            if (!$assertionsDisabled) {
                Category category3;
                category = categoryArray[i - 1];
                if (category3.minimum > category.maximum) {
                    throw new AssertionError(category);
                }
            }
            if (CategoryList.compare(categoryArray[i - 1].maximum, categoryArray[i].minimum) <= 0) continue;
            return false;
        }
        return true;
    }

    static int binarySearch(double[] dArray, double d) {
        int n = 0;
        int n2 = dArray.length - 1;
        boolean bl = Double.isNaN(d);
        while (n <= n2) {
            boolean bl2;
            long l;
            int n3 = n + n2 >>> 1;
            double d2 = dArray[n3];
            if (d2 < d) {
                n = n3 + 1;
                continue;
            }
            if (d2 > d) {
                n2 = n3 - 1;
                continue;
            }
            long l2 = Double.doubleToRawLongBits(d2);
            if (l2 == (l = Double.doubleToRawLongBits(d))) {
                return n3;
            }
            boolean bl3 = Double.isNaN(d2);
            if (bl) {
                bl2 = !bl3 || l2 < l;
            } else {
                boolean bl4 = bl2 = !bl3 && l2 < l;
            }
            if (bl2) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return -(n + 1);
    }

    public CategoryList geophysics(boolean bl) {
        CategoryList categoryList;
        CategoryList categoryList2 = categoryList = bl ? this.inverse : this;
        assert (categoryList.isGeophysics(bl));
        return categoryList;
    }

    final boolean isGeophysics(boolean bl) {
        return CategoryList.isGeophysics(this.categories, bl);
    }

    static boolean isGeophysics(Category[] categoryArray, boolean bl) {
        for (Category category : categoryArray) {
            if (category.geophysics(bl) == category) continue;
            return false;
        }
        return true;
    }

    public Unit<?> getUnits() {
        return null;
    }

    public final boolean isRangeSigned() {
        return this.categories.length != 0 && this.categories[0].minimum < 0.0;
    }

    public final NumberRange<?> getRange() {
        Object object = this.range;
        if (object == null) {
            for (Category category : this.categories) {
                NumberRange<?> numberRange = category.getRange();
                if (Double.isNaN(numberRange.getMinimum()) || Double.isNaN(numberRange.getMaximum())) continue;
                object = object != null ? object.union(numberRange) : numberRange;
            }
            this.range = object;
        }
        return object;
    }

    private void formatRange(StringBuffer stringBuffer, Locale locale) {
        NumberRange<?> numberRange = this.getRange();
        stringBuffer.append('[');
        if (numberRange != null) {
            this.format(numberRange.getMinimum(), false, locale, stringBuffer).append(" \u2026 ");
            this.format(numberRange.getMaximum(), true, locale, stringBuffer);
        } else {
            Unit<?> unit = this.getUnits();
            if (unit != null) {
                stringBuffer.append(unit);
            }
        }
        stringBuffer.append(']');
    }

    StringBuffer format(double d, boolean bl, Locale locale, StringBuffer stringBuffer) {
        return stringBuffer.append(d);
    }

    public final ColorModel getColorModel(int n, int n2) {
        int n3 = 4;
        NumberRange<?> numberRange = this.getRange();
        Class clazz = numberRange.getElementType();
        if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class) {
            int n4 = ((Number)((Object)numberRange.getMinValue())).intValue();
            int n5 = ((Number)((Object)numberRange.getMaxValue())).intValue();
            n3 = n4 >= 0 ? (n5 < 256 ? 0 : (n5 < 65536 ? 1 : 3)) : (n4 >= Short.MIN_VALUE && n5 <= Short.MAX_VALUE ? 2 : 3);
        }
        return this.getColorModel(n, n2, n3);
    }

    public final ColorModel getColorModel(int n, int n2, int n3) {
        return ColorModelFactory.getColorModel(this.categories, n3, n, n2);
    }

    public final Category getCategory(double d) {
        int n = CategoryList.binarySearch(this.minimums, d);
        if (n >= 0) {
            assert (Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(this.minimums[n]));
            return this.categories[n];
        }
        if (Double.isNaN(d)) {
            return null;
        }
        assert (n == Arrays.binarySearch(this.minimums, d)) : n;
        if ((n = ~n - 1) >= 0) {
            Category category = this.categories[n];
            assert (d > category.minimum) : d;
            if (d <= category.maximum) {
                return category;
            }
            if (this.overflowFallback != null) {
                if (++n < this.categories.length) {
                    Category category2 = this.categories[n];
                    assert (!(category2.minimum <= d)) : d;
                    return category2.minimum - d < d - category.maximum ? category2 : category;
                }
                return this.overflowFallback;
            }
        } else if (this.overflowFallback != null && this.categories.length != 0) {
            Category category = this.categories[0];
            if (!Double.isNaN(category.minimum)) {
                return category;
            }
        }
        return null;
    }

    public final String format(double d, Locale locale) {
        if (Double.isNaN(d)) {
            Category category = this.last;
            if (!(d >= category.minimum && d <= category.maximum || Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(category.minimum))) {
                category = this.getCategory(d);
                if (category == null) {
                    return Vocabulary.getResources((Locale)locale).getString(311);
                }
                this.last = category;
            }
            return category.getName().toString(null);
        }
        return this.format(d, true, locale, new StringBuffer()).toString();
    }

    @Override
    public final int size() {
        return this.categories.length;
    }

    @Override
    public final Category get(int n) {
        return this.categories[n];
    }

    public final Category[] toArray() {
        Category[] categoryArray = this.categories;
        if (categoryArray.length != 0) {
            categoryArray = (Category[])categoryArray.clone();
        }
        return categoryArray;
    }

    @Override
    public final String toString() {
        return this.toString(this, null);
    }

    final String toString(Object object, InternationalString internationalString) {
        String string = System.getProperty("line.separator", "\n");
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(Classes.getShortClassName((Object)object)).append('(');
        if (internationalString != null && !(internationalString instanceof Name)) {
            stringBuffer.append('\"').append((CharSequence)internationalString).append("\":");
        }
        this.formatRange(stringBuffer, null);
        if (this.hasGaps) {
            stringBuffer.append(" with gaps");
        }
        stringBuffer.append(')').append(string);
        for (Category category : this.categories) {
            stringBuffer.append("  ").append(category == this.main ? (char)'\u2023' : ' ').append(' ').append(category).append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoryList) {
            CategoryList categoryList = (CategoryList)object;
            if (Arrays.equals(this.categories, categoryList.categories)) {
                assert (Arrays.equals(this.minimums, categoryList.minimums));
                return Utilities.equals((Object)this.overflowFallback, (Object)categoryList.overflowFallback);
            }
            return false;
        }
        return this.overflowFallback == null && super.equals(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.last = this.main != null || this.categories.length == 0 ? this.main : this.categories[0];
    }

    public final int getSourceDimensions() {
        return 1;
    }

    public final int getTargetDimensions() {
        return 1;
    }

    public boolean isIdentity() {
        return false;
    }

    public final MathTransform1D inverse() {
        return this.inverse;
    }

    private static void checkDimension(DirectPosition directPosition) {
        int n = directPosition.getDimension();
        if (n != 1) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)1, (Object)n));
        }
    }

    public final DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        CategoryList.checkDimension(directPosition);
        if (directPosition2 == null) {
            directPosition2 = new GeneralDirectPosition(1);
        } else {
            CategoryList.checkDimension(directPosition2);
        }
        directPosition2.setOrdinate(0, this.transform(directPosition.getOrdinate(0)));
        return directPosition2;
    }

    public final Matrix derivative(DirectPosition directPosition) throws TransformException {
        CategoryList.checkDimension(directPosition);
        return new Matrix1(this.derivative(directPosition.getOrdinate(0)));
    }

    public final double derivative(double d) throws TransformException {
        Category category = this.last;
        if (!(d >= category.minimum && d <= category.maximum || Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(category.minimum))) {
            category = this.getCategory(d);
            if (category == null) {
                throw new TransformException(Errors.format((int)151, (Object)d));
            }
            this.last = category;
        }
        return category.transform.derivative(d);
    }

    public final double transform(double d) throws TransformException {
        Category category = this.last;
        if (!(d >= category.minimum && d <= category.maximum || Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(category.minimum))) {
            category = this.getCategory(d);
            if (category == null) {
                throw new TransformException(Errors.format((int)151, (Object)d));
            }
            this.last = category;
        }
        d = category.transform.transform(d);
        if (this.overflowFallback != null) {
            if (d < category.inverse.minimum) {
                return category.inverse.minimum;
            }
            if (d > category.inverse.maximum) {
                return category.inverse.maximum;
            }
        }
        assert (category == this.inverse.getCategory((double)d).inverse) : category;
        return d;
    }

    private void transform(double[] dArray, float[] fArray, int n, double[] dArray2, float[] fArray2, int n2, int n3) throws TransformException {
        int n4;
        int n5 = n2 - n;
        Category category = this.last;
        double d = category.maximum;
        double d2 = category.minimum;
        long l = Double.doubleToRawLongBits(d2);
        if (n >= n2 || (fArray != null ? fArray != fArray2 : dArray != dArray2)) {
            n4 = 1;
        } else {
            n4 = -1;
            n2 += n3 - 1;
            n += n3 - 1;
        }
        int n6 = n;
        while (true) {
            double d3 = 0.0;
            while (--n3 >= 0) {
                double d4 = d3 = fArray != null ? (double)fArray[n6] : dArray[n6];
                if (!(d3 >= d2 && d3 <= d) && Double.doubleToRawLongBits(d3) != l) break;
                n6 += n4;
            }
            if (!(this.overflowFallback != null && (d3 > d && category == this.overflowFallback || d3 < d2 && category == this.categories[0]))) {
                int n7 = n6 - n;
                if (n7 < 0) {
                    n7 = -n7;
                    n -= n7 - 1;
                }
                int n8 = n + n5;
                MathTransform1D mathTransform1D = category.transform;
                if (fArray != null) {
                    if (fArray2 != null) {
                        mathTransform1D.transform(fArray, n, fArray2, n8, n7);
                    } else {
                        mathTransform1D.transform(fArray, n, dArray2, n8, n7);
                    }
                } else if (fArray2 != null) {
                    mathTransform1D.transform(dArray, n, fArray2, n8, n7);
                } else {
                    mathTransform1D.transform(dArray, n, dArray2, n8, n7);
                }
                if (this.overflowFallback != null) {
                    n2 = n + n5;
                    Category category2 = category.inverse;
                    if (fArray2 != null) {
                        float f = (float)category2.minimum;
                        float f2 = (float)category2.maximum;
                        while (--n7 >= 0) {
                            float f3 = fArray2[n2];
                            if (f3 < f) {
                                fArray2[n2] = f;
                            } else if (f3 > f2) {
                                fArray2[n2] = f2;
                            }
                            ++n2;
                        }
                    } else {
                        double d5 = category2.minimum;
                        double d6 = category2.maximum;
                        while (--n7 >= 0) {
                            double d7 = dArray2[n2];
                            if (d7 < d5) {
                                dArray2[n2] = d5;
                            } else if (d7 > d6) {
                                dArray2[n2] = d6;
                            }
                            ++n2;
                        }
                    }
                }
                if (n3 < 0) break;
                category = this.getCategory(d3);
                if (category == null) {
                    throw new TransformException(Errors.format((int)151, (Object)d3));
                }
                d = category.maximum;
                d2 = category.minimum;
                l = Double.doubleToRawLongBits(d2);
                n = n6;
            }
            n6 += n4;
        }
        this.last = category;
    }

    public final void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        this.transform(dArray, null, n, dArray2, null, n2, n3);
    }

    public final void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        this.transform(null, fArray, n, null, fArray2, n2, n3);
    }

    public final void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        this.transform(null, fArray, n, dArray, null, n2, n3);
    }

    public final void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        this.transform(dArray, null, n, null, fArray, n2, n3);
    }

    public final void transform(WritableRectIter writableRectIter) throws RasterFormatException {
        double d;
        double d2;
        Category category = null;
        Category category2 = null;
        int n = this.categories.length;
        while (--n >= 0) {
            if (Double.isNaN(this.categories[n].maximum)) continue;
            category2 = this.categories[n];
            category = this.categories[0];
            break;
        }
        Category category3 = this.main;
        if (this.main == null) {
            category3 = this.nodata;
        }
        double d3 = category3.maximum;
        double d4 = category3.minimum;
        long l = Double.doubleToRawLongBits(d4);
        MathTransform1D mathTransform1D = category3.transform;
        if (this.overflowFallback == null) {
            d2 = Double.POSITIVE_INFINITY;
            d = Double.NEGATIVE_INFINITY;
        } else {
            d2 = category3.inverse.maximum;
            d = category3.inverse.minimum;
        }
        try {
            writableRectIter.startLines();
            if (!writableRectIter.finishedLines()) {
                do {
                    writableRectIter.startPixels();
                    if (writableRectIter.finishedPixels()) continue;
                    do {
                        double d5;
                        if (!((d5 = writableRectIter.getSampleDouble()) >= d4 && d5 <= d3 || Double.doubleToRawLongBits(d5) == l)) {
                            category3 = this.getCategory(d5);
                            if (category3 == null) {
                                category3 = this.nodata;
                            }
                            d3 = category3 != category2 ? category3.maximum : Double.POSITIVE_INFINITY;
                            d4 = category3 != category ? category3.minimum : Double.NEGATIVE_INFINITY;
                            l = Double.doubleToRawLongBits(d4);
                            mathTransform1D = category3.transform;
                            if (this.overflowFallback != null) {
                                d2 = category3.inverse.maximum;
                                d = category3.inverse.minimum;
                            }
                        }
                        assert (this.hasGaps || category3 == this.nodata || (!Double.isNaN(d5) ? d5 >= d4 && d5 <= d3 : Double.doubleToRawLongBits(d5) == l)) : d5;
                        if ((d5 = mathTransform1D.transform(d5)) > d2) {
                            d5 = d2;
                        } else if (d5 < d) {
                            d5 = d;
                        }
                        writableRectIter.setSample(d5);
                    } while (!writableRectIter.nextPixelDone());
                } while (!writableRectIter.nextLineDone());
            }
        }
        catch (TransformException transformException) {
            RasterFormatException rasterFormatException = new RasterFormatException(Errors.format((int)16, (Object)Classes.getClass((Object)mathTransform1D)));
            rasterFormatException.initCause(transformException);
            throw rasterFormatException;
        }
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnformattableObjectException("Not yet implemented.", this.getClass());
    }

    final class Name
    extends AbstractInternationalString {
        Name() {
        }

        public String toString(Locale locale) {
            Locale locale2 = locale;
            if (locale == null) {
                locale2 = locale = Locale.getDefault();
            }
            StringBuffer stringBuffer = new StringBuffer(30);
            if (CategoryList.this.main != null) {
                stringBuffer.append(CategoryList.this.main.getName().toString(locale));
            } else {
                stringBuffer.append('(').append(Vocabulary.getResources((Locale)locale).getString(311)).append(')');
            }
            CategoryList.this.geophysics(true).formatRange(stringBuffer.append(' '), locale2);
            return stringBuffer.toString();
        }

        public String toString() {
            return this.toString(null);
        }
    }
}

