/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.GeophysicsCategory;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Numbers;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@Immutable
public class Category
implements Serializable {
    private static final long serialVersionUID = 6215962897884256696L;
    private static final NumberRange<Byte> BYTE_0;
    private static final NumberRange<Byte> BYTE_1;
    public static final Category NODATA;
    public static final Category FALSE;
    public static final Category TRUE;
    private final InternationalString name;
    final double minimum;
    final double maximum;
    volatile NumberRange<?> range;
    final MathTransform1D transform;
    final Category inverse;
    private final int[] ARGB;
    private static final int[] DEFAULT;
    private static final Color[] CYCLE;

    public Category(CharSequence charSequence, Color color, boolean bl) {
        this(charSequence, new int[]{color != null ? color.getRGB() : (bl ? -1 : -16777216)}, bl ? BYTE_0 : BYTE_1, (MathTransform1D)LinearTransform1D.IDENTITY);
    }

    public Category(CharSequence charSequence, Color color, int n) {
        this(charSequence, Category.toARGB(color, n), (Number)n);
        assert (this.minimum == (double)n) : this.minimum;
        assert (this.maximum == (double)n) : this.maximum;
    }

    public Category(CharSequence charSequence, Color color, double d) {
        this(charSequence, Category.toARGB(color, (int)Math.round(d)), (Number)d);
        assert (Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(d)) : this.minimum;
        assert (Double.doubleToRawLongBits(this.maximum) == Double.doubleToRawLongBits(d)) : this.maximum;
    }

    private Category(CharSequence charSequence, int[] nArray, Number number) {
        this(charSequence, nArray, new NumberRange(number.getClass(), number, number), null);
        assert (Double.isNaN(this.inverse.minimum)) : this.inverse.minimum;
        assert (Double.isNaN(this.inverse.maximum)) : this.inverse.maximum;
    }

    public Category(CharSequence charSequence, Color color, NumberRange<?> numberRange) throws IllegalArgumentException {
        this(charSequence, Category.toARGB(color, numberRange), numberRange, (MathTransform1D)null);
    }

    public Category(CharSequence charSequence, Color[] colorArray, int n, int n2, double d, double d2) throws IllegalArgumentException {
        this(charSequence, colorArray, NumberRange.create((int)n, (boolean)true, (int)n2, (boolean)false), d, d2);
    }

    public Category(CharSequence charSequence, Color[] colorArray, NumberRange<?> numberRange, double d, double d2) throws IllegalArgumentException {
        this(charSequence, colorArray, numberRange, Category.createLinearTransform(d, d2));
        try {
            assert (Double.doubleToLongBits(this.transform.derivative(0.0)) == Double.doubleToLongBits(d));
            assert (Double.doubleToLongBits(this.transform.transform(0.0)) == Double.doubleToLongBits(d2));
        }
        catch (TransformException transformException) {
            throw new AssertionError((Object)transformException);
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException(Errors.format((int)6, (Object)"scale", (Object)d));
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(Errors.format((int)6, (Object)"offset", (Object)d2));
        }
    }

    public Category(CharSequence charSequence, Color[] colorArray, NumberRange<?> numberRange, NumberRange<?> numberRange2) throws IllegalArgumentException {
        this(charSequence, colorArray, numberRange, Category.createLinearTransform(numberRange, numberRange2));
        this.inverse.range = numberRange2;
        assert (this.range.equals(numberRange));
    }

    public Category(CharSequence charSequence, Color[] colorArray, NumberRange<?> numberRange, MathTransform1D mathTransform1D) throws IllegalArgumentException {
        this(charSequence, colorArray == null && mathTransform1D == null ? Category.NODATA.ARGB : Category.toARGB(colorArray), numberRange, mathTransform1D);
    }

    private Category(CharSequence charSequence, int[] nArray, NumberRange<?> numberRange, MathTransform1D mathTransform1D) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)charSequence);
        ArgumentChecks.ensureNonNull((String)"range", numberRange);
        Class clazz = numberRange.getElementType();
        this.name = SimpleInternationalString.wrap((CharSequence)charSequence);
        this.ARGB = nArray;
        this.range = numberRange;
        boolean bl = numberRange.isMinIncluded();
        boolean bl2 = numberRange.isMaxIncluded();
        this.minimum = Category.doubleValue(clazz, (Number)((Object)numberRange.getMinValue()), bl ? 0 : 1);
        this.maximum = Category.doubleValue(clazz, (Number)((Object)numberRange.getMaxValue()), bl2 ? 0 : -1);
        if (mathTransform1D == null && bl && bl2 && Double.isNaN(this.minimum) && Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(this.maximum)) {
            this.inverse = this;
            this.transform = LinearTransform1D.create((double)0.0, (double)this.minimum);
            return;
        }
        if (!(this.minimum <= this.maximum) || Double.isInfinite(this.minimum) || Double.isInfinite(this.maximum)) {
            throw new IllegalArgumentException(Errors.format((int)14, (Object)numberRange.getMinValue(), (Object)numberRange.getMaxValue()));
        }
        TransformException transformException = null;
        try {
            if (mathTransform1D == null) {
                this.inverse = new GeophysicsCategory(this, false);
                this.transform = LinearTransform1D.create((double)0.0, (double)this.inverse.minimum);
                return;
            }
            this.transform = mathTransform1D;
            this.inverse = mathTransform1D.isIdentity() ? this : new GeophysicsCategory(this, true);
            if (this.inverse.minimum <= this.inverse.maximum) {
                return;
            }
        }
        catch (TransformException transformException2) {
            transformException = transformException2;
        }
        throw new IllegalArgumentException(Errors.format((int)16, mathTransform1D.getClass()), transformException);
    }

    Category(Category category, boolean bl) throws TransformException {
        double d;
        assert (this instanceof GeophysicsCategory);
        assert (!(category instanceof GeophysicsCategory));
        this.inverse = category;
        this.name = category.name;
        this.ARGB = category.ARGB;
        if (!bl) {
            this.minimum = this.maximum = (double)XMath.toNaN((int)((int)Math.round((category.minimum + category.maximum) / 2.0) % 0x200000));
            this.transform = LinearTransform1D.create((double)0.0, (double)category.minimum);
            return;
        }
        this.transform = category.transform.inverse();
        double d2 = category.transform.transform(category.minimum);
        if (d2 > (d = category.transform.transform(category.maximum))) {
            this.minimum = d;
            this.maximum = d2;
        } else {
            this.minimum = d2;
            this.maximum = d;
        }
    }

    static MathTransform1D createLinearTransform(double d, double d2) throws IllegalArgumentException {
        if (d == 0.0 || Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"scale", (Object)d));
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"offset", (Object)d2));
        }
        return LinearTransform1D.create((double)d, (double)d2);
    }

    private static MathTransform1D createLinearTransform(NumberRange<?> numberRange, NumberRange<?> numberRange2) {
        double d;
        int n;
        boolean bl;
        int n2;
        Class clazz = numberRange.getElementType();
        Class clazz2 = numberRange2.getElementType();
        int n3 = numberRange.isMinIncluded() ? 0 : 1;
        int n4 = numberRange.isMaxIncluded() ? 0 : -1;
        int n5 = numberRange2.isMinIncluded() ? 0 : 1;
        int n6 = n2 = numberRange2.isMaxIncluded() ? 0 : -1;
        if (n3 == n5) {
            n5 = 0;
            n3 = 0;
        }
        if (n4 == n2) {
            n2 = 0;
            n4 = 0;
        }
        if (((bl = Numbers.isInteger((Class)clazz) && !Numbers.isInteger((Class)clazz2)) ? n5 : n3) != 0) {
            n = n3;
            n3 = -n5;
            n5 = -n;
        }
        if ((bl ? n2 : n4) != 0) {
            n = n4;
            n4 = -n2;
            n2 = -n;
        }
        double d2 = Category.doubleValue(clazz, (Number)((Object)numberRange.getMinValue()), n3);
        double d3 = Category.doubleValue(clazz, (Number)((Object)numberRange.getMaxValue()), n4);
        double d4 = Category.doubleValue(clazz2, (Number)((Object)numberRange2.getMinValue()), n5);
        double d5 = Category.doubleValue(clazz2, (Number)((Object)numberRange2.getMaxValue()), n2);
        double d6 = d5 - d4;
        double d7 = d6 / (d = d3 - d2);
        if (Double.isNaN(d7) && !Double.isNaN(d6) && !Double.isNaN(d)) {
            d7 = 1.0;
        }
        double d8 = d4 - d7 * d2;
        return Category.createLinearTransform(d7, d8);
    }

    private static double doubleValue(Class<? extends Number> clazz, Number number, int n) {
        assert (n >= -1 && n <= 1) : n;
        return XMath.adjacentForType(clazz, (double)number.doubleValue(), (int)n);
    }

    private static int[] toARGB(Color[] colorArray) {
        int[] nArray;
        if (colorArray != null && colorArray.length != 0) {
            nArray = new int[colorArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                Color color = colorArray[i];
                if (color == null) continue;
                nArray[i] = color.getRGB();
            }
        } else {
            nArray = DEFAULT;
        }
        return nArray;
    }

    private static int[] toARGB(Color color, int n) {
        if (color == null) {
            color = CYCLE[Math.abs(n) % CYCLE.length];
        }
        return new int[]{color.getRGB()};
    }

    private static int[] toARGB(Color color, NumberRange<?> numberRange) {
        int n = 0;
        if (color == null && numberRange != null && (long)(n = (int)Math.round(numberRange.getMinimum(true))) != Math.round(numberRange.getMaximum(true))) {
            return DEFAULT;
        }
        return Category.toARGB(color, n);
    }

    public InternationalString getName() {
        return this.name;
    }

    public Color[] getColors() {
        Color[] colorArray = new Color[this.ARGB.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = new Color(this.ARGB[i], true);
        }
        return colorArray;
    }

    public NumberRange<?> getRange() {
        NumberRange<?> numberRange = this.range;
        assert (numberRange != null);
        return numberRange;
    }

    public MathTransform1D getSampleToGeophysics() {
        return this.isQuantitative() ? this.transform : null;
    }

    public boolean isQuantitative() {
        return !Double.isNaN(this.inverse.minimum) && !Double.isNaN(this.inverse.maximum);
    }

    public Category recolor(Color[] colorArray) {
        assert (!(this instanceof GeophysicsCategory)) : this;
        int[] nArray = Category.toARGB(colorArray);
        if (Arrays.equals(this.ARGB, nArray)) {
            return this;
        }
        NumberRange<?> numberRange = this.range;
        assert (numberRange != null) : this;
        Category category = new Category((CharSequence)this.name, nArray, numberRange, this.getSampleToGeophysics());
        category.inverse.range = this.inverse.range;
        return category;
    }

    public Category rescale(MathTransform1D mathTransform1D) {
        if (Utilities.equals((Object)mathTransform1D, (Object)this.transform)) {
            return this;
        }
        return new Category((CharSequence)this.name, this.ARGB, this.range, mathTransform1D);
    }

    public Category geophysics(boolean bl) {
        return bl ? this.inverse : this;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            Category category = (Category)object;
            if (Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(category.minimum) && Double.doubleToRawLongBits(this.maximum) == Double.doubleToRawLongBits(category.maximum) && Utilities.equals((Object)this.transform, (Object)category.transform) && Utilities.equals((Object)this.name, (Object)category.name) && Arrays.equals(this.ARGB, category.ARGB)) {
                NumberRange<?> numberRange = this.range;
                NumberRange<?> numberRange2 = category.range;
                if (numberRange != null && numberRange2 != null) {
                    if (!Utilities.equals(numberRange, numberRange2)) {
                        return false;
                    }
                    if (this.inverse instanceof GeophysicsCategory) assert (this.inverse.equals(category.inverse));
                    return true;
                }
                assert (this instanceof GeophysicsCategory);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("(\u201c").append((CharSequence)this.name).append("\u201d:[");
        if (Double.isNaN(this.minimum) && Double.isNaN(this.maximum)) {
            stringBuilder.append("NaN(").append(Math.round(this.inverse.minimum)).append('\u2026').append(Math.round(this.inverse.maximum)).append(')');
        } else if (Numbers.isInteger((Class)this.getRange().getElementType())) {
            stringBuilder.append(Math.round(this.minimum)).append('\u2026').append(Math.round(this.maximum));
        } else {
            stringBuilder.append(this.minimum).append(" \u2026 ").append(this.maximum);
        }
        return stringBuilder.append("])").toString();
    }

    static {
        Byte by = 0;
        BYTE_0 = NumberRange.create((byte)by, (byte)by);
        by = 1;
        BYTE_1 = NumberRange.create((byte)by, (byte)by);
        NODATA = new Category((CharSequence)Vocabulary.formatInternational((int)202), new Color(0, 0, 0, 0), 0);
        FALSE = new Category((CharSequence)Vocabulary.formatInternational((int)106), Color.BLACK, false);
        TRUE = new Category((CharSequence)Vocabulary.formatInternational((int)304), Color.WHITE, true);
        DEFAULT = new int[]{-16777216, -1};
        CYCLE = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.YELLOW, Color.PINK, Color.MAGENTA, Color.GREEN, Color.CYAN, Color.LIGHT_GRAY, Color.GRAY};
    }
}

