/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGBatikMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    StreamingRenderer renderer;
    WMS wms;

    public SVGBatikMapProducer(WMS wms) {
        this.wms = wms;
    }

    public void abort() {
        if (this.renderer != null) {
            this.renderer.stopRendering();
        }
    }

    public void abort(Service gs) {
        if (this.renderer != null) {
            this.renderer.stopRendering();
        }
    }

    public String getContentType() {
        return "image/svg+xml";
    }

    public String getContentEncoding() {
        return null;
    }

    public void produceMap() throws WmsException {
        this.renderer = new StreamingRenderer();
        HashMap<String, Comparable<Boolean>> rendererParams = new HashMap<String, Comparable<Boolean>>();
        rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
        rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
        this.renderer.setRendererHints(rendererParams);
        this.renderer.setContext((MapContext)this.mapContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            MapContext map = this.renderer.getContext();
            double width = -1.0;
            double height = -1.0;
            if (map instanceof WMSMapContext) {
                WMSMapContext wmsMap = (WMSMapContext)map;
                width = wmsMap.getMapWidth();
                height = wmsMap.getMapHeight();
            } else {
                ReferencedEnvelope area = map.getAreaOfInterest();
                if (area.getHeight() > 0.0 && area.getWidth() > 0.0) {
                    if (area.getHeight() >= area.getWidth()) {
                        height = 600.0;
                        width = height * (area.getWidth() / area.getHeight());
                    } else {
                        width = 800.0;
                        height = width * (area.getHeight() / area.getWidth());
                    }
                }
            }
            if (height == -1.0 || width == -1.0) {
                throw new IOException("Could not determine map dimensions");
            }
            SVGGeneratorContext context = this.setupContext();
            SVGGraphics2D g = new SVGGraphics2D(context, true);
            g.setSVGCanvasSize(new Dimension((int)width, (int)height));
            if (this.wms.isSvgAntiAlias()) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Rectangle r = new Rectangle(g.getSVGCanvasSize());
            ReferencedEnvelope e = this.renderer.getContext().getAreaOfInterest();
            AffineTransform at = RendererUtilities.worldToScreenTransform((Envelope)e, (Rectangle)r);
            this.renderer.paint((Graphics2D)g, r, at);
            OutputFormat format = new OutputFormat();
            XMLSerializer serializer = new XMLSerializer((Writer)new OutputStreamWriter(out, "UTF-8"), format);
            Element root = g.getDOMTreeManager().getRoot();
            root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            root.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        }
        catch (Exception e) {
            new IOException().initCause(e);
        }
        finally {
            this.renderer = null;
        }
    }

    private SVGGeneratorContext setupContext() throws FactoryConfigurationError, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        String svgNamespaceURI = "http://www.w3.org/2000/svg";
        document = db.getDOMImplementation().createDocument(svgNamespaceURI, "svg", null);
        return SVGGeneratorContext.createDefault((Document)document);
    }

    public String getContentDisposition() {
        return null;
    }
}

