/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.opengis.filter.Filter;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.svg.AbortedException;
import org.vfny.geoserver.wms.responses.map.svg.SVGWriter;

public class EncodeSVG {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private static final String DOCTYPE = "<!DOCTYPE svg \n\tPUBLIC \"-//W3C//DTD SVG 20001102//EN\" \n\t\"http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd\">\n";
    private static final String SVG_HEADER = "<?xml version=\"1.0\" standalone=\"no\"?>\n\t<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" \n\tstroke=\"green\" \n\tfill=\"none\" \n\tstroke-width=\"0.1%\"\n\tstroke-linecap=\"round\"\n\tstroke-linejoin=\"round\"\n\twidth=\"_width_\" \n\theight=\"_height_\" \n\tviewBox=\"_viewBox_\" \n\tpreserveAspectRatio=\"xMidYMid meet\">\n";
    private static final String SVG_FOOTER = "</svg>\n";
    private WMSMapContext mapContext;
    private SVGWriter writer;
    private boolean abortProcess;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPoint;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Point;

    public EncodeSVG(WMSMapContext mapContext) {
        this.mapContext = mapContext;
    }

    public void abort() {
        this.abortProcess = true;
    }

    public void encode(OutputStream out) throws IOException {
        ReferencedEnvelope env = this.mapContext.getAreaOfInterest();
        this.writer = new SVGWriter(out, this.mapContext);
        this.writer.setMinCoordDistance(env.getWidth() / 1000.0);
        this.abortProcess = false;
        long t = System.currentTimeMillis();
        try {
            this.writeHeader();
            this.writeLayers();
            this.writer.write(SVG_FOOTER);
            this.writer.flush();
            t = System.currentTimeMillis() - t;
            LOGGER.info("SVG generated in " + t + " ms");
        }
        catch (IOException ioe) {
            if (this.abortProcess) {
                LOGGER.fine("SVG encoding aborted");
                return;
            }
            throw ioe;
        }
        catch (AbortedException ex) {
            return;
        }
    }

    public String createViewBox() {
        ReferencedEnvelope referenceSpace = this.mapContext.getAreaOfInterest();
        String viewBox = this.writer.getX(referenceSpace.getMinX()) + " " + (this.writer.getY(referenceSpace.getMinY()) - referenceSpace.getHeight()) + " " + referenceSpace.getWidth() + " " + referenceSpace.getHeight();
        return viewBox;
    }

    private void writeHeader() throws IOException {
        String viewBox = this.createViewBox();
        String header = SVG_HEADER.replaceAll("_viewBox_", viewBox);
        header = header.replaceAll("_width_", String.valueOf(this.mapContext.getMapWidth()));
        header = header.replaceAll("_height_", String.valueOf(this.mapContext.getMapHeight()));
        this.writer.write(header);
    }

    private void writeDefs(FeatureType layer) throws IOException {
        GeometryAttributeType gtype = layer.getDefaultGeometry();
        Class geometryClass = gtype.getType();
        if (geometryClass == (class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = EncodeSVG.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint) || geometryClass == (class$com$vividsolutions$jts$geom$Point == null ? (class$com$vividsolutions$jts$geom$Point = EncodeSVG.class$("com.vividsolutions.jts.geom.Point")) : class$com$vividsolutions$jts$geom$Point)) {
            this.writePointDefs();
        }
    }

    private void writePointDefs() throws IOException {
        this.writer.write("<defs>\n\t<circle id='point' cx='0' cy='0' r='0.25%' fill='blue'/>\n</defs>\n");
    }

    private void writeLayers() throws IOException, AbortedException {
        MapLayer[] layers = this.mapContext.getLayers();
        int nLayers = layers.length;
        int defMaxDecimals = this.writer.getMaximunFractionDigits();
        FilterFactory fFac = FilterFactoryFinder.createFilterFactory();
        for (int i = 0; i < nLayers; ++i) {
            MapLayer layer = layers[i];
            FeatureIterator featureReader = null;
            FeatureSource fSource = layer.getFeatureSource();
            FeatureType schema = fSource.getSchema();
            try {
                BBoxExpression bboxExpression = fFac.createBBoxExpression((Envelope)this.mapContext.getAreaOfInterest());
                GeometryFilter bboxFilter = fFac.createGeometryFilter((short)7);
                bboxFilter.addLeftGeometry((Expression)fFac.createAttributeExpression(schema, schema.getDefaultGeometry().getName()));
                bboxFilter.addRightGeometry((Expression)bboxExpression);
                DefaultQuery bboxQuery = new DefaultQuery(schema.getTypeName(), (Filter)bboxFilter);
                LOGGER.fine("obtaining FeatureReader for " + schema.getTypeName());
                featureReader = fSource.getFeatures((Query)bboxQuery).features();
                LOGGER.fine("got FeatureReader, now writing");
                String groupId = null;
                String styleName = null;
                groupId = schema.getTypeName();
                styleName = layer.getStyle().getName();
                this.writer.write("<g id=\"" + groupId + "\"");
                if (!styleName.startsWith("#")) {
                    this.writer.write(" class=\"" + styleName + "\"");
                }
                this.writer.write(">\n");
                this.writeDefs(schema);
                this.writer.writeFeatures(fSource.getSchema(), featureReader, styleName);
                this.writer.write("</g>\n");
                continue;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (AbortedException ae) {
                LOGGER.info("process aborted: " + ae.getMessage());
                throw ae;
            }
            catch (Throwable t) {
                LOGGER.warning("UNCAUGHT exception: " + t.getMessage());
                IOException ioe = new IOException("UNCAUGHT exception: " + t.getMessage());
                ioe.setStackTrace(t.getStackTrace());
                throw ioe;
            }
            finally {
                if (featureReader != null) {
                    featureReader.close();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

