/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.png;

import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.image.ImageWorker;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public class PNGMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.wms.responses.map.png");
    protected Boolean PNGNativeAcc;

    public PNGMapProducer(String format, String mime_type, WMS wms) {
        super(format, mime_type, wms);
        this.PNGNativeAcc = wms.getGeoServer().getPNGNativeAcceleration();
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws WmsException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ...");
        }
        if (this.format.equalsIgnoreCase("image/png8") || this.mapContext.getPaletteInverter() != null) {
            image = this.forceIndexed8Bitmask(image);
        }
        new ImageWorker(image).writePNG((Object)outStream, "FILTERED", 0.1f, this.PNGNativeAcc.booleanValue(), image.getColorModel() instanceof IndexColorModel);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ... done!");
        }
    }

    public String getContentDisposition() {
        return null;
    }
}

