/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMLLegendTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLRasterTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLSuperOverlayTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLVectorTransformer;
import org.xml.sax.ContentHandler;

public class KMLTransformer
extends TransformerBase {
    static Logger LOGGER = Logger.getLogger("org.geoserver.kml");
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    boolean kmz = false;

    public KMLTransformer() {
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLTranslator(handler);
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public void setKmz(boolean kmz) {
        this.kmz = kmz;
    }

    class KMLTranslator
    extends TransformerBase.TranslatorSupport {
        public KMLTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            int i;
            boolean group;
            this.start("kml");
            WMSMapContext mapContext = (WMSMapContext)((Object)o);
            GetMapRequest request = mapContext.getRequest();
            MapLayer[] layers = mapContext.getLayers();
            boolean bl = group = layers.length > 1 || request.getLegend();
            if (group) {
                StringBuffer sb = new StringBuffer();
                for (int i2 = 0; i2 < layers.length; ++i2) {
                    sb.append(layers[i2].getTitle() + ",");
                }
                sb.setLength(sb.length() - 1);
                this.start("Document");
                this.element("name", sb.toString());
            }
            for (i = 0; i < layers.length; ++i) {
                MapLayer layer = layers[i];
                MapLayerInfo layerInfo = mapContext.getRequest().getLayers()[i];
                if (mapContext.getRequest().getSuperOverlay()) {
                    this.encodeSuperOverlayLayer(mapContext, layer);
                    continue;
                }
                if (layerInfo.getType() == MapLayerInfo.TYPE_VECTOR) {
                    this.encodeVectorLayer(mapContext, layer);
                    continue;
                }
                this.encodeRasterLayer(mapContext, layer);
            }
            if (request.getLegend()) {
                for (i = 0; i < layers.length; ++i) {
                    MapLayer layer = layers[i];
                    this.encodeLegend(mapContext, layer);
                }
            }
            if (group) {
                this.end("Document");
            }
            this.end("kml");
        }

        protected void encodeVectorLayer(WMSMapContext mapContext, MapLayer layer) {
            FeatureSource featureSource = layer.getFeatureSource();
            FeatureCollection features = null;
            try {
                features = this.loadFeatureCollection(featureSource, layer, mapContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            double scaleDenominator = 1.0;
            try {
                scaleDenominator = RendererUtilities.calculateScale((ReferencedEnvelope)mapContext.getAreaOfInterest(), (int)800, (int)600, null);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error calculating scale denominator", e);
            }
            LOGGER.fine("scale denominator = " + scaleDenominator);
            if (KMLTransformer.this.kmz) {
                int kmscore = mapContext.getRequest().getKMScore();
                boolean useVector = this.useVectorOutput(kmscore, features.size());
                if (useVector) {
                    KMLVectorTransformer tx = new KMLVectorTransformer(mapContext, layer);
                    this.initTransformer(tx);
                    tx.setScaleDenominator(scaleDenominator);
                    tx.createTranslator(this.contentHandler).encode((Object)features);
                } else {
                    KMLRasterTransformer tx = new KMLRasterTransformer(mapContext);
                    this.initTransformer(tx);
                    tx.setInline(true);
                    tx.createTranslator(this.contentHandler).encode((Object)layer);
                }
            } else {
                KMLVectorTransformer tx = new KMLVectorTransformer(mapContext, layer);
                this.initTransformer(tx);
                tx.setScaleDenominator(scaleDenominator);
                tx.createTranslator(this.contentHandler).encode((Object)features);
            }
        }

        protected void encodeRasterLayer(WMSMapContext mapContext, MapLayer layer) {
            KMLRasterTransformer tx = new KMLRasterTransformer(mapContext);
            this.initTransformer(tx);
            tx.setInline(KMLTransformer.this.kmz);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void encodeSuperOverlayLayer(WMSMapContext mapContext, MapLayer layer) {
            KMLSuperOverlayTransformer tx = new KMLSuperOverlayTransformer(mapContext);
            this.initTransformer(tx);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void encodeLegend(WMSMapContext mapContext, MapLayer layer) {
            KMLLegendTransformer tx = new KMLLegendTransformer(mapContext);
            this.initTransformer(tx);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void initTransformer(KMLTransformerBase delegate) {
            delegate.setIndentation(KMLTransformer.this.getIndentation());
            delegate.setStandAlone(false);
        }

        double computeScaleDenominator(MapLayer layer, WMSMapContext mapContext) {
            Rectangle paintArea = new Rectangle(mapContext.getMapWidth(), mapContext.getMapHeight());
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapContext.getAreaOfInterest(), (Rectangle)paintArea);
            try {
                return RendererUtilities.calculateScale((Envelope)mapContext.getAreaOfInterest(), (CoordinateReferenceSystem)mapContext.getCoordinateReferenceSystem(), (int)paintArea.width, (int)paintArea.height, (double)90.0);
            }
            catch (Exception e) {
                return 1.0 / worldToScreen.getScaleX();
            }
        }

        boolean useVectorOutput(int kmscore, int numFeatures) {
            if (kmscore == 100) {
                return true;
            }
            if (kmscore == 0) {
                return false;
            }
            double magic = Math.pow(10.0, kmscore / 15);
            return !((double)numFeatures > magic);
        }

        FeatureCollection loadFeatureCollection(FeatureSource featureSource, MapLayer layer, WMSMapContext mapContext) throws Exception {
            boolean reproject;
            FeatureType schema = featureSource.getSchema();
            ReferencedEnvelope envelope = mapContext.getAreaOfInterest();
            ReferencedEnvelope aoi = new ReferencedEnvelope((Envelope)envelope, mapContext.getCoordinateReferenceSystem());
            CoordinateReferenceSystem sourceCrs = schema.getDefaultGeometry().getCoordinateSystem();
            boolean bl = reproject = sourceCrs != null && !CRS.equalsIgnoreMetadata((Object)aoi.getCoordinateReferenceSystem(), (Object)sourceCrs);
            if (reproject) {
                aoi = aoi.transform(sourceCrs, true);
            }
            Filter filter = this.createBBoxFilter(schema, (Envelope)aoi);
            DefaultQuery q = new DefaultQuery(schema.getTypeName());
            q.setFilter(filter);
            Query definitionQuery = layer.getQuery();
            if (definitionQuery != Query.ALL) {
                q = q == Query.ALL ? (DefaultQuery)definitionQuery : (DefaultQuery)DataUtilities.mixQueries((Query)definitionQuery, (Query)q, (String)"KMLEncoder");
            }
            q.setCoordinateSystem(mapContext.getCoordinateReferenceSystem());
            if (reproject) {
                return new ReprojectFeatureResults(featureSource.getFeatures((Query)q), mapContext.getCoordinateReferenceSystem());
            }
            return featureSource.getFeatures((Query)q);
        }

        Filter createBBoxFilter(FeatureType schema, Envelope bbox) throws IllegalFilterException {
            ArrayList<BBOX> filters = new ArrayList<BBOX>();
            for (int j = 0; j < schema.getAttributeCount(); ++j) {
                AttributeType attType = schema.getAttributeType(j);
                if (!(attType instanceof GeometryAttributeType)) continue;
                BBOX gfilter = KMLTransformer.this.filterFactory.bbox(attType.getLocalName(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), null);
                filters.add(gfilter);
            }
            if (filters.size() == 0) {
                return Filter.INCLUDE;
            }
            if (filters.size() == 1) {
                return (Filter)filters.get(0);
            }
            return KMLTransformer.this.filterFactory.or(filters);
        }
    }
}

