/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.geotiff;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.geotiff.GeoTiffMapProducer;

public class GeoTiffMapProducerFactory
implements GetMapProducerFactorySpi {
    static final String MIME_TYPE = "image/tiff";
    private static final Set SUPPORTED_FORMATS = new HashSet(2);

    public String getName() {
        return "Geographic tagged image format";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        try {
            Class.forName("com.sun.media.imageio.plugins.tiff.GeoTIFFTagSet");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canProduce(String mapFormat) {
        return SUPPORTED_FORMATS.contains(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (!this.canProduce(mapFormat)) {
            throw new IllegalArgumentException(mapFormat + " not supported by this map producer");
        }
        return new GeoTiffMapProducer(mapFormat, MIME_TYPE, wms);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    static {
        SUPPORTED_FORMATS.add("image/geotiff");
        SUPPORTED_FORMATS.add("image/geotiff8");
    }
}

