/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class AtomGeoRSSTransformer
extends GeoRSSTransformerBase {
    public Translator createTranslator(ContentHandler handler) {
        return new AtomGeoRSSTranslator(handler);
    }

    public class AtomGeoRSSTranslator
    extends GeoRSSTransformerBase.GeoRSSTranslatorSupport {
        public AtomGeoRSSTranslator(ContentHandler contentHandler) {
            super(AtomGeoRSSTransformer.this, contentHandler, null, "http://www.w3.org/2005/Atom");
            this.nsSupport.declarePrefix("georss", "http://www.georss.org/georss");
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContext map = (WMSMapContext)((Object)o);
            this.start("feed");
            this.element("title", map.getTitle());
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, "http://localhost...");
            this.element("link", null, atts);
            this.element("updated", new Date().toString());
            try {
                this.encodeEntries(map);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end("feed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void encodeEntries(WMSMapContext map) throws IOException {
            List featureCollections = this.loadFeatureCollections(map);
            Iterator f = featureCollections.iterator();
            while (f.hasNext()) {
                FeatureCollection features = (FeatureCollection)f.next();
                FeatureIterator iterator = null;
                try {
                    iterator = features.features();
                    while (iterator.hasNext()) {
                        Feature feature = iterator.next();
                        try {
                            this.encodeEntry(feature);
                        }
                        catch (Exception e) {
                            GeoRSSTransformerBase.LOGGER.warning("Encoding failed for feature: " + feature.getID());
                            GeoRSSTransformerBase.LOGGER.log(Level.FINE, "", e);
                        }
                    }
                }
                finally {
                    if (iterator == null) continue;
                    features.close(iterator);
                }
            }
        }

        void encodeEntry(Feature feature) {
            this.start("entry");
            this.element("title", feature.getID());
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, "http://localhost...");
            this.element("link", null, atts);
            this.element("id", feature.getID());
            this.element("updated", new Date().toString());
            this.element("content", "some content");
            this.start("georss:where");
            this.encodeGeometry(feature);
            this.end("georss:where");
            this.end("entry");
        }
    }
}

