/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.png;

import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.jai.PlanarImage;
import org.geotools.image.ImageWorker;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.wms.responses.DefaultRasterLegendProducer;

class PNGLegendGraphicProducer
extends DefaultRasterLegendProducer {
    PNGLegendGraphicProducer() {
    }

    public void writeTo(OutputStream out) throws IOException, ServiceException {
        BufferedImage image = super.getLegendGraphic();
        MemoryCacheImageOutputStream memOutStream = new MemoryCacheImageOutputStream(out);
        ImageWorker worker = new ImageWorker((RenderedImage)image);
        PlanarImage finalImage = image.getColorModel() instanceof DirectColorModel ? worker.forceComponentColorModel().getPlanarImage() : worker.getPlanarImage();
        Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType("image/png");
        ImageWriter writer = null;
        if (!it.hasNext()) {
            throw new IllegalStateException("No PNG ImageWriter found");
        }
        writer = it.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        if (writer.getClass().getName().equals("com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter")) {
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(0.75f);
        }
        writer.setOutput(memOutStream);
        writer.write(null, new IIOImage((RenderedImage)finalImage, null, null), iwp);
        memOutStream.flush();
        memOutStream.close();
        writer.dispose();
    }

    public String getContentType() throws IllegalStateException {
        return "image/png";
    }
}

