/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;

public class FeatureTemplate {
    static Configuration templateConfig = new Configuration();
    public static SimpleDateFormat DATE_FORMAT;
    public static SimpleDateFormat DATETIME_FORMAT;
    public static SimpleDateFormat TIME_FORMAT;
    Map templateCache = new HashMap();
    CharArrayWriter caw = new CharArrayWriter();

    public void title(Feature feature, OutputStream output) throws IOException {
        this.title(feature, new OutputStreamWriter(output));
    }

    public void description(Feature feature, OutputStream output) throws IOException {
        this.description(feature, new OutputStreamWriter(output));
    }

    public void title(Feature feature, Writer writer) throws IOException {
        this.execute(feature, feature.getFeatureType(), writer, "title.ftl", null);
    }

    public void description(Feature feature, Writer writer) throws IOException {
        this.execute(feature, feature.getFeatureType(), writer, "description.ftl", null);
    }

    public String title(Feature feature) throws IOException {
        this.caw.reset();
        this.title(feature, this.caw);
        return this.caw.toString();
    }

    public String description(Feature feature) throws IOException {
        this.caw.reset();
        this.description(feature, this.caw);
        return this.caw.toString();
    }

    public void template(Feature feature, Writer writer, String template, Class lookup) throws IOException {
        this.execute(feature, feature.getFeatureType(), writer, template, lookup);
    }

    public void template(Feature feature, OutputStream output, String template, Class lookup) throws IOException {
        this.template(feature, new OutputStreamWriter(output), template, lookup);
    }

    public String template(Feature feature, String template, Class lookup) throws IOException {
        this.caw.reset();
        this.template(feature, this.caw, template, lookup);
        return this.caw.toString();
    }

    private void execute(Object feature, FeatureType featureType, Writer writer, String template, Class lookup) throws IOException {
        Template t = null;
        t = this.lookupTemplate(featureType, template, lookup);
        try {
            t.process(feature, writer);
        }
        catch (TemplateException e) {
            String msg = "Error occured processing template.";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template lookupTemplate(FeatureType featureType, String template, Class lookup) throws IOException {
        TemplateKey key = new TemplateKey(featureType, template);
        Template t = (Template)this.templateCache.get(key);
        if (t != null) {
            return t;
        }
        GeoServerTemplateLoader templateLoader = new GeoServerTemplateLoader(lookup != null ? lookup : this.getClass());
        templateLoader.setFeatureType(featureType);
        Configuration configuration = templateConfig;
        synchronized (configuration) {
            templateConfig.setTemplateLoader((TemplateLoader)templateLoader);
            t = templateConfig.getTemplate(template);
        }
        this.templateCache.put(key, t);
        return t;
    }

    static {
        templateConfig.setObjectWrapper((ObjectWrapper)new FeatureWrapper());
        templateConfig.setDateFormat("MM/dd/yyyy");
        templateConfig.setDateTimeFormat("MM/dd/yyyy HH:mm:ss");
        templateConfig.setTimeFormat("HH:mm:ss");
        templateConfig.setLocale(Locale.US);
        templateConfig.setNumberFormat("0.###########");
        DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
        DATETIME_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    }

    private static class TemplateKey {
        FeatureType type;
        String template;

        public TemplateKey(FeatureType type, String template) {
            this.type = type;
            this.template = template;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateKey other = (TemplateKey)obj;
            if (this.template == null ? other.template != null : !this.template.equals(other.template)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

