/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.geoserver.ows.FlatKvpParser;
import org.geoserver.wms.kvp.StylesKvpParser;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;

public class LayersKvpParser
extends FlatKvpParser {
    Data catalog;
    private WMS wms;
    static /* synthetic */ Class class$org$vfny$geoserver$global$MapLayerInfo;

    public LayersKvpParser(WMS wms) {
        super("layers", class$org$vfny$geoserver$global$MapLayerInfo == null ? (class$org$vfny$geoserver$global$MapLayerInfo = LayersKvpParser.class$("org.vfny.geoserver.global.MapLayerInfo")) : class$org$vfny$geoserver$global$MapLayerInfo);
        this.wms = wms;
        this.catalog = wms.getData();
    }

    protected Object parse(List values) throws Exception {
        List layerNames = values;
        ArrayList<String> realLayerNames = new ArrayList<String>();
        String layerName = null;
        int l_counter = 0;
        Iterator it = layerNames.iterator();
        while (it.hasNext()) {
            layerName = (String)it.next();
            Integer layerType = this.catalog.getLayerType(layerName);
            if (layerType == null) {
                boolean found = false;
                if (this.wms.getBaseMapLayers().containsKey(layerName)) {
                    realLayerNames.add(layerName);
                    found = true;
                    ++l_counter;
                } else {
                    String catalogLayerName = null;
                    Iterator c_keys = this.catalog.getLayerNames().iterator();
                    while (c_keys.hasNext()) {
                        catalogLayerName = (String)c_keys.next();
                        try {
                            FeatureTypeInfo ftype = this.findFeatureLayer(catalogLayerName);
                            String wmsPath = ftype.getWmsPath();
                            if (wmsPath == null || !wmsPath.matches(".*/" + layerName)) continue;
                            realLayerNames.add(catalogLayerName);
                            found = true;
                            ++l_counter;
                        }
                        catch (Exception e_1) {
                            try {
                                CoverageInfo cv = this.findCoverageLayer(catalogLayerName);
                                String wmsPath = cv.getWmsPath();
                                if (wmsPath == null || !wmsPath.matches(".*/" + layerName)) continue;
                                realLayerNames.add(catalogLayerName);
                                found = true;
                                ++l_counter;
                            }
                            catch (Exception e_2) {}
                        }
                    }
                }
                if (found) continue;
                throw new WmsException("Could not find layer " + layerName, "LayerNotDefined");
            }
            realLayerNames.add(layerName);
            ++l_counter;
        }
        int layerCount = realLayerNames.size();
        if (layerCount == 0) {
            throw new WmsException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        MapLayerInfo[] layers = new MapLayerInfo[layerCount];
        for (int i = 0; i < layerCount; ++i) {
            layerName = (String)layerNames.get(i);
            layers[i] = this.buildMapLayerInfo(layerName);
        }
        return layers;
    }

    private MapLayerInfo buildMapLayerInfo(String layerName) throws Exception {
        MapLayerInfo li = new MapLayerInfo();
        FeatureTypeInfo ftype = this.findFeatureLayer(layerName);
        if (ftype != null) {
            li.setFeature(ftype);
        } else {
            CoverageInfo cv = this.findCoverageLayer(layerName);
            if (cv != null) {
                li.setCoverage(cv);
            } else if (this.wms.getBaseMapLayers().containsKey(layerName)) {
                String styleCsl = (String)this.wms.getBaseMapStyles().get(layerName);
                String layerCsl = (String)this.wms.getBaseMapLayers().get(layerName);
                LayersKvpParser lparser = new LayersKvpParser(this.wms);
                StylesKvpParser sparser = new StylesKvpParser(this.wms.getData());
                MapLayerInfo[] layerArray = (MapLayerInfo[])lparser.parse(layerCsl);
                List styleList = (List)sparser.parse(styleCsl);
                li.setBase(layerName, new ArrayList<MapLayerInfo>(Arrays.asList(layerArray)), styleList);
            } else {
                throw new WmsException("Layer " + layerName + " could not be found");
            }
        }
        return li;
    }

    FeatureTypeInfo findFeatureLayer(String layerName) throws WmsException {
        FeatureTypeInfo ftype = null;
        Integer layerType = this.catalog.getLayerType(layerName);
        if (Data.TYPE_VECTOR != layerType) {
            return null;
        }
        ftype = this.catalog.getFeatureTypeInfo(layerName);
        return ftype;
    }

    CoverageInfo findCoverageLayer(String layerName) throws WmsException {
        CoverageInfo cv = null;
        Integer layerType = this.catalog.getLayerType(layerName);
        if (Data.TYPE_RASTER != layerType) {
            return null;
        }
        cv = this.catalog.getCoverageInfo(layerName);
        return cv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

