/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geoserver.wms.WebMapService;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;
import org.vfny.geoserver.wms.responses.DescribeLayerResponse;
import org.vfny.geoserver.wms.responses.GetFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.WMSCapabilitiesResponse;
import org.vfny.geoserver.wms.servlets.Capabilities;
import org.vfny.geoserver.wms.servlets.DescribeLayer;
import org.vfny.geoserver.wms.servlets.GetFeatureInfo;
import org.vfny.geoserver.wms.servlets.GetLegendGraphic;
import org.vfny.geoserver.wms.servlets.GetMap;

public class DefaultWebMapService
implements WebMapService,
ApplicationContextAware {
    public static String FORMAT = "image/png";
    public static List STYLES = Collections.EMPTY_LIST;
    public static int HEIGHT = 256;
    public static int WIDTH = 256;
    public static String SRS = "EPSG:4326";
    public static Boolean TRANSPARENT = Boolean.TRUE;
    public static ReferencedEnvelope BBOX = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public WMSCapabilitiesResponse getCapabilities(WMSCapabilitiesRequest request) {
        Capabilities capabilities = (Capabilities)((Object)this.context.getBean("wmsGetCapabilities"));
        return (WMSCapabilitiesResponse)capabilities.getResponse();
    }

    public WMSCapabilitiesResponse capabilities(WMSCapabilitiesRequest request) {
        return this.getCapabilities(request);
    }

    public DescribeLayerResponse describeLayer(DescribeLayerRequest request) {
        DescribeLayer describeLayer = (DescribeLayer)((Object)this.context.getBean("wmsDescribeLayer"));
        return (DescribeLayerResponse)describeLayer.getResponse();
    }

    public GetMapResponse getMap(GetMapRequest request) {
        GetMap getMap = (GetMap)((Object)this.context.getBean("wmsGetMap"));
        return (GetMapResponse)getMap.getResponse();
    }

    public GetMapResponse map(GetMapRequest request) {
        return this.getMap(request);
    }

    public GetFeatureInfoResponse getFeatureInfo(GetFeatureInfoRequest request) {
        GetFeatureInfo getFeatureInfo = (GetFeatureInfo)((Object)this.context.getBean("wmsGetFeatureInfo"));
        return (GetFeatureInfoResponse)getFeatureInfo.getResponse();
    }

    public GetLegendGraphicResponse getLegendGraphic(GetLegendGraphicRequest request) {
        GetLegendGraphic getLegendGraphic = (GetLegendGraphic)((Object)this.context.getBean("wmsGetLegendGraphic"));
        return (GetLegendGraphicResponse)getLegendGraphic.getResponse();
    }

    public GetMapResponse reflect(GetMapRequest request) {
        return this.getMapReflect(request);
    }

    public GetMapResponse getMapReflect(GetMapRequest request) {
        GetMapRequest getMap = request;
        if (getMap.getFormat() == null) {
            getMap.setFormat(FORMAT);
        }
        if (getMap.getHeight() < 1) {
            getMap.setHeight(HEIGHT);
        }
        if (getMap.getWidth() < 1) {
            getMap.setWidth(WIDTH);
        }
        if (getMap.getStyles() == null || getMap.getStyles().isEmpty()) {
            if (getMap.getLayers() != null && getMap.getLayers().length > 0) {
                ArrayList<Style> styles = new ArrayList<Style>(getMap.getLayers().length);
                for (int i = 0; i < getMap.getLayers().length; ++i) {
                    styles.add(getMap.getLayers()[i].getDefaultStyle());
                }
                getMap.setStyles(styles);
            } else {
                getMap.setStyles(STYLES);
            }
        }
        if (getMap.getSRS() == null) {
            getMap.setSRS(SRS);
        }
        if (getMap.getBbox() == null) {
            getMap.setBbox((Envelope)BBOX);
        }
        return this.getMap(getMap);
    }
}

