/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public final class TiffMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private static final ImageWriterSpi writerSPI = new TIFFImageWriterSpi();

    public TiffMapProducer(String outputFormat, String mime, WMS wms) {
        super(outputFormat, mime, wms);
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws WmsException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a writer for tiff");
        }
        ImageWriter writer = writerSPI.createWriterInstance();
        ImageOutputStream ioutstream = ImageIO.createImageOutputStream(outStream);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image ...");
        }
        if (this.format.equalsIgnoreCase("image/tiff8") || this.mapContext.getPaletteInverter() != null) {
            image = this.forceIndexed8Bitmask(image);
        }
        writer.setOutput(ioutstream);
        writer.write(image);
        ioutstream.close();
        writer.dispose();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image done!");
        }
    }

    public String getContentDisposition() {
        return null;
    }
}

