/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.vfny.geoserver.wms.responses.map.svg.EncodeSVG;

public class SVGMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private EncodeSVG svgEncoder;

    public void abort(Service gs) {
        this.svgEncoder.abort();
    }

    public String getContentType() {
        return "image/svg+xml";
    }

    public String getContentEncoding() {
        return null;
    }

    public void abort() {
        LOGGER.fine("aborting SVG map response");
        if (this.svgEncoder != null) {
            LOGGER.info("aborting SVG encoder");
            this.svgEncoder.abort();
        }
    }

    public void produceMap() throws WmsException {
        if (this.mapContext == null) {
            throw new WmsException("The map context is not set");
        }
        this.svgEncoder = new EncodeSVG(this.mapContext);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.svgEncoder.encode(out);
    }

    public String getContentDisposition() {
        return null;
    }
}

