/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.transform.Translator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.xml.sax.ContentHandler;

public class KMLSuperOverlayTransformer
extends KMLTransformerBase {
    static Logger LOGGER = Logger.getLogger("org.geoserver.kml");
    static final ReferencedEnvelope world = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    static final double[] resolutions = new double[100];
    final WMSMapContext mapContext;

    public KMLSuperOverlayTransformer(WMSMapContext mapContext) {
        this.mapContext = mapContext;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLSuperOverlayerTranslator(handler);
    }

    static {
        for (int i = 0; i < resolutions.length; ++i) {
            KMLSuperOverlayTransformer.resolutions[i] = world.getWidth() / (double)((1 << i) * 256);
        }
    }

    class KMLSuperOverlayerTranslator
    extends KMLTransformerBase.KMLTranslatorSupport {
        public KMLSuperOverlayerTranslator(ContentHandler contentHandler) {
            super(KMLSuperOverlayTransformer.this, contentHandler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            int i;
            MapLayer mapLayer = (MapLayer)o;
            ReferencedEnvelope extent = KMLSuperOverlayTransformer.this.mapContext.getAreaOfInterest();
            double resolution = Math.max(extent.getWidth() / 256.0, extent.getHeight() / 256.0);
            for (i = 1; i < resolutions.length; ++i) {
                if (!(resolution > resolutions[i])) continue;
                --i;
                break;
            }
            LOGGER.fine("resolution = " + resolution);
            LOGGER.fine("zoom level = " + i);
            ReferencedEnvelope top = null;
            while (i > 0) {
                resolution = resolutions[i];
                double tilelon = resolution * 256.0;
                double tilelat = resolution * 256.0;
                double lon0 = extent.getMinX() - world.getMinX();
                double lon1 = extent.getMaxX() - world.getMinX();
                int col0 = (int)Math.floor(lon0 / tilelon);
                int col1 = (int)Math.floor(lon1 / tilelon - 1.0E-9);
                double lat0 = extent.getMinY() - world.getMinY();
                double lat1 = extent.getMaxY() - world.getMinY();
                int row0 = (int)Math.floor(lat0 / tilelat);
                int row1 = (int)Math.floor(lat1 / tilelat - 1.0E-9);
                if (col0 == col1 && row0 == row1) {
                    double tileoffsetlon = world.getMinX() + (double)col0 * tilelon;
                    double tileoffsetlat = world.getMinY() + (double)row0 * tilelat;
                    top = new Envelope(tileoffsetlon, tileoffsetlon + tilelon, tileoffsetlat, tileoffsetlat + tilelat);
                    break;
                }
                --i;
            }
            if (top == null) {
                top = world;
            }
            LOGGER.fine("request = " + extent);
            LOGGER.fine("top level = " + top);
            if (KMLSuperOverlayTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("Document");
            this.encodeRegion((Envelope)top, 256, 1024);
            if (top != world) {
                Envelope e00 = new Envelope(top.getMinX(), top.getMinX() + top.getWidth() / 2.0, top.getMaxY() - top.getHeight() / 2.0, top.getMaxY());
                Envelope e01 = new Envelope(e00.getMaxX(), top.getMaxX(), e00.getMinY(), e00.getMaxY());
                Envelope e10 = new Envelope(e00.getMinX(), e00.getMaxX(), top.getMinY(), e00.getMinY());
                Envelope e11 = new Envelope(e01.getMinX(), e01.getMaxX(), e10.getMinY(), e10.getMaxY());
                this.encodeNetworkLink(e00, "00", mapLayer);
                this.encodeNetworkLink(e01, "01", mapLayer);
                this.encodeNetworkLink(e10, "10", mapLayer);
                this.encodeNetworkLink(e11, "11", mapLayer);
            } else {
                Envelope e0 = new Envelope(top.getMinX(), top.getMinX() + top.getWidth() / 2.0, top.getMinY(), top.getMaxY());
                Envelope e1 = new Envelope(e0.getMaxX(), top.getMaxX(), top.getMinY(), top.getMaxY());
                this.encodeNetworkLink(e0, "0", mapLayer);
                this.encodeNetworkLink(e1, "1", mapLayer);
            }
            if (top == world) {
                this.encodeGroundOverlay(mapLayer, i, new Envelope(-180.0, 0.0, -90.0, 90.0));
                this.encodeGroundOverlay(mapLayer, i, new Envelope(0.0, 180.0, -90.0, 90.0));
            } else {
                this.encodeGroundOverlay(mapLayer, i, (Envelope)top);
            }
            this.end("Document");
            if (KMLSuperOverlayTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        void encodeGroundOverlay(MapLayer mapLayer, int drawOrder, Envelope box) {
            this.start("GroundOverlay");
            this.element("drawOrder", "" + drawOrder);
            this.start("Icon");
            String href = KMLUtils.getMapUrl(KMLSuperOverlayTransformer.this.mapContext, mapLayer, box, new String[]{"width", "256", "height", "256"}, true);
            this.element("href", href);
            LOGGER.fine(href);
            this.end("Icon");
            this.encodeLatLonBox(box);
            this.end("GroundOverlay");
        }

        void encodeRegion(Envelope box, int minLodPixels, int maxLodPixels) {
            this.start("Region");
            this.start("Lod");
            this.element("minLodPixels", "128");
            this.element("maxLodPixels", "" + maxLodPixels);
            this.end("Lod");
            this.encodeLatLonAltBox(box);
            this.end("Region");
        }

        void encodeNetworkLink(Envelope box, String name, MapLayer mapLayer) {
            this.start("NetworkLink");
            this.element("name", name);
            this.encodeRegion(box, 512, 2048);
            this.start("Link");
            String getMap = KMLUtils.getMapUrl(KMLSuperOverlayTransformer.this.mapContext, mapLayer, box, new String[]{"format", "application/vnd.google-earth.kml+xml", "width", "256", "height", "256", "superoverlay", "true"}, false);
            this.element("href", getMap);
            LOGGER.fine("Network link " + name + ":" + getMap);
            this.element("viewRefreshMode", "onRegion");
            this.end("Link");
            this.end("NetworkLink");
        }

        void encodeLatLonAltBox(Envelope box) {
            this.start("LatLonAltBox");
            this.encodeBox(box);
            this.end("LatLonAltBox");
        }

        void encodeLatLonBox(Envelope box) {
            this.start("LatLonBox");
            this.encodeBox(box);
            this.end("LatLonBox");
        }

        void encodeBox(Envelope box) {
            this.element("north", String.valueOf(box.getMaxY()));
            this.element("south", String.valueOf(box.getMinY()));
            this.element("east", String.valueOf(box.getMaxX()));
            this.element("west", String.valueOf(box.getMinX()));
        }
    }
}

