/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.wms.responses.featureInfo.AbstractFeatureInfoResponse;

public class TextFeatureInfoResponse
extends AbstractFeatureInfoResponse {
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public TextFeatureInfoResponse() {
        this.format = "text/plain";
        this.supportedFormats = Collections.singletonList("text/plain");
    }

    public HashMap getResponseHeaders() {
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.getRequest().getGeoServer().getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        PrintWriter writer = new PrintWriter(osw);
        int featuresPrinted = 0;
        int maxfeatures = this.getRequest().getFeatureCount();
        FeatureReader reader = null;
        try {
            int size = this.results.size();
            for (int i = 0; i < size; ++i) {
                FeatureResults fr = (FeatureResults)this.results.get(i);
                reader = fr.reader();
                if (reader.hasNext() && featuresPrinted < maxfeatures) {
                    writer.println("Results for FeatureType '" + reader.getFeatureType().getTypeName() + "':");
                }
                while (reader.hasNext()) {
                    Feature f = reader.next();
                    FeatureType schema = f.getFeatureType();
                    AttributeType[] types = schema.getAttributeTypes();
                    if (featuresPrinted >= maxfeatures) continue;
                    writer.println("--------------------------------------------");
                    for (int j = 0; j < types.length; ++j) {
                        if ((class$com$vividsolutions$jts$geom$Geometry == null ? TextFeatureInfoResponse.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(types[j].getType())) {
                            Geometry g = (Geometry)f.getAttribute(types[j].getName());
                            writer.println(types[j].getName() + " = [GEOMETRY (" + g.getGeometryType() + ") with " + g.getNumPoints() + " points]");
                            continue;
                        }
                        writer.println(types[j].getName() + " = " + f.getAttribute(types[j].getName()));
                    }
                    writer.println("--------------------------------------------");
                    ++featuresPrinted;
                }
            }
        }
        catch (IllegalAttributeException ife) {
            AbstractFeatureInfoResponse.LOGGER.log(Level.WARNING, "Error generating getFeaturInfo, HTML format", ife);
            writer.println("Unable to generate information " + (Object)((Object)ife));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (featuresPrinted == 0) {
            writer.println("no features were found");
        }
        writer.flush();
    }

    public String getContentDisposition() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

