/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.servlets.WMService;

public class DescribeLayerKvpRequestReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$requests$DescribeLayerKvpRequestReader == null ? (class$org$vfny$geoserver$wms$requests$DescribeLayerKvpRequestReader = DescribeLayerKvpRequestReader.class$("org.vfny.geoserver.wms.requests.DescribeLayerKvpRequestReader")) : class$org$vfny$geoserver$wms$requests$DescribeLayerKvpRequestReader).getPackage().getName());
    static /* synthetic */ Class class$org$vfny$geoserver$wms$requests$DescribeLayerKvpRequestReader;

    public DescribeLayerKvpRequestReader(Map params, WMService service) {
        super(params, service);
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        int layerCount;
        DescribeLayerRequest req = new DescribeLayerRequest((WMService)this.service);
        req.setHttpServletRequest(request);
        String layersParam = this.getValue("LAYERS");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(layersParam);
        }
        List layers = KvpRequestReader.readFlat((String)layersParam, (String)",");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(layers.toString());
        }
        if ((layerCount = layers.size()) == 0) {
            throw new WmsException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        Data catalog = req.getWMS().getData();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(catalog.toString());
        }
        String layerName = null;
        MapLayerInfo layer = null;
        for (int i = 0; i < layerCount; ++i) {
            layerName = (String)layers.get(i);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Looking for layer " + layerName);
            }
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("looking featuretypeinfos");
                }
                FeatureTypeInfo ftype = catalog.getFeatureTypeInfo(layerName);
                layer = new MapLayerInfo();
                layer.setFeature(ftype);
                req.addLayer(layer);
                continue;
            }
            catch (NoSuchElementException fex) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("looking coverageinfos");
                    }
                    CoverageInfo cinfo = catalog.getCoverageInfo(layerName);
                    layer = new MapLayerInfo();
                    layer.setCoverage(cinfo);
                    req.addLayer(layer);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(layerName + " found");
                    }
                }
                catch (NoSuchElementException cex) {
                    throw new WmsException(layerName + ": no such layer on this server", "LayerNotDefined");
                }
                req.addLayer(layer);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(layerName + " found");
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsed request " + (Object)((Object)req));
        }
        return req;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

