/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.tiff;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.tiff.TiffMapProducer;

public final class TiffMapProducerFactory
implements GetMapProducerFactorySpi {
    static final String MIME_TYPE = "image/tiff";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("image/tiff");
    private static final Logger LOGGER;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.wms.responses.map.tiff.TiffMapProducerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.getPackage().getName());
    }

    public String getName() {
        return "Tiff backed raster maps producer";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProduce(String mapFormat) {
        return MIME_TYPE.equals(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (!this.canProduce(mapFormat)) {
            throw new IllegalArgumentException("Can't produce " + mapFormat + " format");
        }
        return new TiffMapProducer(mapFormat, wms);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

