/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public final class TiffMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private static final String DEFAULT_MAP_FORMAT = "image/tiff";

    public TiffMapProducer(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public TiffMapProducer(String outputFormat, WMS wms) {
        super(outputFormat, wms);
        this.setOutputFormat(outputFormat);
    }

    protected void formatImageOutputStream(String format, BufferedImage image, OutputStream outStream) throws WmsException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a writer for tiff");
        }
        TIFFImageWriter writer = new TIFFImageWriter((ImageWriterSpi)new TIFFImageWriterSpi());
        MemoryCacheImageOutputStream ioutstream = new MemoryCacheImageOutputStream(outStream);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing for tiff");
        }
        writer.setOutput(ioutstream);
        writer.write(image);
        ioutstream.close();
        writer.dispose();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image done!");
        }
    }

    protected BufferedImage prepareImage(int width, int height) {
        return new BufferedImage(width, height, 6);
    }

    public String getContentDisposition() {
        return null;
    }
}

