/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.svg.AbortedException;
import org.vfny.geoserver.wms.responses.map.svg.SVGWriter;

public class EncodeSVG {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private static final String DOCTYPE = "<!DOCTYPE svg \n\tPUBLIC \"-//W3C//DTD SVG 20001102//EN\" \n\t\"http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd\">\n";
    private static final String SVG_HEADER = "<?xml version=\"1.0\" standalone=\"no\"?>\n\t<svg xmlns=\"http://www.w3.org/2000/svg\" \n\tstroke=\"green\" \n\tfill=\"none\" \n\tstroke-width=\"0.1%\"\n\tstroke-linecap=\"round\"\n\tstroke-linejoin=\"round\"\n\twidth=\"_width_\" \n\theight=\"_height_\" \n\tviewBox=\"_viewBox_\" \n\tpreserveAspectRatio=\"xMidYMid meet\">\n";
    private static final String SVG_FOOTER = "</svg>\n";
    private WMSMapContext mapContext;
    private SVGWriter writer;
    private boolean abortProcess;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EncodeSVG(WMSMapContext mapContext) {
        this.mapContext = mapContext;
    }

    public void abort() {
        this.abortProcess = true;
    }

    public void encode(OutputStream out) throws IOException {
        ReferencedEnvelope env = this.mapContext.getAreaOfInterest();
        this.writer = new SVGWriter(out, this.mapContext);
        this.writer.setMinCoordDistance(env.getWidth() / 1000.0);
        this.abortProcess = false;
        long t = System.currentTimeMillis();
        try {
            this.writeHeader();
            this.writeLayers();
            this.writer.write(SVG_FOOTER);
            this.writer.flush();
            t = System.currentTimeMillis() - t;
            LOGGER.info("SVG generated in " + t + " ms");
        }
        catch (IOException ioe) {
            if (this.abortProcess) {
                LOGGER.fine("SVG encoding aborted");
                return;
            }
            throw ioe;
        }
        catch (AbortedException ex) {
            return;
        }
    }

    public String createViewBox() {
        ReferencedEnvelope referenceSpace = this.mapContext.getAreaOfInterest();
        String viewBox = String.valueOf(this.writer.getX(referenceSpace.getMinX())) + " " + (this.writer.getY(referenceSpace.getMinY()) - referenceSpace.getHeight()) + " " + referenceSpace.getWidth() + " " + referenceSpace.getHeight();
        return viewBox;
    }

    private void writeHeader() throws IOException {
        String viewBox = this.createViewBox();
        String header = SVG_HEADER.replaceAll("_viewBox_", viewBox);
        header = header.replaceAll("_width_", String.valueOf(this.mapContext.getMapWidth()));
        header = header.replaceAll("_height_", String.valueOf(this.mapContext.getMapHeight()));
        this.writer.write(header);
    }

    private void writeDefs(FeatureType layer) throws IOException {
        block12: {
            block11: {
                GeometryAttributeType gtype = layer.getDefaultGeometry();
                Class geometryClass = gtype.getType();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.vividsolutions.jts.geom.MultiPoint");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (geometryClass == clazz) break block11;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("com.vividsolutions.jts.geom.Point");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (geometryClass != clazz2) break block12;
            }
            this.writePointDefs();
        }
    }

    private void writePointDefs() throws IOException {
        this.writer.write("<defs>\n\t<circle id='point' cx='0' cy='0' r='0.25%' fill='blue'/>\n</defs>\n");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeLayers() throws IOException, AbortedException {
        MapLayer[] layers = this.mapContext.getLayers();
        int nLayers = layers.length;
        int defMaxDecimals = this.writer.getMaximunFractionDigits();
        FilterFactory fFac = FilterFactoryFinder.createFilterFactory();
        int i = 0;
        while (true) {
            block11: {
                Object var15_18;
                if (i >= nLayers) {
                    return;
                }
                MapLayer layer = layers[i];
                FeatureReader featureReader = null;
                FeatureSource fSource = layer.getFeatureSource();
                FeatureType schema = fSource.getSchema();
                try {
                    try {
                        BBoxExpression bboxExpression = fFac.createBBoxExpression((Envelope)this.mapContext.getAreaOfInterest());
                        GeometryFilter bboxFilter = fFac.createGeometryFilter((short)7);
                        bboxFilter.addLeftGeometry((Expression)fFac.createAttributeExpression(schema, schema.getDefaultGeometry().getName()));
                        bboxFilter.addRightGeometry((Expression)bboxExpression);
                        DefaultQuery bboxQuery = new DefaultQuery(schema.getTypeName(), (Filter)bboxFilter);
                        LOGGER.fine("obtaining FeatureReader for " + schema.getTypeName());
                        featureReader = fSource.getFeatures((Query)bboxQuery).reader();
                        LOGGER.fine("got FeatureReader, now writing");
                        String groupId = null;
                        String styleName = null;
                        groupId = schema.getTypeName();
                        styleName = layer.getStyle().getName();
                        this.writer.write("<g id=\"" + groupId + "\"");
                        if (!styleName.startsWith("#")) {
                            this.writer.write(" class=\"" + styleName + "\"");
                        }
                        this.writer.write(">\n");
                        this.writeDefs(schema);
                        this.writer.writeFeatures(featureReader, styleName);
                        this.writer.write("</g>\n");
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (AbortedException ae) {
                        LOGGER.info("process aborted: " + ae.getMessage());
                        throw ae;
                    }
                    catch (Throwable t) {
                        LOGGER.warning("UNCAUGHT exception: " + t.getMessage());
                        IOException ioe = new IOException("UNCAUGHT exception: " + t.getMessage());
                        ioe.setStackTrace(t.getStackTrace());
                        throw ioe;
                    }
                }
                catch (Throwable throwable) {
                    var15_18 = null;
                    if (featureReader != null) {
                        featureReader.close();
                    }
                    throw throwable;
                }
                {
                    var15_18 = null;
                    if (featureReader == null) break block11;
                }
                featureReader.close();
            }
            ++i;
        }
    }
}

