/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;

class PDFMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map.pdf");
    private static final String DEFAULT_MAP_FORMAT = "application/pdf";
    private ByteArrayOutputStream bos;
    private GTRenderer renderer;
    private String format = null;
    private boolean abortRequested;
    private WMSMapContext mapContext;

    public PDFMapProducer() {
        this(DEFAULT_MAP_FORMAT);
    }

    public PDFMapProducer(String outputFormat) {
        this.setOutputFormat(outputFormat);
    }

    public void setOutputFormat(String format) {
        this.format = format;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        out.write(this.bos.toByteArray());
    }

    public void abort() {
        this.abortRequested = true;
        if (this.renderer != null) {
            this.renderer.stopRendering();
        }
    }

    public String getContentType() throws IllegalStateException {
        if (this.format == null) {
            throw new IllegalStateException("the output map format was not yet specified");
        }
        return this.format;
    }

    public String getContentEncoding() {
        return null;
    }

    public void produceMap(WMSMapContext map) throws WmsException {
        this.mapContext = map;
        int width = map.getMapWidth();
        int height = map.getMapHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + width + "x" + height + " image");
        }
        try {
            ByteArrayOutputStream curOs = new ByteArrayOutputStream();
            Rectangle pageSize = new Rectangle((float)width, (float)height);
            Document document = new Document(pageSize);
            document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)curOs);
            document.open();
            DefaultFontMapper mapper = new DefaultFontMapper();
            FontFactory.registerDirectories();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D graphic = tp.createGraphics((float)width, (float)height, (FontMapper)mapper);
            if (!map.isTransparent()) {
                graphic.setColor(map.getBgColor());
                graphic.fillRect(0, 0, width, height);
            } else {
                LOGGER.fine("setting to transparent");
                int type = 2;
                graphic.setComposite(AlphaComposite.getInstance(type));
                Color c = new Color(map.getBgColor().getRed(), map.getBgColor().getGreen(), map.getBgColor().getBlue(), 0);
                graphic.setBackground(map.getBgColor());
                graphic.setColor(c);
                graphic.fillRect(0, 0, width, height);
                type = 3;
                graphic.setComposite(AlphaComposite.getInstance(type));
            }
            java.awt.Rectangle paintArea = new java.awt.Rectangle(width, height);
            this.renderer = new StreamingRenderer();
            this.renderer.setContext((MapContext)map);
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderer.setJava2DHints(hints);
            HashMap<String, Comparable<Boolean>> rendererParams = new HashMap<String, Comparable<Boolean>>();
            rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
            rendererParams.put("renderingBuffer", new Integer(map.getBuffer()));
            this.renderer.setRendererHints(rendererParams);
            ReferencedEnvelope dataArea = map.getAreaOfInterest();
            AffineTransform at = RendererUtilities.worldToScreenTransform((Envelope)dataArea, (java.awt.Rectangle)paintArea);
            if (this.abortRequested) {
                graphic.dispose();
                document.close();
                return;
            }
            this.renderer.paint(graphic, paintArea, at);
            map = null;
            if (!this.abortRequested) {
                this.bos = curOs;
            }
            graphic.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
        }
        catch (Throwable t) {
            LOGGER.warning("UNCAUGHT exception: " + t.getMessage());
            WmsException wmse = new WmsException("UNCAUGHT exception: " + t.getMessage());
            wmse.setStackTrace(t.getStackTrace());
            throw wmse;
        }
    }

    protected WMSMapContext getMapContext() {
        return this.mapContext;
    }

    public String getContentDisposition() {
        if (this.mapContext.getLayer(0) != null) {
            try {
                String title = this.mapContext.getLayer(0).getFeatureSource().getSchema().getTypeName();
                if (title != null && !title.equals("")) {
                    return "attachment; filename=" + title + ".pdf";
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return "attachment; filename=geoserver.pdf";
    }
}

