/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.jpeg;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.image.ImageWorker;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public final class JPEGMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER;
    private Boolean JPEGNativeAcc;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.wms.responses.map.jpeg.JPEGMapProducer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.toString());
    }

    public JPEGMapProducer(String outputFormat, WMS wms) {
        super(outputFormat, wms);
        this.JPEGNativeAcc = wms.getGeoServer().getJPEGNativeAcceleration();
    }

    protected void formatImageOutputStream(String format, BufferedImage image, OutputStream outStream) throws IOException {
        if (!format.equalsIgnoreCase("image/jpeg")) {
            throw new IllegalArgumentException("The provided format " + format + " is not the same as expected: " + "image/jpeg");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to write a JPEG image.");
        }
        new ImageWorker((RenderedImage)image).writeJPEG((Object)outStream, "JPEG", 0.75f, this.JPEGNativeAcc.booleanValue());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing a JPEG done!!!");
        }
    }

    protected BufferedImage prepareImage(int width, int height) {
        return new BufferedImage(width, height, 6);
    }

    public String getContentDisposition() {
        return null;
    }
}

