/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.gif;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.gif.GIFMapProducer;

public final class GifMapProducerFactory
implements GetMapProducerFactorySpi {
    static final String MIME_TYPE = "image/gif";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("image/gif");

    public String getName() {
        return "Graphics Interchange Format (GIF) map producer";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        try {
            Class.forName("com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean canProduce(String mapFormat) {
        return MIME_TYPE.equals(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (!this.canProduce(mapFormat)) {
            throw new IllegalArgumentException(String.valueOf(mapFormat) + " not supported by this map producer");
        }
        return new GIFMapProducer(MIME_TYPE, wms);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

