/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.gif;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.geotools.image.ImageWorker;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public final class GIFMapProducer
extends DefaultRasterMapProducer {
    private static final IndexColorModel DEFAULT_PALETTE;

    static {
        int[] cmap = new int[256];
        int i = 0;
        int r = 0;
        while (r < 256) {
            int g = 0;
            while (g < 256) {
                int b = 0;
                while (b < 256) {
                    cmap[i++] = r << 16 | g << 8 | b;
                    b += 51;
                }
                g += 51;
            }
            r += 51;
        }
        int grayIncr = 256 / (256 - i);
        int gray = grayIncr * 3;
        while (i < 255) {
            cmap[i] = gray << 16 | gray << 8 | gray;
            gray += grayIncr;
            ++i;
        }
        DEFAULT_PALETTE = new IndexColorModel(8, 256, cmap, 0, true, 255, 0);
    }

    public GIFMapProducer(String format, WMS wms) {
        super(format, wms);
    }

    protected void formatImageOutputStream(String format, BufferedImage image, OutputStream outStream) throws WmsException, IOException {
        if (!format.equalsIgnoreCase("image/gif")) {
            throw new IllegalArgumentException("The provided format " + format + " is not the same as expected: " + "image/gif");
        }
        new ImageWorker((RenderedImage)image).forceIndexColorModelForGIF(true).writeGIF((Object)outStream, "LZW", 0.75f);
    }

    protected BufferedImage prepareImage(int width, int height) {
        return new BufferedImage(width, height, 6);
    }

    public String getContentDisposition() {
        return null;
    }
}

