/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.geotiff;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.geotiff.GeoTiffMapProducer;

public class GeoTiffMapProducerFactory
implements GetMapProducerFactorySpi {
    static final String MIME_TYPE = "image/geotiff";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("image/geotiff");

    public String getName() {
        return "Geographic tagged image format";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProduce(String mapFormat) {
        return MIME_TYPE.equals(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (!this.canProduce(mapFormat)) {
            throw new IllegalArgumentException(String.valueOf(mapFormat) + " not supported by this map producer");
        }
        return new GeoTiffMapProducer(MIME_TYPE, wms);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

