/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.geotiff;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.geotools.coverage.FactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.spatialschema.geometry.Envelope;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public class GeoTiffMapProducer
extends DefaultRasterMapProducer {
    static final String MIME_TYPE = "image/geotiff";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("image/geotiff");
    private static final GridCoverageFactory factory = FactoryFinder.getGridCoverageFactory(null);

    public GeoTiffMapProducer(String mime, WMS wms) {
        super(mime, wms);
    }

    protected void formatImageOutputStream(String format, BufferedImage image, OutputStream outStream) throws WmsException, IOException {
        WMSMapContext context = this.getMapContext();
        GridCoverage2D gc = factory.create((CharSequence)"geotiff", (RenderedImage)image, (Envelope)new GeneralEnvelope((Envelope)context.getAreaOfInterest()));
        MemoryCacheImageOutputStream imageOutStream = new MemoryCacheImageOutputStream(outStream);
        GeoTiffWriter writer = new GeoTiffWriter((Object)imageOutStream);
        writer.write((GridCoverage)gc, null);
        imageOutStream.flush();
        imageOutStream.close();
    }

    protected BufferedImage prepareImage(int width, int height) {
        return new BufferedImage(width, height, 6);
    }

    public String getContentDisposition() {
        return null;
    }
}

