/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.LegendURL;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wms.responses.GetFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.responses.helpers.LayerTree;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class WMSCapsTransformer
extends TransformerBase {
    public static final String WMS_CAPS_MIME = "application/vnd.ogc.wms_xml";
    private String schemaBaseUrl;
    private Set formats;
    private ApplicationContext applicationContext;

    public WMSCapsTransformer(String schemaBaseUrl, Set formats, ApplicationContext applicationContext) {
        this.formats = formats;
        if (schemaBaseUrl == null) {
            throw new NullPointerException();
        }
        this.schemaBaseUrl = schemaBaseUrl;
        this.setNamespaceDeclarationEnabled(false);
        this.applicationContext = applicationContext;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new CapabilitiesTranslator(handler, this.formats, this.applicationContext);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        String dtdUrl = String.valueOf(this.schemaBaseUrl) + "wms/1.1.1/WMS_MS_Capabilities.dtd";
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    private static class CapabilitiesTranslator
    extends TransformerBase.TranslatorSupport {
        private static final Logger LOGGER;
        private static final String EPSG = "EPSG:";
        private static AttributesImpl wmsVersion;
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
        private CapabilitiesRequest request;
        private Set formats;
        private ApplicationContext applicationContext;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.vfny.geoserver.wms.responses.helpers.WMSCapsTransformer$CapabilitiesTranslator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOGGER = Logger.getLogger(clazz.getPackage().getName());
            wmsVersion = new AttributesImpl();
            wmsVersion.addAttribute("", "version", "version", "", "1.1.1");
        }

        public CapabilitiesTranslator(ContentHandler handler, Set formats, ApplicationContext applicationContext) {
            super(handler, null, null);
            this.formats = formats;
            this.applicationContext = applicationContext;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof CapabilitiesRequest)) {
                throw new IllegalArgumentException();
            }
            this.request = (CapabilitiesRequest)o;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("producing a capabilities document for " + this.request);
            }
            this.start("WMT_MS_Capabilities", wmsVersion);
            this.handleService();
            this.handleCapability();
            this.end("WMT_MS_Capabilities");
        }

        private void handleService() {
            WMS wms = (WMS)this.request.getServiceRef().getServiceRef();
            this.start("Service");
            this.element("Name", "OGC:WMS");
            this.element("Title", wms.getTitle());
            this.element("Abstract", wms.getAbstract());
            this.handleKeywordList(wms.getKeywords());
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", wms.getOnlineResource().toExternalForm());
            this.element("OnlineResource", null, orAtts);
            this.handleContactInfo(wms.getGeoServer());
            this.element("Fees", wms.getFees());
            this.element("AccessConstraints", wms.getAccessConstraints());
            this.end("Service");
        }

        public void handleContactInfo(GeoServer geoServer) {
            this.start("ContactInformation");
            this.start("ContactPersonPrimary");
            this.element("ContactPerson", geoServer.getContactPerson());
            this.element("ContactOrganization", geoServer.getContactOrganization());
            this.end("ContactPersonPrimary");
            this.element("ContactPosition", geoServer.getContactPosition());
            this.start("ContactAddress");
            this.element("AddressType", geoServer.getAddressType());
            this.element("Address", geoServer.getAddress());
            this.element("City", geoServer.getAddressCity());
            this.element("StateOrProvince", geoServer.getAddressState());
            this.element("PostCode", geoServer.getAddressPostalCode());
            this.element("Country", geoServer.getAddressCountry());
            this.end("ContactAddress");
            this.element("ContactVoiceTelephone", geoServer.getContactVoice());
            this.element("ContactFacsimileTelephone", geoServer.getContactFacsimile());
            this.element("ContactElectronicMailAddress", geoServer.getContactEmail());
            this.end("ContactInformation");
        }

        private void handleKeywordList(List keywords) {
            this.start("KeywordList");
            if (keywords != null) {
                Iterator it = keywords.iterator();
                while (it.hasNext()) {
                    this.element("Keyword", String.valueOf(it.next()));
                }
            }
            this.end("KeywordList");
        }

        private void handleMetadataList(List metadataURLs) {
            if (metadataURLs == null) {
                return;
            }
            Iterator it = metadataURLs.iterator();
            while (it.hasNext()) {
                MetaDataLink link = (MetaDataLink)it.next();
                AttributesImpl lnkAtts = new AttributesImpl();
                lnkAtts.addAttribute("", "type", "type", "", link.getMetadataType());
                this.start("MetadataURL", lnkAtts);
                this.element("Format", link.getType());
                AttributesImpl orAtts = new AttributesImpl();
                orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
                orAtts.addAttribute("", "xlink:href", "xlink:href", "", link.getContent());
                this.element("OnlineResource", null, orAtts);
                this.end("MetadataURL");
            }
        }

        private void handleCapability() {
            this.start("Capability");
            this.handleRequest();
            this.handleException();
            this.handleSLD();
            this.handleLayers();
            this.end("Capability");
        }

        private void handleRequest() {
            WMS wms = (WMS)this.request.getServiceRef().getServiceRef();
            this.start("Request");
            this.start("GetCapabilities");
            this.element("Format", WMSCapsTransformer.WMS_CAPS_MIME);
            String serviceUrl = String.valueOf(this.request.getBaseUrl()) + "wms?SERVICE=WMS&";
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetCapabilities");
            this.start("GetMap");
            Iterator it = this.formats.iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetMap");
            this.start("GetFeatureInfo");
            it = GetFeatureInfoResponse.getFormats().iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetFeatureInfo");
            this.start("DescribeLayer");
            this.element("Format", WMSCapsTransformer.WMS_CAPS_MIME);
            this.handleDcpType(serviceUrl, null);
            this.end("DescribeLayer");
            this.start("GetLegendGraphic");
            it = GetLegendGraphicResponse.getFormats(this.applicationContext).iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetLegendGraphic");
            this.end("Request");
        }

        private void handleDcpType(String getUrl, String postUrl) {
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute("", "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", getUrl);
            this.start("DCPType");
            this.start("HTTP");
            if (getUrl != null) {
                this.start("Get");
                this.element("OnlineResource", null, orAtts);
                this.end("Get");
            }
            if (postUrl != null) {
                orAtts.setAttribute(2, "", "xlink:href", "xlink:href", "", postUrl);
                this.start("Post");
                this.element("OnlineResource", null, orAtts);
                this.end("Post");
            }
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleException() {
            this.start("Exception");
            WMS wms = (WMS)this.request.getServiceRef().getServiceRef();
            Iterator<String> it = Arrays.asList(wms.getExceptionFormats()).iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.end("Exception");
        }

        private void handleSLD() {
            AttributesImpl sldAtts = new AttributesImpl();
            WMS config = (WMS)this.request.getServiceRef().getServiceRef();
            String supportsSLD = config.supportsSLD() ? "1" : "0";
            String supportsUserLayer = config.supportsUserLayer() ? "1" : "0";
            String supportsUserStyle = config.supportsUserStyle() ? "1" : "0";
            String supportsRemoteWFS = config.supportsRemoteWFS() ? "1" : "0";
            sldAtts.addAttribute("", "SupportSLD", "SupportSLD", "", supportsSLD);
            sldAtts.addAttribute("", "UserLayer", "UserLayer", "", supportsUserLayer);
            sldAtts.addAttribute("", "UserStyle", "UserStyle", "", supportsUserStyle);
            sldAtts.addAttribute("", "RemoteWFS", "RemoteWFS", "", supportsRemoteWFS);
            this.start("UserDefinedSymbolization", sldAtts);
            this.end("UserDefinedSymbolization");
        }

        private void handleLayers() {
            WMS wms = (WMS)this.request.getServiceRef().getServiceRef();
            this.start("Layer");
            Data catalog = wms.getData();
            Collection ftypes = catalog.getFeatureTypeInfos().values();
            Collection coverages = catalog.getCoverageInfos().values();
            this.element("Title", wms.getTitle());
            this.element("Abstract", wms.getAbstract());
            this.handleRootSRSAndBbox(ftypes, MapLayerInfo.TYPE_VECTOR);
            LayerTree featuresLayerTree = new LayerTree(ftypes);
            this.handleFeaturesTree(featuresLayerTree);
            LayerTree coveragesLayerTree = new LayerTree(coverages);
            this.handleCoveragesTree(coveragesLayerTree);
            this.end("Layer");
        }

        private void handleRootSRSAndBbox(Collection ftypes, int TYPE) {
            String commonSRS = "";
            boolean isCommonSRS = true;
            Envelope latlonBbox = new Envelope();
            Envelope layerBbox = null;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Collecting summarized latlonbbox and common SRS...");
            }
            if (TYPE == MapLayerInfo.TYPE_VECTOR) {
                block27: {
                    Iterator it = ftypes.iterator();
                    while (it.hasNext()) {
                        FeatureTypeInfo layer = (FeatureTypeInfo)it.next();
                        if (!layer.isEnabled()) continue;
                        try {
                            layerBbox = layer.getLatLongBoundingBox();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Can't obtain latLonBBox of " + layer.getName() + ": " + e.getMessage(), e);
                        }
                        latlonBbox.expandToInclude(layerBbox);
                        String layerSRS = layer.getSRS();
                        if ("".equals(commonSRS)) {
                            commonSRS = layerSRS;
                            continue;
                        }
                        if (commonSRS.equals(layerSRS)) continue;
                        isCommonSRS = false;
                    }
                    if (isCommonSRS) {
                        commonSRS = EPSG + commonSRS;
                        LOGGER.fine("Common SRS is " + commonSRS);
                    } else {
                        commonSRS = "";
                        LOGGER.fine("No common SRS, don't forget to incorporate reprojection support...");
                    }
                    if (!commonSRS.equals("")) {
                        this.comment("common SRS:");
                        this.element("SRS", commonSRS);
                    }
                    this.comment("All supported EPSG projections:");
                    try {
                        Set s = CRS.getSupportedCodes((String)"EPSG");
                        Iterator it2 = s.iterator();
                        while (it2.hasNext()) {
                            String currentSRS = it2.next().toString();
                            if (currentSRS.equals(commonSRS)) continue;
                            this.element("SRS", EPSG + currentSRS);
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block27;
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
                }
                this.handleLatLonBBox(latlonBbox);
            } else if (TYPE == MapLayerInfo.TYPE_RASTER) {
                block28: {
                    CoverageInfo layer;
                    Iterator it = ftypes.iterator();
                    while (it.hasNext()) {
                        layer = (CoverageInfo)it.next();
                        if (!layer.isEnabled()) continue;
                        GeneralEnvelope bbox = layer.getWGS84LonLatEnvelope();
                        layerBbox = new Envelope(bbox.getLowerCorner().getOrdinate(0), bbox.getUpperCorner().getOrdinate(0), bbox.getLowerCorner().getOrdinate(1), bbox.getUpperCorner().getOrdinate(1));
                        latlonBbox.expandToInclude(layerBbox);
                        String layerSRS = layer.getSrsName();
                        if ("".equals(commonSRS)) {
                            commonSRS = layerSRS;
                            continue;
                        }
                        if (commonSRS.equals(layerSRS)) continue;
                        isCommonSRS = false;
                    }
                    if (isCommonSRS) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Common SRS is " + commonSRS);
                        }
                    } else {
                        commonSRS = "";
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("No common SRS, don't forget to incorporate reprojection support...");
                        }
                    }
                    if (!commonSRS.equals("")) {
                        this.comment("common SRS:");
                        this.element("SRS", commonSRS);
                    }
                    this.comment("All supported EPSG projections:");
                    try {
                        ArrayList<String> SRSs = new ArrayList<String>(ftypes.size());
                        Iterator it3 = ftypes.iterator();
                        while (it3.hasNext()) {
                            layer = (CoverageInfo)it3.next();
                            if (!layer.isEnabled()) continue;
                            List s = layer.getRequestCRSs();
                            Iterator it_1 = s.iterator();
                            while (it_1.hasNext()) {
                                String currentSRS = it_1.next().toString();
                                if (currentSRS.equals(commonSRS) || SRSs.contains(currentSRS)) continue;
                                SRSs.add(currentSRS);
                                this.element("SRS", currentSRS);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block28;
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
                }
                this.handleLatLonBBox(latlonBbox);
            }
        }

        private void handleFeaturesTree(LayerTree featuresLayerTree) {
            Collection data = featuresLayerTree.getData();
            Collection childrens = featuresLayerTree.getChildrens();
            Iterator it = data.iterator();
            while (it.hasNext()) {
                FeatureTypeInfo fLayer = (FeatureTypeInfo)it.next();
                if (!fLayer.isEnabled()) continue;
                this.handleFeatureType(fLayer);
            }
            Iterator it2 = childrens.iterator();
            while (it2.hasNext()) {
                LayerTree layerTree = (LayerTree)it2.next();
                this.start("Layer");
                this.element("Name", layerTree.getName());
                this.element("Title", layerTree.getName());
                this.handleFeaturesTree(layerTree);
                this.end("Layer");
            }
        }

        protected void handleFeatureType(FeatureTypeInfo ftype) {
            block5: {
                AttributesImpl qatts = new AttributesImpl();
                qatts.addAttribute("", "queryable", "queryable", "", "1");
                this.start("Layer", qatts);
                this.element("Name", ftype.getName());
                this.element("Title", ftype.getTitle());
                this.element("Abstract", ftype.getAbstract());
                this.handleKeywordList(ftype.getKeywords());
                this.element("SRS", EPSG + ftype.getSRS());
                try {
                    CoordinateReferenceSystem crs = CRS.decode((String)(EPSG + ftype.getSRS()));
                    String desc = "WKT definition of this CRS:\n" + crs.toWKT();
                    this.comment(desc);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
            Envelope bbox = null;
            Envelope llbbox = null;
            try {
                bbox = ftype.getBoundingBox();
                llbbox = ftype.getLatLongBoundingBox();
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't obtain latLongBBox of " + ftype.getName() + ": " + ex.getMessage(), ex);
            }
            this.handleLatLonBBox(llbbox);
            this.handleBBox(bbox, EPSG + ftype.getSRS());
            this.handleMetadataList(ftype.getMetadataLinks());
            this.start("Style");
            Style ftStyle = ftype.getDefaultStyle();
            this.element("Name", ftStyle.getName());
            this.element("Title", ftStyle.getTitle());
            this.element("Abstract", ftStyle.getAbstract());
            this.handleLegendURL(ftype);
            this.end("Style");
            ArrayList styles = ftype.getStyles();
            Iterator s_IT = styles.iterator();
            while (s_IT.hasNext()) {
                ftStyle = (Style)s_IT.next();
                this.start("Style");
                this.element("Name", ftStyle.getName());
                this.element("Title", ftStyle.getTitle());
                this.element("Abstract", ftStyle.getAbstract());
                this.handleLegendURL(ftype);
                this.end("Style");
            }
            this.end("Layer");
        }

        private void handleCoveragesTree(LayerTree coveragesLayerTree) {
            Collection data = coveragesLayerTree.getData();
            Collection childrens = coveragesLayerTree.getChildrens();
            Iterator it = data.iterator();
            while (it.hasNext()) {
                CoverageInfo cLayer = (CoverageInfo)it.next();
                if (!cLayer.isEnabled()) continue;
                this.handleCoverage(cLayer);
            }
            Iterator it2 = childrens.iterator();
            while (it2.hasNext()) {
                LayerTree layerTree = (LayerTree)it2.next();
                this.start("Layer");
                this.element("Name", layerTree.getName());
                this.element("Title", layerTree.getName());
                this.handleCoveragesTree(layerTree);
                this.end("Layer");
            }
        }

        protected void handleCoverage(CoverageInfo coverage) {
            AttributesImpl qatts = new AttributesImpl();
            qatts.addAttribute("", "queryable", "queryable", "", "0");
            this.start("Layer", qatts);
            this.element("Name", coverage.getName());
            this.element("Title", coverage.getLabel());
            this.element("Abstract", coverage.getDescription());
            this.handleKeywordList(coverage.getKeywords());
            String desc = "WKT definition of this CRS:\n" + coverage.getSrsWKT();
            this.comment(desc);
            String authority = coverage.getSrsName();
            this.element("SRS", authority);
            GeneralEnvelope bounds = null;
            GeneralEnvelope llBounds = null;
            GeneralEnvelope latLonEnvelope = coverage.getWGS84LonLatEnvelope();
            bounds = coverage.getEnvelope();
            llBounds = latLonEnvelope;
            Envelope bbox = new Envelope(bounds.getLowerCorner().getOrdinate(0), bounds.getUpperCorner().getOrdinate(0), bounds.getLowerCorner().getOrdinate(1), bounds.getUpperCorner().getOrdinate(1));
            Envelope llBbox = new Envelope(llBounds.getLowerCorner().getOrdinate(0), llBounds.getUpperCorner().getOrdinate(0), llBounds.getLowerCorner().getOrdinate(1), llBounds.getUpperCorner().getOrdinate(1));
            this.handleLatLonBBox(llBbox);
            this.handleBBox(bbox, authority);
            this.start("Style");
            Style cvStyle = coverage.getDefaultStyle();
            this.element("Name", cvStyle.getName());
            this.element("Title", cvStyle.getTitle());
            this.element("Abstract", cvStyle.getAbstract());
            this.handleLegendURL(coverage);
            this.end("Style");
            ArrayList styles = coverage.getStyles();
            Iterator s_IT = styles.iterator();
            while (s_IT.hasNext()) {
                cvStyle = (Style)s_IT.next();
                this.start("Style");
                this.element("Name", cvStyle.getName());
                this.element("Title", cvStyle.getTitle());
                this.element("Abstract", cvStyle.getAbstract());
                this.handleLegendURL(coverage);
                this.end("Style");
            }
            this.end("Layer");
        }

        protected void handleLegendURL(Object layer) {
            LegendURL legend = null;
            String layerName = null;
            if (layer instanceof FeatureTypeInfo) {
                legend = ((FeatureTypeInfo)layer).getLegendURL();
                layerName = ((FeatureTypeInfo)layer).getName();
            } else if (layer instanceof CoverageInfo) {
                layerName = ((CoverageInfo)layer).getName();
            }
            if (legend != null) {
                if (LOGGER.isLoggable(Level.CONFIG)) {
                    LOGGER.config("using user supplied legend URL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(legend.getWidth()));
                attrs.addAttribute("", "height", "height", "", String.valueOf(legend.getHeight()));
                this.start("LegendURL", attrs);
                this.element("Format", legend.getFormat());
                attrs.clear();
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legend.getOnlineResource());
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            } else {
                String defaultFormat = "image/png";
                if (!GetLegendGraphicResponse.supportsFormat(defaultFormat, this.applicationContext)) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Default legend format (" + defaultFormat + ")is not supported (jai not available?), can't add LegendURL element");
                    }
                    return;
                }
                if (LOGGER.isLoggable(Level.CONFIG)) {
                    LOGGER.config("Adding GetLegendGraphic call as LegendURL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(20));
                attrs.addAttribute("", "height", "height", "", String.valueOf(20));
                this.start("LegendURL", attrs);
                this.element("Format", defaultFormat);
                attrs.clear();
                StringBuffer onlineResource = new StringBuffer(this.request.getBaseUrl());
                onlineResource.append("wms/GetLegendGraphic?VERSION=");
                onlineResource.append("1.0.0");
                onlineResource.append("&FORMAT=");
                onlineResource.append(defaultFormat);
                onlineResource.append("&WIDTH=");
                onlineResource.append(20);
                onlineResource.append("&HEIGHT=");
                onlineResource.append(20);
                onlineResource.append("&LAYER=");
                onlineResource.append(layerName);
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", onlineResource.toString());
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            }
        }

        private void handleLatLonBBox(Envelope bbox) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("LatLonBoundingBox", null, bboxAtts);
        }

        public void comment(String comment) {
            if (this.contentHandler instanceof TransformerIdentityImpl) {
                try {
                    TransformerIdentityImpl ch = (TransformerIdentityImpl)this.contentHandler;
                    ch.comment(comment.toCharArray(), 0, comment.length());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void handleBBox(Envelope bbox, String SRS) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "SRS", "SRS", "", SRS);
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("BoundingBox", null, bboxAtts);
        }
    }
}

