/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.renderer.lite.LiteRenderer2;

public final class JAISupport {
    private static final Logger LOGGER;
    static ArrayList testedFormats;
    private static Set supportedFormats;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.wms.responses.helpers.JAISupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.getPackage().getName());
        testedFormats = new ArrayList();
        testedFormats.add("image/jpeg");
    }

    public static Set getSupportedFormats() {
        if (supportedFormats == null) {
            String[] mimeTypes = null;
            LiteRenderer2 testRenderer = null;
            try {
                testRenderer = new LiteRenderer2();
                mimeTypes = ImageIO.getWriterMIMETypes();
            }
            catch (NoClassDefFoundError ncdfe) {
                supportedFormats = Collections.EMPTY_SET;
                LOGGER.warning("could not find jai: " + ncdfe);
            }
            if (testRenderer == null || mimeTypes == null) {
                LOGGER.info("renderer was null, so jai not found");
                supportedFormats = Collections.EMPTY_SET;
            } else {
                supportedFormats = new HashSet();
                List<String> formatsList = Arrays.asList(mimeTypes);
                Iterator<String> it = formatsList.iterator();
                while (it.hasNext()) {
                    String curFormat = it.next().toString();
                    if (curFormat.equals("") || !testedFormats.contains(curFormat)) continue;
                    supportedFormats.add(curFormat);
                }
                if (LOGGER.isLoggable(Level.CONFIG)) {
                    StringBuffer sb = new StringBuffer("Supported JAIMapResponse's MIME Types: [");
                    Iterator it2 = supportedFormats.iterator();
                    while (it2.hasNext()) {
                        sb.append(it2.next());
                        if (!it2.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("]");
                    LOGGER.config(sb.toString());
                }
            }
        }
        return supportedFormats;
    }

    public static boolean isJaiAvailable() {
        return JAISupport.getSupportedFormats().size() > 0;
    }

    public static void encode(String format, BufferedImage image, OutputStream outStream) throws IOException {
        Iterator<ImageWriter> it;
        if (format.equalsIgnoreCase("jpeg")) {
            format = "image/jpeg";
        }
        if (!(it = ImageIO.getImageWritersByMIMEType(format)).hasNext()) {
            throw new IllegalArgumentException("Format not supported: " + format);
        }
        ImageWriter writer = it.next();
        ImageOutputStream ioutstream = null;
        IIOMetadata meta = writer.getDefaultStreamMetadata(writer.getDefaultWriteParam());
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (format.equalsIgnoreCase("image/jpeg")) {
            param.setCompressionMode(2);
            param.setCompressionQuality(0.9f);
            meta = writer.getDefaultStreamMetadata(param);
            BufferedImage curImage = new BufferedImage(image.getWidth(), image.getHeight(), 5);
            Graphics2D g = curImage.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            image = curImage;
            ioutstream = ImageIO.createImageOutputStream(outStream);
            writer.setOutput(ioutstream);
            writer.write(image);
            ioutstream.close();
            writer.dispose();
            return;
        }
        ioutstream = ImageIO.createImageOutputStream(outStream);
        writer.setOutput(ioutstream);
        writer.write(meta, new IIOImage(image, null, meta), param);
        ioutstream.close();
        writer.dispose();
    }
}

