/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.FeatureResults;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.WFS;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wfs.requests.FeatureRequest;
import org.vfny.geoserver.wfs.responses.GML2FeatureResponseDelegate;
import org.vfny.geoserver.wfs.responses.GetFeatureResults;
import org.vfny.geoserver.wfs.servlets.WFService;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.responses.featureInfo.AbstractFeatureInfoResponse;

public class GmlFeatureInfoResponse
extends AbstractFeatureInfoResponse {
    private static final String FORMAT = "application/vnd.ogc.gml";

    public GmlFeatureInfoResponse() {
        this.supportedFormats = Collections.singletonList(FORMAT);
    }

    public HashMap getResponseHeaders() {
        return new HashMap();
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        GetFeatureInfoRequest fInfoReq = this.getRequest();
        WMS wms = (WMS)fInfoReq.getServiceRef().getServiceRef();
        FeatureRequest freq = new FeatureRequest((WFService)new MockWFService(fInfoReq.getRequest(), wms.getWFS()));
        freq.setHttpServletRequest(fInfoReq.getHttpServletRequest());
        freq.setRequest("GETFEATURE");
        freq.setHandle("GetFeatureInfo");
        freq.setMaxFeatures(fInfoReq.getFeatureCount());
        List queries = null;
        freq.setQueries(queries);
        GetFeatureResults getFeatureResults = new GetFeatureResults(freq);
        int i = 0;
        Iterator it = this.results.iterator();
        while (it.hasNext()) {
            FeatureResults fresults = (FeatureResults)it.next();
            FeatureTypeInfo finfo = (FeatureTypeInfo)this.metas.get(i);
            getFeatureResults.addFeatures(finfo, fresults);
            ++i;
        }
        GML2FeatureResponseDelegate encoder = new GML2FeatureResponseDelegate();
        encoder.prepare("GML2", getFeatureResults);
        encoder.encode(out);
    }

    public String getContentDisposition() {
        return null;
    }

    private static class MockWFService
    extends WFService {
        public MockWFService(String request, WFS wfs) {
            super(request, wfs);
        }
    }
}

