/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.GetLegendGraphicProducerSpi;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;

public class GetLegendGraphicResponse
implements Response {
    private static final Logger LOGGER;
    private GetLegendGraphicProducer delegate;
    private ApplicationContext applicationContext;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.wms.responses.GetLegendGraphicResponse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.getPackage().getName());
    }

    public GetLegendGraphicResponse(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request req) throws ServiceException {
        GetLegendGraphicRequest request = (GetLegendGraphicRequest)req;
        String outputFormat = request.getFormat();
        this.delegate = this.getDelegate(outputFormat);
        this.delegate.produceLegendGraphic(request);
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.delegate == null) {
            throw new IllegalStateException("No request has been processed");
        }
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("returning content encoding null");
        }
        return null;
    }

    public void abort(Service gs) {
        if (this.delegate != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("asking delegate for aborting the process");
            }
            this.delegate.abort();
        }
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        block4: {
            try {
                if (this.delegate == null) {
                    throw new IllegalStateException("No GetMapDelegate is setted, make sure you have called execute and it has succeed");
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("asking delegate for write to " + out);
                }
                this.delegate.writeTo(out);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINER)) break block4;
                LOGGER.finer("asking delegate for write to " + out);
            }
        }
    }

    private GetLegendGraphicProducer getDelegate(String outputFormat) throws WmsException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.vfny.geoserver.wms.GetLegendGraphicProducerSpi");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Map beans = this.applicationContext.getBeansOfType((Class)clazz);
        Collection producers = beans.values();
        Iterator iter = producers.iterator();
        while (iter.hasNext()) {
            GetLegendGraphicProducerSpi factory = (GetLegendGraphicProducerSpi)iter.next();
            if (!factory.canProduce(outputFormat)) continue;
            return factory.createLegendProducer(outputFormat);
        }
        throw new WmsException("There is no support for creating legends in " + outputFormat + " format", "InvalidFormat");
    }

    public static boolean supportsFormat(String mimeType, ApplicationContext context) {
        return GetLegendGraphicResponse.loadLegendFormats(context).contains(mimeType);
    }

    public static Set getFormats(ApplicationContext context) {
        return GetLegendGraphicResponse.loadLegendFormats(context);
    }

    private static Set loadLegendFormats(ApplicationContext applicationContext) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.vfny.geoserver.wms.GetLegendGraphicProducerSpi");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Map beans = applicationContext.getBeansOfType((Class)clazz);
        Collection producers = beans.values();
        HashSet formats = new HashSet();
        Iterator iter = producers.iterator();
        while (iter.hasNext()) {
            GetLegendGraphicProducerSpi producer = (GetLegendGraphicProducerSpi)iter.next();
            formats.addAll(producer.getSupportedFormats());
        }
        return formats;
    }

    public String getContentDisposition() {
        return null;
    }
}

