/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.util.Range;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.renderer.lite.LiteShape2;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;

public abstract class DefaultRasterLegendProducer
implements GetLegendGraphicProducer {
    private static final Logger LOGGER;
    private static final SLDStyleFactory styleFactory;
    private static final double TOLERANCE = 1.0E-6;
    private static final StyledShapePainter shapePainter;
    private static final GeometryFactory geomFac;
    public static final Color BG_COLOR;
    private static final ImageObserver imgObs;
    private static final float hpaddingFactor = 0.15f;
    private static final float vpaddingFactor = 0.15f;
    private BufferedImage legendGraphic;
    private boolean renderingStopRequested;
    private LiteShape2 sampleRect;
    private LiteShape2 sampleLine;
    private LiteShape2 samplePoint;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.wms.responses.DefaultRasterLegendProducer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.getPackage().getName());
        styleFactory = new SLDStyleFactory();
        shapePainter = new StyledShapePainter(null);
        geomFac = new GeometryFactory();
        BG_COLOR = Color.WHITE;
        imgObs = new Canvas();
    }

    public void produceLegendGraphic(GetLegendGraphicRequest request) throws WmsException {
        Feature sampleFeature = this.createSampleFeature(request.getLayer());
        Style gt2Style = request.getStyle();
        FeatureTypeStyle[] ftStyles = gt2Style.getFeatureTypeStyles();
        double scaleDenominator = request.getScale();
        Rule[] applicableRules = request.getRule() != null ? new Rule[]{request.getRule()} : this.getApplicableRules(ftStyles, scaleDenominator);
        NumberRange scaleRange = new NumberRange(scaleDenominator, scaleDenominator);
        int ruleCount = applicableRules.length;
        ArrayList<BufferedImage> legendsStack = new ArrayList<BufferedImage>(ruleCount);
        int w = request.getWidth();
        int h = request.getHeight();
        int i = 0;
        while (i < ruleCount) {
            Symbolizer[] symbolizers = applicableRules[i].getSymbolizers();
            BufferedImage image = new BufferedImage(w, h, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(BG_COLOR);
            graphics.fillRect(0, 0, w, h);
            int sIdx = 0;
            while (sIdx < symbolizers.length) {
                Symbolizer symbolizer = symbolizers[sIdx];
                if (symbolizer instanceof RasterSymbolizer) {
                    BufferedImage imgShape = new BufferedImage(w, h, 2);
                    try {
                        imgShape = ImageIO.read(new URL(request.getHttpServletRequest().getRequestURL() + "/../data/images/rasterLegend.png"));
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        throw new WmsException(e);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        throw new WmsException(e);
                    }
                    graphics.drawImage(imgShape, 0, 0, w, h, null);
                } else {
                    Style2D style2d = styleFactory.createStyle(sampleFeature, symbolizer, (Range)scaleRange);
                    LiteShape2 shape = this.getSampleShape(symbolizer, w, h);
                    if (style2d != null) {
                        shapePainter.paint(graphics, shape, style2d, scaleDenominator);
                    }
                }
                ++sIdx;
            }
            legendsStack.add(image);
            ++i;
        }
        this.legendGraphic = DefaultRasterLegendProducer.mergeLegends(legendsStack, applicableRules);
    }

    private BufferedImage scaleImage(BufferedImage image, GetLegendGraphicRequest request) {
        int w = request.getWidth();
        int h = request.getHeight();
        BufferedImage scaledImage = new BufferedImage(w, h, 2);
        Graphics2D graphics = scaledImage.createGraphics();
        graphics.setColor(BG_COLOR);
        graphics.fillRect(0, 0, w, h);
        AffineTransform xform = new AffineTransform();
        xform.setToScale((double)w / (double)image.getWidth(), (double)h / (double)image.getHeight());
        graphics.drawImage(image, xform, null);
        return scaledImage;
    }

    private static BufferedImage mergeLegends(List imageStack, Rule[] rules) {
        if (imageStack.size() == 0) {
            throw new IllegalArgumentException("No legend graphics passed");
        }
        BufferedImage finalLegend = null;
        if (imageStack.size() == 1) {
            finalLegend = (BufferedImage)imageStack.get(0);
        } else {
            int imgCount = imageStack.size();
            String[] labels = new String[imgCount];
            BufferedImage img = (BufferedImage)imageStack.get(0);
            FontMetrics fontMetrics = img.getGraphics().getFontMetrics();
            int rowHeight = Math.max(fontMetrics.getHeight(), img.getHeight());
            int totalHeight = rowHeight * imgCount;
            int totalWidth = 0;
            int i = 0;
            while (i < imgCount) {
                img = (BufferedImage)imageStack.get(i);
                Rule rule = rules[i];
                labels[i] = rule.getTitle();
                if (labels[i] == null) {
                    labels[i] = rule.getName();
                }
                int w = img.getWidth();
                if (labels[i] != null) {
                    Graphics g = img.getGraphics();
                    w += g.getFontMetrics().stringWidth(labels[i]);
                }
                totalWidth = Math.max(w, totalWidth);
                ++i;
            }
            finalLegend = new BufferedImage(totalWidth, totalHeight, 2);
            Graphics2D finalGraphics = finalLegend.createGraphics();
            finalGraphics.setColor(BG_COLOR);
            finalGraphics.fillRect(0, 0, totalWidth, totalHeight);
            int h = 0;
            int i2 = 0;
            while (i2 < imgCount) {
                img = (BufferedImage)imageStack.get(i2);
                int y = h;
                if (img.getHeight() < rowHeight) {
                    y += (int)((double)(rowHeight - img.getHeight()) / 2.0);
                }
                finalGraphics.drawImage((Image)img, 0, y, imgObs);
                if (labels[i2] != null) {
                    finalGraphics.setColor(Color.BLACK);
                    y = h + rowHeight - fontMetrics.getDescent();
                    if (fontMetrics.getHeight() < rowHeight) {
                        y -= (int)((double)(rowHeight - fontMetrics.getHeight()) / 2.0);
                    }
                    finalGraphics.drawString(labels[i2], img.getWidth(), y);
                }
                h += rowHeight;
                ++i2;
            }
        }
        return finalLegend;
    }

    private LiteShape2 getSampleShape(Symbolizer symbolizer, int legendWidth, int legendHeight) {
        LiteShape2 sampleShape;
        float hpad = (float)legendWidth * 0.15f;
        float vpad = (float)legendHeight * 0.15f;
        if (symbolizer instanceof LineSymbolizer) {
            if (this.sampleLine == null) {
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)((float)legendHeight - vpad)), new Coordinate((double)((float)legendWidth - hpad), (double)vpad)};
                LineString geom = geomFac.createLineString(coords);
                try {
                    this.sampleLine = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleLine = null;
                }
            }
            sampleShape = this.sampleLine;
        } else if (symbolizer instanceof PolygonSymbolizer || symbolizer instanceof RasterSymbolizer) {
            if (this.sampleRect == null) {
                float w = (float)legendWidth - 2.0f * hpad;
                float h = (float)legendHeight - 2.0f * vpad;
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)vpad), new Coordinate((double)hpad, (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)vpad), new Coordinate((double)hpad, (double)vpad)};
                LinearRing shell = geomFac.createLinearRing(coords);
                Polygon geom = geomFac.createPolygon(shell, null);
                try {
                    this.sampleRect = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleRect = null;
                }
            }
            sampleShape = this.sampleRect;
        } else if (symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) {
            if (this.samplePoint == null) {
                Coordinate coord = new Coordinate((double)(legendWidth / 2), (double)(legendHeight / 2));
                try {
                    this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                }
                catch (Exception e) {
                    this.samplePoint = null;
                }
            }
            sampleShape = this.samplePoint;
        } else {
            throw new IllegalArgumentException("Unknown symbolizer: " + symbolizer);
        }
        return sampleShape;
    }

    private Feature createSampleFeature(FeatureType schema) throws WmsException {
        Feature sampleFeature;
        try {
            AttributeType[] atts = schema.getAttributeTypes();
            Object[] attributes = new Object[atts.length];
            int i = 0;
            while (i < atts.length) {
                attributes[i] = atts[i].createDefaultValue();
                ++i;
            }
            sampleFeature = schema.create(attributes);
        }
        catch (IllegalAttributeException e) {
            e.printStackTrace();
            throw new WmsException(e);
        }
        return sampleFeature;
    }

    private Rule[] getApplicableRules(FeatureTypeStyle[] ftStyles, double scaleDenominator) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        int i = 0;
        while (i < ftStyles.length) {
            FeatureTypeStyle fts = ftStyles[i];
            Rule[] rules = fts.getRules();
            int j = 0;
            while (j < rules.length) {
                Rule r = rules[j];
                if (this.isWithInScale(r, scaleDenominator)) {
                    ruleList.add(r);
                }
                ++j;
            }
            ++i;
        }
        return ruleList.toArray(new Rule[ruleList.size()]);
    }

    private boolean isWithInScale(Rule r, double scaleDenominator) {
        return scaleDenominator == -1.0 || r.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator;
    }

    public BufferedImage getLegendGraphic() {
        if (this.legendGraphic == null) {
            throw new IllegalStateException();
        }
        return this.legendGraphic;
    }

    public void abort() {
        this.renderingStopRequested = true;
    }
}

